/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.labelingrules;

import java.util.StringTokenizer;
import org.openjdk.jmc.ui.common.labelingrules.Constants;
import org.openjdk.jmc.ui.common.labelingrules.Formatter;
import org.openjdk.jmc.ui.common.labelingrules.Matcher;
import org.openjdk.jmc.ui.common.resource.Resource;

public final class NamingRule {
    private final String normalizedExpression;
    private final Matcher matcher;
    private final Formatter formatter;
    private final int priority;
    private final String name;
    private final Resource icon;

    public NamingRule(String name, String matchingPart, String formattingPart, int priority, Resource icon) {
        this(name, NamingRule.createNormalizedExpression(matchingPart, formattingPart), priority, icon);
    }

    public NamingRule(String name, String normalizedExpression, int priority, Resource icon) {
        this.normalizedExpression = normalizedExpression;
        if (normalizedExpression.equals("")) {
            throw new IllegalArgumentException("Invalid rule - you may not add empty rules!");
        }
        String expandedExpression = NamingRule.replaceConstants(normalizedExpression);
        String[] expressions = expandedExpression.split("=>");
        if (expressions.length != 2) {
            throw new IllegalArgumentException("Invalid rule - need both match part and transform part.");
        }
        this.matcher = new Matcher(expressions[0]);
        this.formatter = new Formatter(expressions[1]);
        this.priority = priority;
        this.icon = icon;
        this.name = name;
    }

    private static String createNormalizedExpression(String matchPart, String formattingPart) {
        return String.valueOf(matchPart) + "=>" + formattingPart;
    }

    public String getNormalizedExpression() {
        return this.normalizedExpression;
    }

    public boolean matches(Object[] values) {
        return this.matcher.matches(values);
    }

    public String format(Object[] values) {
        return this.formatter.format(values);
    }

    public String toString() {
        return "MatchingRule [name: " + this.name + ", expression: " + this.normalizedExpression + "]";
    }

    public int hashCode() {
        return this.normalizedExpression.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamingRule)) {
            return false;
        }
        return this.normalizedExpression.equals(((NamingRule)obj).normalizedExpression);
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }

    private static String replaceConstants(String rule) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(rule, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("{")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("Found unmatched { in rule!");
                }
                String content = stringTokenizer.nextToken();
                if (Constants.getInstance().containsConstant(content)) {
                    token = Constants.getInstance().getConstant(content).toString();
                    stringTokenizer.nextToken();
                } else {
                    token = String.valueOf(token) + content;
                }
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    public Resource getImageResource() {
        return this.icon;
    }
}

