/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.memory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IDiagnosticCommandService;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MementoToolkit;

public class HeapHistogram
extends MCSectionPart {
    private static final Pattern LINE_PATTERN = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(.+)");
    private static final String DIAGNOSTIC_COMMAND = "GC.class_histogram -all=false";
    private final IDiagnosticCommandService service;
    private final Map<String, HistogramItem> model = new HashMap<String, HistogramItem>();
    private final ColumnManager columnManager;
    private final Action resetAction = new Action(Messages.HeapHistogram_RESET_DELTA_ACTION_TEXT){

        public void run() {
            for (HistogramItem item : HeapHistogram.this.model.values()) {
                item.memoryReference = item.memory;
            }
            HeapHistogram.this.columnManager.getViewer().refresh();
        }
    };

    private void refreshHistogram() {
        boolean showWarning = ConsolePlugin.getDefault().getPreferenceStore().getBoolean("console.ui.heaphistogram.update.warning");
        boolean doUpdate = false;
        if (showWarning) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getSection().getShell(), (String)Messages.HeapHistogram_WARNING_DIALOG_TITLE, (String)Messages.HeapHistogram_JVM_PERFORMANCE_WILL_BE_AFFECTED, (String)Messages.HeapHistogram_SHOW_WARNING_BEFORE_UPDATING, (boolean)true, null, null);
            if (dialog.getReturnCode() == 0) {
                doUpdate = true;
                if (!dialog.getToggleState()) {
                    ConsolePlugin.getDefault().getPreferenceStore().setValue("console.ui.heaphistogram.update.warning", false);
                }
            }
        } else {
            doUpdate = true;
        }
        if (doUpdate) {
            new Job(Messages.HeapHistogram_REFRESHING_HEAP_HISTOGRAM){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        final String result = HeapHistogram.this.service.runCtrlBreakHandlerWithResult(HeapHistogram.DIAGNOSTIC_COMMAND);
                        if (!monitor.isCanceled()) {
                            DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!HeapHistogram.this.columnManager.getViewer().getControl().isDisposed()) {
                                        boolean firstUpdate = HeapHistogram.this.model.size() == 0;
                                        HeapHistogram.this.parseHistogram(String.valueOf(result));
                                        if (firstUpdate) {
                                            for (HistogramItem item : HeapHistogram.this.model.values()) {
                                                item.memoryReference = item.memory;
                                            }
                                        }
                                        HeapHistogram.this.columnManager.getViewer().refresh();
                                    }
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return new Status(4, "org.openjdk.jmc.console.ui", Messages.HeapHistogram_FAILED_TO_REFRESH, (Throwable)e);
                    }
                }
            }.schedule();
        }
    }

    private HeapHistogram(Composite parent, FormToolkit toolkit, IDiagnosticCommandService service, IMemento state) {
        super(parent, toolkit, Messages.HeapHistogram_TITLE);
        this.service = service;
        this.resetAction.setDescription(Messages.HeapHistogram_RESET_DELTA_ACTION_DESCRIPTION);
        this.resetAction.setToolTipText(Messages.HeapHistogram_RESET_DELTA_ACTION_TOOLTOP);
        this.resetAction.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("undo.gif"));
        IAction refreshAction = ActionToolkit.commandAction(this::refreshHistogram, (String)"org.eclipse.ui.file.refresh");
        refreshAction.setToolTipText(Messages.HeapHistogram_REFRESH_ACTION_TOOLTIP);
        refreshAction.setDescription(Messages.HeapHistogram_REFRESH_ACTION_TOOLTIP);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Table table = toolkit.createTable(body, 268501762);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput(this.model.values());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        IColumn classColumn = new ColumnBuilder(Messages.HeapHistogram_CLASS_COLUMN_TEXT, "className", HistogramItem.GET_CLASS).build();
        IColumn countColumn = new ColumnBuilder(Messages.HeapHistogram_INSTANCES_COLUMN_TEXT, "count", HistogramItem.GET_COUNT).style(131072).build();
        IColumn bytesColumn = new ColumnBuilder(Messages.HeapHistogram_SIZE_COLUMN_TEXT, "size", HistogramItem.GET_SIZE).style(131072).build();
        IColumn deltaColumn = new ColumnBuilder(Messages.HeapHistogram_DELTA_COLUMN_TEXT, "delta", HistogramItem.GET_DELTA).style(131072).build();
        List<IColumn> columns = Arrays.asList(classColumn, countColumn, bytesColumn, deltaColumn);
        this.columnManager = ColumnManager.build((TableViewer)viewer, columns, (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        MCContextMenuManager mm = MCContextMenuManager.create((Control)table);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)mm);
        mm.appendToGroup("additions", refreshAction);
        mm.appendToGroup("additions", (IAction)this.resetAction);
        InFocusHandlerActivator.install((Control)table, (IAction)refreshAction);
        this.getMCToolBarManager().add((IAction)this.resetAction);
        this.getMCToolBarManager().add(refreshAction);
        this.getMCToolBarManager().update();
    }

    void saveState(IMemento memento) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)memento));
    }

    private void parseHistogram(String histogram) {
        this.model.values().forEach(item -> {
            int n = item.count = 0;
        });
        Matcher m = LINE_PATTERN.matcher(histogram);
        while (m.find()) {
            int count = Integer.parseInt(m.group(1));
            long memory = Long.parseLong(m.group(2));
            String className = m.group(3).trim();
            HistogramItem item2 = this.model.get(className);
            if (item2 == null) {
                item2 = new HistogramItem();
                item2.className = className;
                this.model.put(className, item2);
            }
            item2.count = count;
            item2.memory = memory;
        }
        Iterator<HistogramItem> iterator = this.model.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().count != 0) continue;
            iterator.remove();
        }
    }

    public static HeapHistogram create(Composite parent, FormToolkit toolkit, IConnectionHandle connection, IMemento state) {
        IDiagnosticCommandService service = (IDiagnosticCommandService)connection.getServiceOrNull(IDiagnosticCommandService.class);
        return service == null ? null : new HeapHistogram(parent, toolkit, service, state);
    }

    private static class HistogramItem {
        String className;
        int count;
        long memory;
        long memoryReference;
        static final IMemberAccessor<String, HistogramItem> GET_CLASS = new IMemberAccessor<String, HistogramItem>(){

            public String getMember(HistogramItem i) {
                return TypeHandling.simplifyType((String)i.className);
            }
        };
        static final IMemberAccessor<Integer, HistogramItem> GET_COUNT = new IMemberAccessor<Integer, HistogramItem>(){

            public Integer getMember(HistogramItem i) {
                return i.count;
            }
        };
        static final IMemberAccessor<IQuantity, HistogramItem> GET_SIZE = new IMemberAccessor<IQuantity, HistogramItem>(){

            public IQuantity getMember(HistogramItem i) {
                return UnitLookup.BYTE.quantity(i.memory);
            }
        };
        static final IMemberAccessor<IQuantity, HistogramItem> GET_DELTA = new IMemberAccessor<IQuantity, HistogramItem>(){

            public IQuantity getMember(HistogramItem i) {
                return UnitLookup.BYTE.quantity(i.memory - i.memoryReference);
            }
        };

        private HistogramItem() {
        }
    }
}

