/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.system;

import java.util.Arrays;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.util.MemberAccessorToolkit;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.ColumnsFilter;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class SystemPropertiesSectionPart
extends MCSectionPart {
    final ColumnManager columnManager;

    public SystemPropertiesSectionPart(Composite parent, FormToolkit toolkit, ISubscriptionService subscriptionService, IMemento state) {
        super(parent, toolkit, Messages.SystemTab_SECTION_SYSTEM_PROPERTIES_TEXT);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite filterComposite = toolkit.createComposite(body);
        filterComposite.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        Table table = toolkit.createTable(body, 268501762);
        table.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        IColumn categoryColumn = new ColumnBuilder(Messages.COLUMN_KEY_TEXT, "key", MemberAccessorToolkit.compositeElement((String)"key")).build();
        IColumn valueColumn = new ColumnBuilder(Messages.COLUMN_VALUE_TEXT, "value", MemberAccessorToolkit.compositeElement((String)"value")).build();
        this.columnManager = ColumnManager.build((TableViewer)viewer, Arrays.asList(categoryColumn, valueColumn), (TableSettings)TableSettings.forState((IState)MementoToolkit.asState((IMemento)state)));
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.columnManager, (MCContextMenuManager)MCContextMenuManager.create((Control)table));
        this.addSubscription(subscriptionService);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        ColumnsFilter.addFilterControl((Composite)filterComposite, (FormToolkit)toolkit, (ColumnManager)this.columnManager);
    }

    public void saveState(IMemento state) {
        this.columnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    private void addSubscription(ISubscriptionService subscriptionService) {
        MRI attributeDescriptor = new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Runtime", "SystemProperties");
        subscriptionService.addMRIValueListener(attributeDescriptor, new IMRIValueListener(){

            public void valueChanged(final MRIValueEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)SystemPropertiesSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).SystemPropertiesSectionPart.this.columnManager.getViewer().getControl().isDisposed()) {
                            SystemPropertiesSectionPart.this.setInputAndSort(event);
                        }
                    }
                });
            }
        });
        MRIValueEvent e = subscriptionService.getLastMRIValueEvent(attributeDescriptor);
        if (e != null) {
            this.setInputAndSort(e);
        }
    }

    private void setInputAndSort(MRIValueEvent event) {
        Object v = event.getValue();
        if (v instanceof TabularData) {
            this.columnManager.getViewer().setInput(((TabularData)v).values());
        }
    }
}

