/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.openjdk.jmc.console.agent.AgentPlugin;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.IConnectionListener;
import org.openjdk.jmc.rjmx.IServerHandle;

public final class AgentJmxHelper {
    private static final String AGENT_OBJECT_NAME = "org.openjdk.jmc.jfr.agent:type=AgentController";
    private static final String DEFINE_EVENT_PROBES = "defineEventProbes";
    private static final String RETRIEVE_EVENT_PROBES = "retrieveEventProbes";
    private static final String RETRIEVE_CURRENT_TRANSFORMS = "retrieveCurrentTransforms";
    private static final String CONNECTION_USAGE = "Agent MBean";
    private final IServerHandle serverHandle;
    private final IConnectionHandle connectionHandle;
    private final MBeanServerConnection mbsc;
    private final Set<IConnectionListener> connectionListeners = new HashSet<IConnectionListener>();

    public AgentJmxHelper(IServerHandle serverHandle) throws ConnectionException {
        this.serverHandle = Objects.requireNonNull(serverHandle);
        this.connectionHandle = serverHandle.connect(CONNECTION_USAGE, this::onConnectionChange);
        this.mbsc = (MBeanServerConnection)this.connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
    }

    public IServerHandle getServerHandle() {
        return this.serverHandle;
    }

    public IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public void addConnectionChangedListener(IConnectionListener connectionListener) {
        this.connectionListeners.add(Objects.requireNonNull(connectionListener));
    }

    public void removeConnectionChangedListener(IConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    public boolean isLocalJvm() {
        return this.connectionHandle.getServerDescriptor().getJvmInfo() != null;
    }

    public boolean isMXBeanRegistered() {
        try {
            return this.mbsc.isRegistered(new ObjectName(AGENT_OBJECT_NAME));
        }
        catch (IOException | MalformedObjectNameException e) {
            AgentPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not check if agent MXBean is registered", e);
            return false;
        }
    }

    public String retrieveEventProbes() {
        try {
            Object result = this.mbsc.invoke(new ObjectName(AGENT_OBJECT_NAME), RETRIEVE_EVENT_PROBES, new Object[0], new String[0]);
            return result.toString();
        }
        catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Could not retrieve event probes", e);
            return null;
        }
    }

    public CompositeData[] retrieveCurrentTransforms() {
        try {
            Object result = this.mbsc.invoke(new ObjectName(AGENT_OBJECT_NAME), RETRIEVE_CURRENT_TRANSFORMS, new Object[0], new String[0]);
            return (CompositeData[])result;
        }
        catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Could not retrieve current transforms", e);
            return null;
        }
    }

    public void defineEventProbes(String xmlDescription) {
        try {
            Object[] params = new Object[]{xmlDescription};
            String[] signature = new String[]{String.class.getName()};
            this.mbsc.invoke(new ObjectName(AGENT_OBJECT_NAME), DEFINE_EVENT_PROBES, params, signature);
        }
        catch (IOException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Could not define event probes: " + xmlDescription, e);
        }
    }

    public void onConnectionChange(IConnectionHandle connection) {
        for (IConnectionListener listener : this.connectionListeners) {
            listener.onConnectionChange(connection);
        }
    }
}

