/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.model.LocalStorageDelegate;
import org.openjdk.jmc.console.agent.manager.model.Preset;
import org.xml.sax.SAXException;

public class PresetRepository {
    private static final String DEFAULT_FILE_NAME = "new_preset.xml";
    private static final String FILE_NAME_EXTENSION = ".xml";
    private static final Pattern NAME_WITH_COUNT_PATTERN = Pattern.compile("^(.*)_(\\d+)$");
    private static final Pattern COUNT_SUFFIX_PATTERN = Pattern.compile("^_(\\d+)$");
    private List<IPreset> presets = new ArrayList<IPreset>();

    protected PresetRepository() {
    }

    public void removePreset(IPreset configuration) {
        if (this.presets.remove(configuration)) {
            configuration.delete();
        }
    }

    public void addPreset(IPreset configuration) throws IOException {
        this.presets.add(configuration);
        if (configuration.getStorageDelegate() == null) {
            configuration.setStorageDelegate(LocalStorageDelegate.getDelegate(configuration.getFileName()));
        }
        configuration.save();
    }

    public boolean containsPreset(IPreset configuration) {
        return this.presets.contains(configuration);
    }

    public IPreset[] listPresets() {
        return this.presets.toArray(new IPreset[0]);
    }

    public void updatePreset(IPreset original, IPreset workingCopy) throws IOException {
        if (this.containsPreset(original)) {
            this.removePreset(original);
            original.delete();
            this.addPreset(workingCopy);
        }
    }

    public IPreset createPreset() {
        String fileName = this.nextUniqueName(DEFAULT_FILE_NAME);
        Preset preset = new Preset(this);
        preset.setFileName(fileName);
        return preset;
    }

    public void importPreset(File file) throws IOException, SAXException {
        IPreset preset = this.createPreset();
        preset.setFileName(this.nextUniqueName(file.getName()));
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            preset.deserialize(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.addPreset(preset);
    }

    public void exportPreset(IPreset preset, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(preset.serialize().getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    String nextUniqueName(String originalName) {
        String baseName = originalName = originalName.trim();
        if (baseName.endsWith(FILE_NAME_EXTENSION)) {
            baseName = baseName.substring(0, baseName.lastIndexOf(FILE_NAME_EXTENSION));
        }
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IPreset preset : this.presets) {
            String tempName = preset.getFileName().trim();
            if (tempName.endsWith(FILE_NAME_EXTENSION)) {
                tempName = tempName.substring(0, tempName.lastIndexOf(FILE_NAME_EXTENSION));
            }
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return String.valueOf(baseName) + FILE_NAME_EXTENSION;
        }
        return String.valueOf(baseName) + '_' + proposedCount + FILE_NAME_EXTENSION;
    }
}

