/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xml.sax.SAXParseException;

public class ValidationResult {
    private List<SAXParseException> warnings = new ArrayList<SAXParseException>();
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();
    private SAXParseException fatalError;

    public ValidationResult(ArrayList<SAXParseException> warnings, ArrayList<SAXParseException> errors, SAXParseException fatalError) {
        this.warnings = Objects.requireNonNull(warnings);
        this.errors = Objects.requireNonNull(errors);
        this.fatalError = fatalError;
    }

    public ValidationResult() {
    }

    public void addError(SAXParseException error) {
        this.errors.add(error);
    }

    public void addWarning(SAXParseException warning) {
        this.warnings.add(warning);
    }

    public void setFatalError(SAXParseException fatalError) {
        this.fatalError = fatalError;
    }

    public boolean isValid() {
        return this.errors.isEmpty() && this.fatalError == null;
    }

    public List<SAXParseException> getWarnings() {
        return this.warnings;
    }

    public List<SAXParseException> getErrors() {
        return this.errors;
    }

    public SAXParseException getFatalError() {
        return this.fatalError;
    }
}

