/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.FlavorToolkit;
import org.openjdk.jmc.flightrecorder.ui.selection.IFlavoredSelection;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStore;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class FlavorSelector
implements SelectionStore.SelectionStoreListener {
    private final IItemFilter filter;
    private final IItemCollection items;
    private final IPageContainer pageContainer;
    private final SelectionWithThreadAndRangeConsumer onSelectWithThreads;
    private final Composite container;
    private final ComboViewer selectionCombo;
    private final ComboViewer flavorCombo;
    private final Canvas canvas;
    private final RangePainter painter;
    private Button showButton;
    private Button resetButton;
    private Button showConcurrentButton;
    private Button rangeStyleButton;
    private Button sameThreadsButton;
    private boolean callbackActive = false;
    private List<IAttribute<?>> attributes;
    private FlavorSelectorState flavorSelectorState;

    public static FlavorSelector itemsWithTimerange(Form form, IItemFilter filter, IItemCollection items, IPageContainer pageContainer, BiConsumer<IItemCollection, IRange<IQuantity>> onSelect, Consumer<Boolean> onShow, FlavorSelectorState flavorSelectorState) {
        return new FlavorSelector(form, filter, null, items, pageContainer, (itemCollection, threadNames, range) -> onSelect.accept(itemCollection, range), Optional.ofNullable(onShow), flavorSelectorState);
    }

    public static FlavorSelector itemsWithTimerange(Form form, IItemFilter filter, List<IAttribute<?>> attributes, IItemCollection items, IPageContainer pageContainer, SelectionWithThreadAndRangeConsumer onSelectWithThreads, FlavorSelectorState flavorSelectorState) {
        return new FlavorSelector(form, filter, attributes, items, pageContainer, onSelectWithThreads, Optional.ofNullable(null), flavorSelectorState);
    }

    public static FlavorSelector itemsWithTimerange(Form form, IItemFilter filter, List<IAttribute<?>> attributes, IItemCollection items, IPageContainer pageContainer, BiConsumer<IItemCollection, IRange<IQuantity>> onSelect, FlavorSelectorState flavorSelectorState) {
        return new FlavorSelector(form, filter, attributes, items, pageContainer, (itemCollection, threadNames, range) -> onSelect.accept(itemCollection, range), Optional.ofNullable(null), flavorSelectorState);
    }

    public static FlavorSelector itemsWithTimerange(Form form, IItemFilter filter, IItemCollection items, IPageContainer pageContainer, BiConsumer<IItemCollection, IRange<IQuantity>> onSelect, FlavorSelectorState flavorSelectorState) {
        return new FlavorSelector(form, filter, null, items, pageContainer, (itemCollection, threadNames, range) -> onSelect.accept(itemCollection, range), Optional.ofNullable(null), flavorSelectorState);
    }

    private FlavorSelector(Form form, IItemFilter filter, List<IAttribute<?>> attributes, IItemCollection items, IPageContainer pageContainer, SelectionWithThreadAndRangeConsumer onSelectWithThreads, Optional<Consumer<Boolean>> onShow, FlavorSelectorState flavorSelectorState) {
        this.filter = filter;
        this.attributes = attributes;
        this.items = items;
        this.pageContainer = pageContainer;
        this.onSelectWithThreads = onSelectWithThreads;
        this.flavorSelectorState = flavorSelectorState = flavorSelectorState != null ? flavorSelectorState : new FlavorSelectorState();
        this.container = new Composite(form.getHead(), 0);
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).spacing(2, 2).create());
        Composite selectorRow = new Composite(this.container, 0);
        selectorRow.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        selectorRow.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(10).create());
        Label selectionLabel = new Label(selectorRow, 0);
        selectionLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        selectionLabel.setText(Messages.FlavorSelector_LABEL_SELECTION);
        this.selectionCombo = new ComboViewer(selectorRow);
        this.selectionCombo.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().hint(200, -1).minSize(100, -1).grab(false, false).create());
        this.selectionCombo.setContentProvider((IContentProvider)new SelectionComboContentProvider());
        this.selectionCombo.setLabelProvider((IBaseLabelProvider)new SelectionComboLabelProvider());
        this.selectionCombo.addSelectionChangedListener((ISelectionChangedListener)new SelectionComboSelectionListener());
        Label flavorLabel = new Label(selectorRow, 0);
        flavorLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        flavorLabel.setText(Messages.FlavorSelector_LABEL_ASPECT);
        this.flavorCombo = new ComboViewer(selectorRow);
        this.flavorCombo.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().hint(300, -1).minSize(100, -1).grab(true, false).create());
        this.flavorCombo.setContentProvider((IContentProvider)new FlavorComboContentProvider());
        this.flavorCombo.setLabelProvider((IBaseLabelProvider)new FlavorComboLabelProvider());
        this.flavorCombo.addSelectionChangedListener((ISelectionChangedListener)new FlavorComboSelectionListener());
        this.showConcurrentButton = new Button(selectorRow, 32);
        this.showConcurrentButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.showConcurrentButton.setText(Messages.FlavorSelector_BUTTON_SHOW_CONCURRENT);
        this.showConcurrentButton.setToolTipText(Messages.FlavorSelector_BUTTON_SHOW_CONCURRENT_TOOLTIP);
        this.showConcurrentButton.setSelection(this.flavorSelectorState.showConcurrent);
        this.showConcurrentButton.addSelectionListener((SelectionListener)new ShowConcurrentSelectionListener());
        this.rangeStyleButton = new Button(selectorRow, 32);
        this.rangeStyleButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.rangeStyleButton.setText(Messages.FlavorSelector_BUTTON_CONTAINED);
        this.rangeStyleButton.setToolTipText(Messages.FlavorSelector_BUTTON_CONTAINED_TOOLTIP);
        this.rangeStyleButton.setEnabled(this.showConcurrentButton.getSelection());
        this.rangeStyleButton.setSelection(flavorSelectorState.concurrentContained);
        this.rangeStyleButton.addSelectionListener((SelectionListener)new RangeStyleSelectionListener());
        this.sameThreadsButton = new Button(selectorRow, 32);
        this.sameThreadsButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.sameThreadsButton.setText(Messages.FlavorSelector_BUTTON_SAME_THREADS);
        this.sameThreadsButton.setToolTipText(Messages.FlavorSelector_BUTTON_SAME_THREADS_TOOLTIP);
        this.sameThreadsButton.setEnabled(this.showConcurrentButton.getSelection());
        this.sameThreadsButton.setSelection(flavorSelectorState.sameThreads);
        this.sameThreadsButton.addSelectionListener((SelectionListener)new SameThreadsSelectionListener());
        onShow.ifPresent(on -> {
            Label rangeLabel = new Label(selectorRow, 0);
            rangeLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            rangeLabel.setText(Messages.FlavorSelector_LABEL_TIMERANGE);
            this.showButton = new Button(selectorRow, 8);
            this.showButton.setText(Messages.FlavorSelector_BUTTON_TIMERANGE_SET);
            this.showButton.setToolTipText(Messages.FlavorSelector_BUTTON_TIMERANGE_SET_TOOLTIP);
            this.showButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.resetButton = new Button(selectorRow, 8);
            this.resetButton.setText(Messages.FlavorSelector_BUTTON_TIMERANGE_CLEAR);
            this.resetButton.setToolTipText(Messages.FlavorSelector_BUTTON_TIMERANGE_CLEAR_TOOLTIP);
            this.resetButton.addListener(13, e -> on.accept(false));
            this.resetButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            this.showButton.addListener(13, e -> on.accept(true));
        });
        this.canvas = new Canvas(this.container, 262144);
        this.canvas.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).hint(-1, 7).grab(true, false).create());
        this.painter = new RangePainter((Control)this.canvas, pageContainer.getRecordingRange());
        this.selectionCombo.setInput((Object)pageContainer.getSelectionStore());
        this.selectionCombo.setSelection(this.getCurrentSelection());
        this.callbackActive = true;
        this.enableSelection();
        IItemStreamFlavor currentFlavor = null;
        if (pageContainer.getSelectionStore().isCurrentActive()) {
            currentFlavor = this.getSelectedFlavor();
        }
        this.useFlavor(currentFlavor);
        pageContainer.getSelectionStore().setListener(this);
        form.setHeadClient((Control)this.container);
    }

    private ISelection getCurrentSelection() {
        return this.pageContainer.getSelectionStore().getCurrentSelection() != null ? new StructuredSelection((Object)this.pageContainer.getSelectionStore().getCurrentSelection()) : new StructuredSelection(this.selectionCombo.getElementAt(0));
    }

    @Override
    public void selectionActive(boolean active) {
        this.selectionCombo.setSelection(this.getCurrentSelection());
    }

    @Override
    public void selectionAdded(SelectionStore.SelectionStoreEntry selection) {
        if (!this.selectionCombo.getControl().isDisposed()) {
            this.selectionCombo.refresh();
        }
    }

    private static String formatRange(IRange<IQuantity> range) {
        return String.valueOf(((IQuantity)range.getStart()).displayUsing("auto")) + " - ( " + ((IQuantity)range.getExtent()).displayUsing("auto") + " ) - " + ((IQuantity)range.getEnd()).displayUsing("auto");
    }

    public void enableSelection() {
        this.pageContainer.getSelectionStore().setCurrentActive(true);
        this.selectionCombo.getCombo().setEnabled(true);
        this.flavorCombo.getCombo().setEnabled(true);
    }

    public FlavorSelectorState getFlavorSelectorState() {
        return this.flavorSelectorState;
    }

    private IItemStreamFlavor getSelectedFlavor() {
        Object obj;
        ISelection s = this.flavorCombo.getSelection();
        if (s instanceof IStructuredSelection && (obj = ((IStructuredSelection)s).getFirstElement()) instanceof IItemStreamFlavor) {
            return (IItemStreamFlavor)obj;
        }
        return null;
    }

    private void useFlavor(IItemStreamFlavor flavor) {
        if (this.callbackActive) {
            Optional<IRange<IQuantity>> range = FlavorToolkit.getRange(flavor);
            this.painter.current = range.orElse(null);
            this.canvas.setVisible(this.painter.current != null);
            this.canvas.setToolTipText((String)range.map(FlavorSelector::formatRange).orElse(null));
            this.container.redraw();
            IItemCollection itemsToUse = null;
            Set<IMCThread> threads = FlavorToolkit.getThreads(this.getSelectedFlavor(), this.flavorSelectorState.showConcurrent, this.flavorSelectorState.sameThreads);
            if (flavor != null && !flavor.isEmpty().booleanValue()) {
                IItemFilter rangeAndThreadFilter = FlavorToolkit.getRangeAndThreadFilter(range, threads, this.flavorSelectorState.showConcurrent, this.flavorSelectorState.concurrentContained, this.flavorSelectorState.sameThreads);
                itemsToUse = rangeAndThreadFilter != null ? this.items.apply(rangeAndThreadFilter) : (IItemCollection)flavor.evaluate();
            }
            Set<String> threadNames = FlavorToolkit.getThreadNames(threads, flavor);
            this.onSelectWithThreads.accept(itemsToUse, threadNames, range.orElse(this.pageContainer.getRecordingRange()));
        }
    }

    public void trimFlavorMaps() {
        if ((long)this.flavorSelectorState.calculatedFlavorsMap.size() > 2L * this.pageContainer.getSelectionStore().getSelections().count()) {
            IFlavoredSelection selection;
            List storedSelections = this.pageContainer.getSelectionStore().getSelections().map(sse -> sse.getSelection()).collect(Collectors.toList());
            Iterator<Map.Entry<IFlavoredSelection, Object>> iterator = this.flavorSelectorState.calculatedFlavorsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                selection = iterator.next().getKey();
                if (storedSelections.contains(selection)) continue;
                iterator.remove();
            }
            iterator = this.flavorSelectorState.selectedFlavorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                selection = iterator.next().getKey();
                if (storedSelections.contains(selection)) continue;
                iterator.remove();
            }
        }
    }

    private static final class FlavorComboContentProvider
    implements IStructuredContentProvider {
        private IItemStreamFlavor[] flavors;

        private FlavorComboContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IItemStreamFlavor[]) {
                this.flavors = (IItemStreamFlavor[])newInput;
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.flavors == null || this.flavors.length == 0) {
                return new String[]{"<" + Messages.FlavorSelector_LABEL_NO_SELECTION + ">"};
            }
            return this.flavors;
        }
    }

    private static final class FlavorComboLabelProvider
    extends LabelProvider {
        private FlavorComboLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IItemStreamFlavor) {
                IItemStreamFlavor sel = (IItemStreamFlavor)element;
                return sel.getName();
            }
            return super.getText(element);
        }
    }

    private final class FlavorComboSelectionListener
    implements ISelectionChangedListener {
        private FlavorComboSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            IItemStreamFlavor flavor = null;
            if (event.getSelection() instanceof IStructuredSelection && (obj = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IItemStreamFlavor) {
                flavor = (IItemStreamFlavor)obj;
                SelectionStore.SelectionStoreEntry entry = FlavorSelector.this.pageContainer.getSelectionStore().getCurrentSelection();
                if (entry != null) {
                    FlavorSelector.this.flavorSelectorState.selectedFlavorMap.put(entry.getSelection(), flavor);
                }
            }
            FlavorSelector.this.useFlavor(flavor);
        }
    }

    public static class FlavorSelectorState {
        private boolean showConcurrent = false;
        private boolean concurrentContained = false;
        private boolean sameThreads = true;
        private Map<IFlavoredSelection, IItemStreamFlavor[]> calculatedFlavorsMap = new HashMap<IFlavoredSelection, IItemStreamFlavor[]>();
        private Map<IFlavoredSelection, IItemStreamFlavor> selectedFlavorMap = new HashMap<IFlavoredSelection, IItemStreamFlavor>();

        public void clearFlavorMaps() {
            this.calculatedFlavorsMap.clear();
            this.selectedFlavorMap.clear();
        }
    }

    private static class RangePainter
    implements PaintListener {
        private final Control canvas;
        private final IQuantity start;
        private final IQuantity end;
        IRange<IQuantity> current;

        RangePainter(Control canvas, IRange<IQuantity> fullRange) {
            this.canvas = canvas;
            this.start = (IQuantity)fullRange.getStart();
            this.end = (IQuantity)fullRange.getEnd();
            canvas.addPaintListener((PaintListener)this);
        }

        public void paintControl(PaintEvent e) {
            if (this.current != null) {
                Point size = this.canvas.getSize();
                e.gc.setBackground(SWTColorToolkit.getColor((RGB)new RGB(200, 200, 200)));
                e.gc.setForeground(SWTColorToolkit.getColor((RGB)new RGB(120, 120, 120)));
                e.gc.fillRectangle(0, 0, size.x, size.y);
                e.gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
                SubdividedQuantityRange fullRangeAxis = new SubdividedQuantityRange(this.start, this.end, size.x, 25);
                int x1 = (int)fullRangeAxis.getPixel((IQuantity)this.current.getStart());
                int x2 = (int)Math.ceil(fullRangeAxis.getPixel((IQuantity)this.current.getEnd()));
                e.gc.setForeground(SWTColorToolkit.getColor((RGB)new RGB(221, 58, 22)));
                e.gc.setBackground(SWTColorToolkit.getColor((RGB)new RGB(252, 128, 3)));
                e.gc.fillGradientRectangle(x1, 0, x2 - x1, size.y, true);
                e.gc.setForeground(SWTColorToolkit.getColor((RGB)new RGB(0, 0, 0)));
                e.gc.drawRectangle(x1, 0, x2 - x1 - 1, size.y - 1);
            }
        }
    }

    public class RangeStyleSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            FlavorSelector.this.flavorSelectorState.concurrentContained = FlavorSelector.this.rangeStyleButton.getSelection();
            FlavorSelector.this.useFlavor(FlavorSelector.this.getSelectedFlavor());
        }
    }

    public class SameThreadsSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            FlavorSelector.this.flavorSelectorState.sameThreads = FlavorSelector.this.sameThreadsButton.getSelection();
            FlavorSelector.this.useFlavor(FlavorSelector.this.getSelectedFlavor());
        }
    }

    private static final class SelectionComboContentProvider
    implements IStructuredContentProvider {
        private SelectionStore store;

        private SelectionComboContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof SelectionStore) {
                this.store = (SelectionStore)newInput;
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.store.getSelections().toArray();
        }
    }

    private static final class SelectionComboLabelProvider
    extends LabelProvider {
        private SelectionComboLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SelectionStore.SelectionStoreEntry) {
                SelectionStore.SelectionStoreEntry entry = (SelectionStore.SelectionStoreEntry)element;
                return entry.getName();
            }
            return super.getText(element);
        }
    }

    private final class SelectionComboSelectionListener
    implements ISelectionChangedListener {
        private SelectionComboSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            FlavorSelector.this.flavorCombo.getCombo().removeAll();
            if (event.getSelection() instanceof IStructuredSelection && (obj = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof SelectionStore.SelectionStoreEntry) {
                SelectionStore.SelectionStoreEntry entry = (SelectionStore.SelectionStoreEntry)obj;
                IFlavoredSelection selection = entry.getSelection();
                FlavorSelector.this.pageContainer.getSelectionStore().setCurrent(selection);
                IItemStreamFlavor[] flavors = FlavorSelector.this.flavorSelectorState.calculatedFlavorsMap.get(selection);
                if (flavors == null) {
                    flavors = (IItemStreamFlavor[])selection.getFlavors(FlavorSelector.this.filter, FlavorSelector.this.items, FlavorSelector.this.attributes).toArray(IItemStreamFlavor[]::new);
                    FlavorSelector.this.flavorSelectorState.calculatedFlavorsMap.put(selection, flavors);
                }
                FlavorSelector.this.flavorCombo.setInput((Object)flavors);
                IItemStreamFlavor selectedFlavor = FlavorSelector.this.flavorSelectorState.selectedFlavorMap.get(selection);
                if (selectedFlavor == null && flavors.length > 0) {
                    selectedFlavor = flavors[0];
                    FlavorSelector.this.flavorSelectorState.selectedFlavorMap.put(selection, selectedFlavor);
                }
                if (selectedFlavor != null) {
                    FlavorSelector.this.flavorCombo.setSelection((ISelection)new StructuredSelection((Object)selectedFlavor));
                }
                FlavorSelector.this.trimFlavorMaps();
            }
        }
    }

    public static interface SelectionWithThreadAndRangeConsumer {
        public void accept(IItemCollection var1, Set<String> var2, IRange<IQuantity> var3);
    }

    public class ShowConcurrentSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            FlavorSelector.this.flavorSelectorState.showConcurrent = FlavorSelector.this.showConcurrentButton.getSelection();
            FlavorSelector.this.rangeStyleButton.setEnabled(FlavorSelector.this.flavorSelectorState.showConcurrent);
            FlavorSelector.this.sameThreadsButton.setEnabled(FlavorSelector.this.flavorSelectorState.showConcurrent);
            FlavorSelector.this.useFlavor(FlavorSelector.this.getSelectedFlavor());
        }
    }
}

