/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.PersistableItemFilter;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.flightrecorder.ui.EventTypeFolderNode;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.TypeFilterBuilder;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ActionUiToolkit;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class LaneEditor {
    private static final IItemFilter TYPE_HAS_THREAD_AND_DURATION = new IItemFilter(){

        public Predicate<IItem> getPredicate(IType<IItem> type) {
            if (DataPageToolkit.isTypeWithThreadAndDuration(type)) {
                return PredicateToolkit.truePredicate();
            }
            return PredicateToolkit.falsePredicate();
        }
    };

    public static List<LaneDefinition> openDialog(EventTypeFolderNode root, List<LaneDefinition> lanes, String title, String description) {
        EditLanesWizardPage page = new EditLanesWizardPage(root, lanes);
        page.setTitle(title);
        page.setDescription(description);
        if (OnePageWizardDialog.open((IWizardPage)page, (int)500, (int)600) == 0) {
            return page.getLanes().stream().filter(LaneEditor::laneIncludesTypes).collect(Collectors.toList());
        }
        return lanes;
    }

    private static boolean laneIncludesTypes(LaneDefinition ld) {
        return ld.isRestLane() || ld.getFilter() instanceof ItemFilters.Types && ((ItemFilters.Types)ld.getFilter()).getTypes().size() > 0;
    }

    private static IItemFilter getRestFilter(List<LaneDefinition> lanesInput) {
        List<IItemFilter> laneFilters = lanesInput.stream().filter(ld -> !ld.isRestLane).map(ld -> ld.getFilter()).collect(Collectors.toList());
        IItemFilter laneFilter = ItemFilters.or((IItemFilter[])laneFilters.toArray(new IItemFilter[laneFilters.size()]));
        return ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.not((IItemFilter)laneFilter), TYPE_HAS_THREAD_AND_DURATION});
    }

    public static LaneDefinition ensureRestLane(List<LaneDefinition> lanesInput) {
        LaneDefinition newRestLane;
        LaneDefinition oldRestLane = lanesInput.stream().filter(ld -> ld.isRestLane).findAny().orElse(null);
        IItemFilter restFilter = LaneEditor.getRestFilter(lanesInput);
        if (oldRestLane == null) {
            newRestLane = new LaneDefinition(Messages.LANES_OTHER_TYPES, false, restFilter, true);
            lanesInput.add(newRestLane);
        } else {
            newRestLane = new LaneDefinition(oldRestLane.name, oldRestLane.enabled, restFilter, true);
            lanesInput.set(lanesInput.indexOf(oldRestLane), newRestLane);
        }
        return newRestLane;
    }

    static class EditLanesContainer
    extends Composite {
        final EventTypeFolderNode root;
        final List<LaneDefinition> lanes;
        private LaneDefinition restLane;
        private TypeFilterBuilder filterEditor;
        private CheckboxTableViewer lanesViewer;
        private Object selected;
        private Runnable updateChart;
        private boolean isDropdownFilter;

        EditLanesContainer(Composite parent, EventTypeFolderNode root, List<LaneDefinition> lanes) {
            this(parent, root, lanes, null);
        }

        EditLanesContainer(Composite parent, EventTypeFolderNode root, List<LaneDefinition> lanes, Runnable action) {
            super(parent, 0);
            this.root = root;
            this.lanes = lanes;
            this.updateChart = action;
            this.restLane = LaneEditor.ensureRestLane(lanes);
            this.init();
        }

        public List<LaneDefinition> getLanes() {
            return this.lanes;
        }

        private void init() {
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
            Composite laneHeaderContainer = new Composite((Composite)this, 0);
            laneHeaderContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            laneHeaderContainer.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            IAction moveUpAction = ActionToolkit.action(() -> this.moveSelected(true), (String)Messages.LANES_MOVE_UP_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("up_nav.gif"));
            IAction moveDownAction = ActionToolkit.action(() -> this.moveSelected(false), (String)Messages.LANES_MOVE_DOWN_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("down_nav.gif"));
            IAction addAction = ActionToolkit.action(this::addLane, (String)Messages.LANES_ADD_LANE_ACTION, (ImageDescriptor)UIPlugin.getDefault().getMCImageDescriptor("add.gif"));
            IAction removeAction = ActionToolkit.commandAction(this::deleteSelected, (String)"org.eclipse.ui.edit.delete");
            Control toolbar = ActionUiToolkit.buildToolBar((Composite)laneHeaderContainer, Stream.of(moveUpAction, moveDownAction, addAction, removeAction), (boolean)false);
            toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            Label lanesTitle = new Label(laneHeaderContainer, 0);
            lanesTitle.setText(Messages.LANES_EDITOR_LABEL);
            lanesTitle.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            Label filterTitle = new Label((Composite)this, 0);
            filterTitle.setText(Messages.LANES_FILTER_LABEL);
            filterTitle.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000008).create());
            this.lanesViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2560);
            TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.lanesViewer, 0);
            viewerColumn.getColumn().setText(Messages.LANES_LANE_COLUMN);
            viewerColumn.getColumn().setWidth(200);
            viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.lanesViewer){
                private String currentName;

                protected void setValue(Object element, Object value) {
                    String newName = value.toString();
                    if (this.currentName != null && this.currentName.equals(newName)) {
                        return;
                    }
                    LaneDefinition oldLd = (LaneDefinition)element;
                    LaneDefinition newLane = new LaneDefinition(value.toString(), oldLd.enabled, oldLd.filter, oldLd.isRestLane);
                    int elementIndex = lanes.indexOf(element);
                    lanes.set(elementIndex, newLane);
                    lanesViewer.replace((Object)newLane, elementIndex);
                    this.getViewer().update(element, null);
                }

                protected Object getValue(Object element) {
                    this.currentName = ((LaneDefinition)element).getName();
                    return this.currentName;
                }

                protected CellEditor getCellEditor(Object element) {
                    return new TextCellEditor((Composite)this.getViewer().getControl());
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            this.lanesViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof LaneDefinition) {
                        if (element == selected) {
                            return ((LaneDefinition)element).getNameOrCount(filterEditor.getCheckedTypeIds().count());
                        }
                        return ((LaneDefinition)element).getName();
                    }
                    return super.getText(element);
                }
            });
            this.lanesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            new ToolTip(this.lanesViewer.getControl(), 2, false){

                protected ViewerCell getToolTipArea(Event event) {
                    return lanesViewer.getCell(new Point(event.x, event.y));
                }

                protected Composite createToolTipContentArea(Event event, Composite parent) {
                    FormText formText = CompositeToolkit.createInfoFormText((Composite)parent);
                    Object element = this.getToolTipArea(event).getElement();
                    Stream<Object> ids = Stream.empty();
                    if (element == selected) {
                        ids = filterEditor.getCheckedTypeIds();
                    } else if (element instanceof LaneDefinition && ((LaneDefinition)element).filter instanceof ItemFilters.Types) {
                        ids = ((ItemFilters.Types)((LaneDefinition)element).filter).getTypes().stream();
                    }
                    StringBuilder sb = new StringBuilder();
                    ids.forEach(typeId -> {
                        Color color = TypeLabelProvider.getColorOrDefault(typeId);
                        formText.setImage(typeId, SWTColorToolkit.getColorThumbnail((RGB)SWTColorToolkit.asRGB((Color)color)));
                        sb.append("<li style='image' value='" + typeId + "'>" + typeId + "</li>");
                    });
                    if (sb.length() > 0) {
                        sb.insert(0, "<form>");
                        sb.append("</form>");
                        formText.setText(sb.toString(), true, false);
                    } else {
                        formText.setText(Messages.LANES_CHECK_TO_INCLUDE, false, false);
                    }
                    return formText;
                }
            };
            this.lanesViewer.setInput(this.lanes);
            this.lanesViewer.setCheckedElements(this.lanes.stream().filter(ld -> ld.isEnabled()).toArray());
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.lanesViewer.getControl());
            mm.appendToGroup("group.edit", moveUpAction);
            mm.appendToGroup("group.edit", moveDownAction);
            mm.appendToGroup("group.edit", addAction);
            mm.appendToGroup("group.edit", removeAction);
            this.filterEditor = new TypeFilterBuilder(this, this::onTypeFilterChange);
            this.filterEditor.setInput(this.root);
            this.filterEditor.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.isDropdownFilter = this.updateChart != null;
            this.lanesViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
            this.lanesViewer.addSelectionChangedListener(e -> this.laneSelectionChanges(((IStructuredSelection)e.getSelection()).getFirstElement()));
            LaneDefinition firstLane = this.lanes.get(0);
            this.lanesViewer.setSelection((ISelection)new StructuredSelection((Object)firstLane));
        }

        private void addLane() {
            int selectIndex = Math.max(0, this.lanes.indexOf(this.selected));
            IItemFilter emptyFilter = ItemFilters.type(Collections.emptySet());
            LaneDefinition newEmpty = new LaneDefinition(null, false, emptyFilter, false);
            this.lanes.add(selectIndex + 1, newEmpty);
            this.lanesViewer.insert((Object)newEmpty, selectIndex + 1);
            this.lanesViewer.setSelection((ISelection)new StructuredSelection((Object)newEmpty));
        }

        private void onTypeFilterChange() {
            LaneDefinition selectedLane;
            if (this.selected instanceof LaneDefinition && (selectedLane = (LaneDefinition)this.selected).isRestLane()) {
                DialogToolkit.showWarningDialogAsync((Display)this.lanesViewer.getControl().getDisplay(), (String)Messages.LANES_EDIT_NOT_ALLOWED_WARNING, (String)NLS.bind((String)Messages.LANES_EDIT_NOT_ALLOWED_WARNING_DESC, (Object)selectedLane.getName()));
            }
            this.lanesViewer.update(this.selected, null);
            if (this.isDropdownFilter) {
                this.updateChart();
            }
        }

        private void deleteSelected() {
            int selectIndex = Math.max(0, this.lanes.indexOf(this.selected) - 1);
            if (this.selected instanceof LaneDefinition && ((LaneDefinition)this.selected).isRestLane()) {
                this.lanes.remove(this.selected);
                this.lanesViewer.setSelection((ISelection)new StructuredSelection((Object)this.lanes.get(selectIndex)));
                this.lanesViewer.refresh();
            } else {
                DialogToolkit.showWarningDialogAsync((Display)this.lanesViewer.getControl().getDisplay(), (String)Messages.LANES_DELETE_NOT_ALLOWED_WARNING, (String)NLS.bind((String)Messages.LANES_DELETE_NOT_ALLOWED_WARNING_DESC, (Object)((LaneDefinition)this.selected).getName()));
            }
        }

        private void moveSelected(boolean up) {
            int fromIndex = this.lanes.indexOf(this.selected);
            int toIndex = fromIndex + (up ? -1 : 1);
            if (fromIndex >= 0 && toIndex >= 0 && toIndex < this.lanes.size()) {
                LaneDefinition removed = this.lanes.remove(fromIndex);
                this.lanes.add(toIndex, removed);
                this.lanesViewer.refresh();
            }
        }

        private void laneSelectionChanges(Object newSelected) {
            int selectedIndex = this.lanes.indexOf(newSelected);
            if (selectedIndex == -1 && this.isDropdownFilter) {
                selectedIndex = this.findLaneDefinitionIndexByName(this.selected);
            }
            this.saveFilter();
            this.selected = this.lanes.get(selectedIndex);
            if (this.selected instanceof LaneDefinition) {
                ItemFilters.Types typesFilter = ((LaneDefinition)this.selected).getFilter() instanceof ItemFilters.Types ? (ItemFilters.Types)((LaneDefinition)this.selected).getFilter() : (ItemFilters.Types)ItemFilters.convertToTypes((IItemFilter)((LaneDefinition)this.selected).getFilter(), this.filterEditor.getAllTypes());
                this.filterEditor.selectTypes(typesFilter.getTypes());
            }
            if (this.isDropdownFilter) {
                this.updateChart();
            }
        }

        private void updateChart() {
            this.saveFilter();
            this.updateChart.run();
        }

        private int findLaneDefinitionIndexByName(Object selected) {
            int index = -1;
            if (selected != null) {
                int i = 0;
                while (i < this.lanes.size()) {
                    if (this.lanes.get(i).getName().equals(((LaneDefinition)selected).getName())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            return index;
        }

        private void saveFilter() {
            int selectedIndex = this.lanes.indexOf(this.selected);
            if (selectedIndex == -1 && this.isDropdownFilter) {
                selectedIndex = this.findLaneDefinitionIndexByName(this.selected);
            }
            if (selectedIndex >= 0) {
                LaneDefinition ld = this.lanes.get(selectedIndex);
                IItemFilter newFilter = ItemFilters.type(this.filterEditor.getCheckedTypeIds().collect(Collectors.toSet()));
                LaneDefinition newLd = new LaneDefinition(ld.name, this.lanesViewer.getChecked((Object)ld), newFilter, ld.isRestLane);
                this.lanes.set(selectedIndex, newLd);
                this.lanesViewer.replace((Object)newLd, selectedIndex);
                if (ld.isRestLane()) {
                    this.restLane = newLd;
                } else {
                    LaneDefinition newRest = new LaneDefinition(this.restLane.name, this.restLane.enabled, LaneEditor.getRestFilter(this.lanes), true);
                    int restIndex = this.findLaneDefinitionIndexByName(this.restLane);
                    this.lanes.set(restIndex, newRest);
                    this.lanesViewer.replace((Object)newRest, restIndex);
                    this.restLane = newRest;
                }
                this.lanesViewer.refresh();
            }
        }
    }

    private static class EditLanesWizardPage
    extends WizardPage
    implements IPerformFinishable {
        private EditLanesContainer container;
        protected EventTypeFolderNode root;
        private List<LaneDefinition> lanes;

        private EditLanesWizardPage(EventTypeFolderNode root, Collection<LaneDefinition> lanesInput) {
            super("EditFilterLanesPage");
            this.root = root;
            this.lanes = new ArrayList<LaneDefinition>(lanesInput);
        }

        public List<LaneDefinition> getLanes() {
            return this.lanes;
        }

        public void createControl(Composite parent) {
            this.container = new EditLanesContainer(parent, this.root, this.lanes);
            this.setControl((Control)this.container);
        }

        public boolean performFinish() {
            this.container.saveFilter();
            int i = 0;
            while (i < this.lanes.size()) {
                LaneDefinition ld = this.lanes.get(i);
                if (ld.isEnabled() != this.container.lanesViewer.getChecked((Object)ld)) {
                    this.lanes.set(i, new LaneDefinition(ld.name, this.container.lanesViewer.getChecked((Object)ld), ld.filter, ld.isRestLane));
                }
                ++i;
            }
            return true;
        }
    }

    public static class LaneDefinition
    implements IDescribable,
    IStateful {
        private static final String FILTER = "filter";
        private static final String NAME = "name";
        private static final String ENABLED = "enabled";
        private static final String IS_REST_LANE = "isRestLane";
        private final String name;
        private final IItemFilter filter;
        private final boolean enabled;
        private final boolean isRestLane;

        public LaneDefinition(String name, boolean enabled, IItemFilter filter, boolean isRestLane) {
            this.name = name;
            this.enabled = enabled;
            this.filter = filter;
            this.isRestLane = isRestLane;
        }

        public String getName() {
            long count = this.filter instanceof ItemFilters.Types ? ((ItemFilters.Types)this.filter).getTypes().size() : 0;
            return this.getNameOrCount(count);
        }

        public String getNameOrCount(long count) {
            return this.name != null ? this.name : (count == 1L && ((ItemFilters.Types)this.filter).getTypes().iterator().hasNext() ? (String)((ItemFilters.Types)this.filter).getTypes().iterator().next() : (count > 0L ? NLS.bind((String)Messages.LANES_DEFINITION_NAME, (Object)count) : Messages.LANES_EMPTY_LANE));
        }

        public String getDescription() {
            return NLS.bind((String)Messages.LANES_DEFINITION_DESC, (Object)this.getName());
        }

        public IItemFilter getFilter() {
            return this.filter;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRestLane() {
            return this.isRestLane;
        }

        public boolean isEnabledAndNotRestLane() {
            return this.enabled && !this.isRestLane;
        }

        public void saveTo(IWritableState writableState) {
            writableState.putString(NAME, this.name);
            StateToolkit.writeBoolean((IWritableState)writableState, (String)ENABLED, (Boolean)this.enabled);
            StateToolkit.writeBoolean((IWritableState)writableState, (String)IS_REST_LANE, (Boolean)this.isRestLane);
            if (!this.isRestLane && this.filter != null) {
                ((PersistableItemFilter)this.filter).saveTo(writableState.createChild(FILTER));
            }
        }

        public static LaneDefinition readFrom(IState memento) {
            IItemFilter filter;
            String name = memento.getAttribute(NAME);
            boolean enabled = StateToolkit.readBoolean((IState)memento, (String)ENABLED, (Boolean)false);
            boolean isRestLane = StateToolkit.readBoolean((IState)memento, (String)IS_REST_LANE, (Boolean)false);
            IState filterState = memento.getChild(FILTER);
            if (isRestLane) {
                filter = null;
            } else if (filterState != null) {
                filter = PersistableItemFilter.readFrom((IState)filterState);
            } else {
                throw new UnsupportedOperationException("Null filter not allowed for thread lane: " + name);
            }
            return new LaneDefinition(name, enabled, filter, isRestLane);
        }

        public String toString() {
            return String.valueOf(this.getName()) + "(" + this.enabled + ")";
        }
    }
}

