/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogramWithInput;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class ConstantPoolsPage
extends AbstractDataPage {
    private static final String TABLE = "table";
    private static final String CONSTANT_TABLE = "constantTable";
    private static final String TYPE_FILTER = "typeFilter";
    private static final String PERCENT_POOLS = "percentPools";
    private static final String VALUE_FILTER = "valueFilter";
    private static final ItemHistogram.ItemHistogramBuilder BY_TYPE_CONSTANT_POOLS_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();
    private static final ItemHistogram.ItemHistogramBuilder CONSTANT_HISTOGRAM = new ItemHistogram.ItemHistogramBuilder();

    static {
        BY_TYPE_CONSTANT_POOLS_HISTOGRAM.addColumn(JdkAttributes.CONSTANT_POOLS_COUNT);
        BY_TYPE_CONSTANT_POOLS_HISTOGRAM.addColumn(JdkAttributes.CONSTANT_POOLS_SIZE);
        BY_TYPE_CONSTANT_POOLS_HISTOGRAM.addPercentageColumn(PERCENT_POOLS, Aggregators.sum((IAttribute)JdkAttributes.CONSTANT_POOLS_SIZE), Messages.ConstantPoolsPage_SIZE_TOTAL_PERCENTAGE, Messages.ConstantPoolsPage_SIZE_TOTAL_PERCENTAGE_DESC);
        CONSTANT_HISTOGRAM.addCountColumn();
    }

    public ConstantPoolsPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new ConstantPoolsPageUi(parent, toolkit, pageContainer, state);
    }

    public static class ConstantPoolsPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.ConstantPoolsPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/cpool.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"constant_pools"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new ConstantPoolsPage(dpd, items, editor);
        }
    }

    private class ConstantPoolsPageUi
    implements IPageUI {
        private static final String SASH_ELEMENT = "sash";
        private final IItemCollection constPoolItems;
        private final IPageContainer container;
        private final SashForm sash;
        private final ItemHistogram byTypeTable;
        private final ItemHistogram constantValueTable;
        private FilterComponent byTypeFilter;
        private FilterComponent constantValueFilter;
        private IItemCollection selectionConstPoolItems;
        private IItemCollection selectionConstantItems;
        private ItemHistogramWithInput byTypeHistogram;
        private ItemHistogramWithInput constantHistogram;

        ConstantPoolsPageUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            this.container = pageContainer;
            this.selectionConstPoolItems = this.constPoolItems = ConstantPoolsPage.this.getDataSource().getConstantPools();
            this.selectionConstantItems = ConstantPoolsPage.this.getDataSource().getConstants();
            Form form = DataPageToolkit.createForm(parent, toolkit, ConstantPoolsPage.this.getName(), ConstantPoolsPage.this.getIcon());
            this.sash = new SashForm(form.getBody(), 512);
            toolkit.adapt((Composite)this.sash);
            this.byTypeTable = BY_TYPE_CONSTANT_POOLS_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.CONSTANT_POOLS_NAME, new TableSettings(state.getChild(ConstantPoolsPage.TABLE)));
            MCContextMenuManager mm = MCContextMenuManager.create((Control)this.byTypeTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.byTypeTable.getManager(), (MCContextMenuManager)mm);
            this.byTypeFilter = FilterComponent.createFilterComponent(this.byTypeTable, null, this.constPoolItems, pageContainer.getSelectionStore()::getSelections, this::onTypeFilterChange);
            mm.add(this.byTypeFilter.getShowSearchAction());
            this.constantValueTable = CONSTANT_HISTOGRAM.buildWithoutBorder((Composite)this.sash, JdkAttributes.CONSTANT_VALUE, new TableSettings(state.getChild(ConstantPoolsPage.CONSTANT_TABLE)));
            mm = MCContextMenuManager.create((Control)this.constantValueTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.constantValueTable.getManager(), (MCContextMenuManager)mm);
            this.constantValueFilter = FilterComponent.createFilterComponent(this.constantValueTable, null, ConstantPoolsPage.this.getDataSource().getConstants(), pageContainer.getSelectionStore()::getSelections, this::onValueFilterChange);
            mm.add(this.constantValueFilter.getShowSearchAction());
            this.byTypeHistogram = new ItemHistogramWithInput(this.byTypeTable);
            this.constantHistogram = new ItemHistogramWithInput(this.constantValueTable);
            this.byTypeHistogram.addListener(this::typeHistogramListener);
            this.constantHistogram.addListener(this.container::showSelection);
            PersistableSashForm.loadState((SashForm)this.sash, (IState)state.getChild(SASH_ELEMENT));
            this.byTypeFilter.loadState(state.getChild(ConstantPoolsPage.TYPE_FILTER));
            this.constantValueFilter.loadState(state.getChild(ConstantPoolsPage.VALUE_FILTER));
        }

        private void typeHistogramListener(IItemCollection constantPoolType) {
            String poolName = (String)ItemToolkit.getFirstFound((IItemCollection)constantPoolType, (IAttribute)JdkAttributes.CONSTANT_POOLS_NAME);
            IItemCollection filteredItems = ConstantPoolsPage.this.getDataSource().getConstants().apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.CONSTANT_TYPE, (Object)poolName));
            this.constantHistogram.setInput(filteredItems);
            this.container.showSelection(filteredItems);
        }

        private void onTypeFilterChange(IItemFilter filter) {
            this.byTypeFilter.filterChangeHelper(filter, this.byTypeTable, this.selectionConstPoolItems);
        }

        private void onValueFilterChange(IItemFilter filter) {
            this.constantValueFilter.filterChangeHelper(filter, this.constantValueTable, this.selectionConstantItems);
        }

        public void saveTo(IWritableState writableState) {
            PersistableSashForm.saveState((SashForm)this.sash, (IWritableState)writableState.createChild(SASH_ELEMENT));
            this.byTypeTable.getManager().getSettings().saveState(writableState.createChild(ConstantPoolsPage.TABLE));
            this.byTypeFilter.saveState(writableState.createChild(ConstantPoolsPage.TYPE_FILTER));
            this.constantValueTable.getManager().getSettings().saveState(writableState.createChild(ConstantPoolsPage.CONSTANT_TABLE));
            this.constantValueFilter.saveState(writableState.createChild(ConstantPoolsPage.VALUE_FILTER));
        }
    }
}

