/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.FilterComponent;
import org.openjdk.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.PersistableSashForm;

public class GCConfigurationPage
extends AbstractDataPage {
    private static final String GC_FLAG_SASH = "gcFlagSash";
    private static final String JVM_GC_FLAGS = "jvmFlags";
    private static final String JVM_FLAGS_FILTER = "jvmFlagsFilter";
    private static final Set<String> FLAGS;
    private static final IItemFilter FLAGS_FILTER;
    private static final IAccessorFactory<?> FLAG_VALUE_FIELD;
    private static final String FLAG_VALUE_COL_ID = "value";
    private static final ItemHistogram.CompositeKeyHistogramBuilder FLAG_HISTOGRAM;
    private IItemFilter perGCFagsFilter;
    private IItemFilter userInputFlagsFilter;
    private ColumnManager.SelectionState flagsSelection;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("jdk.LongFlag");
        types.add("jdk.UnsignedLongFlag");
        types.add("jdk.DoubleFlag");
        types.add("jdk.BooleanFlag");
        types.add("jdk.StringFlag");
        types.add("jdk.IntFlag");
        types.add("jdk.UnsignedIntFlag");
        FLAGS = Collections.unmodifiableSet(types);
        FLAGS_FILTER = ItemFilters.type(FLAGS);
        FLAG_VALUE_FIELD = new IAccessorFactory<Object>(){

            public <T> IMemberAccessor<?, T> getAccessor(IType<T> type) {
                switch (type.getIdentifier()) {
                    case "jdk.IntFlag": 
                    case "jdk.UnsignedLongFlag": 
                    case "jdk.LongFlag": 
                    case "jdk.UnsignedIntFlag": 
                    case "jdk.DoubleFlag": {
                        return JdkAttributes.FLAG_VALUE_NUMBER.getAccessor(type);
                    }
                    case "jdk.BooleanFlag": {
                        return JdkAttributes.FLAG_VALUE_BOOLEAN.getAccessor(type);
                    }
                    case "jdk.StringFlag": {
                        return JdkAttributes.FLAG_VALUE_TEXT.getAccessor(type);
                    }
                }
                return null;
            }
        };
        FLAG_HISTOGRAM = new ItemHistogram.CompositeKeyHistogramBuilder();
        FLAG_HISTOGRAM.addKeyColumn(JdkAttributes.FLAG_NAME);
        FLAG_HISTOGRAM.addKeyColumn(JdkAttributes.FLAG_ORIGIN);
        FLAG_HISTOGRAM.addKeyColumn(FLAG_VALUE_COL_ID, Messages.GCConfigurationPage_COLUMN_VALUE, FLAG_VALUE_FIELD);
    }

    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        return new GCInformationUi(parent, toolkit, pageContainer, state);
    }

    public GCConfigurationPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return ItemFilters.or((IItemFilter[])new IItemFilter[]{FLAGS_FILTER, JdkFilters.GC_CONFIG});
    }

    public static class GCConfigurationPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.GCConfigurationPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/gcconfig.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"gc_configuration"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new GCConfigurationPage(dpd, items, editor);
        }
    }

    static class GCFlagFilters {
        GCFlagFilters() {
        }

        private static IItemFilter useGCFlag() {
            return ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseEpsilonGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseG1GC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseZGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseShenandoahGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseConcMarkSweepGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseSerialGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseParallelGC")}), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_VALUE_BOOLEAN, (Object)true)});
        }

        private static IItemFilter collectorFlags(String usedGCFlag) {
            if (usedGCFlag == null) {
                return ItemFilters.all();
            }
            switch (usedGCFlag) {
                case "UseEpsilonGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseEpsilonGC"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^Epsilon.+")});
                }
                case "UseG1GC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseG1GC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"InitiatingHeapOccupancyPercent"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloading"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloadingWithConcurrentMark"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseStringDeduplication"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ParallelRefProcEnabled"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"MaxGCPauseMillis"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"GCPauseIntervalMillis"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseLargePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseTransparentHugePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseNUMA"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"AlwaysPreTouch"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^G1.+")});
                }
                case "UseZGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseZGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloading"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloadingWithConcurrentMark"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"SoftMaxHeapSize"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseLargePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseTransparentHugePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseNUMA"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseStringDeduplication"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"SoftRefLRUPolicyMSPerMB"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"AlwaysPreTouch"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^Z[A-Z].+")});
                }
                case "UseShenandoahGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseShenandoahGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloading"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ClassUnloadingWithConcurrentMark"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"SoftMaxHeapSize"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseStringDeduplication"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseLargePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseTransparentHugePages"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseNUMA"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"SoftRefLRUPolicyMSPerMB"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"AlwaysPreTouch"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^Shenandoah[A-Z].+")});
                }
                case "UseSerialGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseSerialGC")});
                }
                case "UseParallelGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseParallelGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"HeapMaximumCompactionInterval"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"HeapFirstMaximumCompactionCount"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseMaximumCompactionOnSystemGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ParallelOldDeadWoodLimiterMean"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ParallelOldDeadWoodLimiterStdDev"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"GCWorkerDelayMillis"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"PSChunkLargeArrays"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"HeapMaximumCompactionInterval"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseNUMA"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"AlwaysPreTouch"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^CMS[A-Z].+")});
                }
                case "UseConcMarkSweepGC": {
                    return ItemFilters.or((IItemFilter[])new IItemFilter[]{ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseConcMarkSweepGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"UseCMSInitiatingOccupancyOnly"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"BindCMSThreadToCPU"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"CPUForCMSThread"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ParallelRefProcEnabled"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"ScavengeBeforeFullGC"), ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (Object)"AlwaysPreTouch"), ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"^(CMS|FLS|ParGC)[A-Z_].+")});
                }
            }
            return ItemFilters.all();
        }

        public static IItemFilter collectorFlags(IItemCollection items) {
            String usedGC = ((Stream)items.apply(GCFlagFilters.useGCFlag()).values(JdkAttributes.FLAG_NAME).get()).distinct().findFirst().orElse("");
            return GCFlagFilters.collectorFlags(usedGC);
        }
    }

    private class GCInformationUi
    implements IPageUI {
        private final SashForm flagSash;
        private final ItemHistogram allFlagsTable;
        private final FilterComponent allFlagsFilter;

        public GCInformationUi(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
            Form form = DataPageToolkit.createForm(parent, toolkit, GCConfigurationPage.this.getName(), GCConfigurationPage.this.getIcon());
            SashForm container = new SashForm(form.getBody(), 512);
            SashForm gcConfigSash = new SashForm((Composite)container, 256);
            gcConfigSash.setSashWidth(5);
            gcConfigSash.addTraverseListener((TraverseListener)new SimpleTraverseListener());
            Section gcConfigSection = CompositeToolkit.createSection((Composite)gcConfigSash, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_GC_CONFIG);
            ItemAggregateViewer gcConfig = new ItemAggregateViewer((Composite)gcConfigSection, toolkit);
            gcConfig.addAggregate(JdkAggregators.YOUNG_COLLECTOR);
            gcConfig.addAggregate(JdkAggregators.OLD_COLLECTOR);
            gcConfig.addAggregate(JdkAggregators.CONCURRENT_GC_THREAD_COUNT_MIN);
            gcConfig.addAggregate(JdkAggregators.PARALLEL_GC_THREAD_COUNT_MIN);
            gcConfig.addAggregate(JdkAggregators.EXPLICIT_GC_CONCURRENT);
            gcConfig.addAggregate(JdkAggregators.EXPLICIT_GC_DISABLED);
            gcConfig.addAggregate(JdkAggregators.USE_DYNAMIC_GC_THREADS);
            gcConfig.addAggregate(JdkAggregators.GC_TIME_RATIO_MIN);
            gcConfigSection.setClient(gcConfig.getControl());
            Section heapConfigSection = CompositeToolkit.createSection((Composite)gcConfigSash, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_HEAP_CONFIG);
            ItemAggregateViewer heapConfig = new ItemAggregateViewer((Composite)heapConfigSection, toolkit);
            heapConfig.addAggregate(JdkAggregators.HEAP_CONF_INITIAL_SIZE_MIN);
            heapConfig.addAggregate(JdkAggregators.HEAP_CONF_MIN_SIZE);
            heapConfig.addAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
            heapConfig.addAggregate(JdkAggregators.USE_COMPRESSED_OOPS);
            heapConfig.addAggregate(JdkAggregators.COMPRESSED_OOPS_MODE);
            heapConfig.addAggregate(JdkAggregators.HEAP_ADDRESS_SIZE_MIN);
            heapConfig.addAggregate(JdkAggregators.HEAP_OBJECT_ALIGNMENT_MIN);
            heapConfigSection.setClient(heapConfig.getControl());
            Section ycConfigSection = CompositeToolkit.createSection((Composite)gcConfigSash, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_YOUNG_CONFIG);
            ItemAggregateViewer ycConfig = new ItemAggregateViewer((Composite)ycConfigSection, toolkit);
            ycConfig.addAggregate(JdkAggregators.YOUNG_GENERATION_MIN_SIZE);
            ycConfig.addAggregate(JdkAggregators.YOUNG_GENERATION_MAX_SIZE);
            ycConfig.addAggregate(JdkAggregators.NEW_RATIO_MIN);
            ycConfig.addAggregate(JdkAggregators.TENURING_THRESHOLD_INITIAL_MIN);
            ycConfig.addAggregate(JdkAggregators.TENURING_THRESHOLD_MAX);
            ycConfig.addAggregate(JdkAggregators.USES_TLABS);
            ycConfig.addAggregate(JdkAggregators.TLAB_MIN_SIZE);
            ycConfig.addAggregate(JdkAggregators.TLAB_REFILL_WASTE_LIMIT_MIN);
            ycConfigSection.setClient(ycConfig.getControl());
            gcConfig.setValues(GCConfigurationPage.this.getDataSource().getItems());
            heapConfig.setValues(GCConfigurationPage.this.getDataSource().getItems());
            ycConfig.setValues(GCConfigurationPage.this.getDataSource().getItems());
            this.flagSash = new SashForm((Composite)container, 512);
            toolkit.adapt((Composite)this.flagSash);
            GCConfigurationPage.this.perGCFagsFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{FLAGS_FILTER, GCFlagFilters.collectorFlags(GCConfigurationPage.this.getDataSource().getItems())});
            Section gcFlagsSection = CompositeToolkit.createSection((Composite)this.flagSash, (FormToolkit)toolkit, (String)Messages.GCConfigurationPage_SECTION_JVM_GC_FLAGS);
            this.allFlagsTable = FLAG_HISTOGRAM.buildWithoutBorder((Composite)gcFlagsSection, new TableSettings(state.getChild(GCConfigurationPage.JVM_GC_FLAGS)));
            this.allFlagsFilter = FilterComponent.createFilterComponent(this.allFlagsTable, GCConfigurationPage.this.userInputFlagsFilter, GCConfigurationPage.this.getDataSource().getItems().apply(GCConfigurationPage.this.perGCFagsFilter), pageContainer.getSelectionStore()::getSelections, this::onFlagsFilterChange);
            MCContextMenuManager flagsMm = MCContextMenuManager.create((Control)this.allFlagsTable.getManager().getViewer().getControl());
            ColumnMenusFactory.addDefaultMenus((ColumnManager)this.allFlagsTable.getManager(), (MCContextMenuManager)flagsMm);
            flagsMm.add(this.allFlagsFilter.getShowFilterAction());
            flagsMm.add(this.allFlagsFilter.getShowSearchAction());
            gcFlagsSection.setClient((Control)this.allFlagsFilter.getComponent());
            ColumnViewer flagViewer = this.allFlagsTable.getManager().getViewer();
            flagViewer.addSelectionChangedListener(e -> pageContainer.showSelection(this.allFlagsTable.getSelection().getItems()));
            PersistableSashForm.loadState((SashForm)this.flagSash, (IState)state.getChild(GCConfigurationPage.GC_FLAG_SASH));
            this.allFlagsFilter.loadState(GCConfigurationPage.this.getState().getChild(GCConfigurationPage.JVM_FLAGS_FILTER));
            this.allFlagsTable.show(GCConfigurationPage.this.getDataSource().getItems().apply(GCConfigurationPage.this.perGCFagsFilter));
            this.onFlagsFilterChange(GCConfigurationPage.this.userInputFlagsFilter);
            GCConfigurationPage.this.addResultActions(form);
            this.allFlagsTable.getManager().setSelectionState(GCConfigurationPage.this.flagsSelection);
        }

        public void saveTo(IWritableState memento) {
            this.allFlagsTable.getManager().getSettings().saveState(memento.createChild(GCConfigurationPage.JVM_GC_FLAGS));
            this.allFlagsFilter.saveState(memento.createChild(GCConfigurationPage.JVM_FLAGS_FILTER));
            PersistableSashForm.saveState((SashForm)this.flagSash, (IWritableState)memento.createChild(GCConfigurationPage.GC_FLAG_SASH));
            GCConfigurationPage.this.flagsSelection = this.allFlagsTable.getManager().getSelectionState();
        }

        private void onFlagsFilterChange(IItemFilter filter) {
            this.allFlagsFilter.filterChangeHelper(filter, this.allFlagsTable, GCConfigurationPage.this.getDataSource().getItems().apply(GCConfigurationPage.this.perGCFagsFilter));
            GCConfigurationPage.this.userInputFlagsFilter = filter;
        }
    }
}

