/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.IFilterFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.ISelectionFlavor;

public interface IPropertyFlavor
extends IFilterFlavor {
    public Stream<IProperty> getProperties();

    public static IPropertyFlavor build(IAttribute<?> attribute, Object value, IItemCollection items) {
        if (value instanceof Collection && ((Collection)value).size() == 1) {
            value = ((Collection)value).iterator().next();
        }
        if (value instanceof IRange) {
            ContentType type = attribute.getContentType();
            if (type instanceof KindOfQuantity) {
                return IPropertyFlavor.buildPointRange(attribute, (IRange<IQuantity>)((IRange)value), items);
            }
            if (type instanceof RangeContentType) {
                return IPropertyFlavor.buildRange(attribute, (IRange<IQuantity>)((IRange)value), items);
            }
        }
        if (value instanceof Set) {
            if (attribute.equals((Object)JfrAttributes.EVENT_TYPE)) {
                return IPropertyFlavor.build(ItemFilters.type((String[])((String[])((Set)value).stream().map(t -> ((IType)t).getIdentifier()).toArray(String[]::new))), items, attribute, value, NLS.bind((String)Messages.FLAVOR_IS_IN_SET, (Object)attribute.getName(), (Object)((Set)value).size()));
            }
            return IPropertyFlavor.build(ItemFilters.memberOf(attribute, (Set)((Set)value)), items, attribute, value, NLS.bind((String)Messages.FLAVOR_IS_IN_SET, (Object)attribute.getName(), (Object)((Set)value).size()));
        }
        if (attribute.equals((Object)JfrAttributes.EVENT_TYPE)) {
            return IPropertyFlavor.build(ItemFilters.type((String)((IType)value).getIdentifier()), items, attribute, value, NLS.bind((String)Messages.FLAVOR_IS, (Object)attribute.getName(), (Object)TypeHandling.getValueString((Object)value)));
        }
        return IPropertyFlavor.build(ItemFilters.equals(attribute, (Object)value), items, attribute, value, NLS.bind((String)Messages.FLAVOR_IS, (Object)attribute.getName(), (Object)TypeHandling.getValueString((Object)value)));
    }

    public static IPropertyFlavor buildPointRange(IAttribute<IQuantity> pointAttribute, IRange<IQuantity> range, IItemCollection items) {
        return IPropertyFlavor.buildPointRange(IPropertyFlavor.getIntervalDescription(pointAttribute, range), pointAttribute, range, items);
    }

    public static IPropertyFlavor buildPointRange(String description, IAttribute<IQuantity> pointAttribute, IRange<IQuantity> range, IItemCollection items) {
        IItemFilter interval = ItemFilters.interval(pointAttribute, (Comparable)((IQuantity)range.getStart()), (boolean)true, (Comparable)((IQuantity)range.getEnd()), (boolean)true);
        return IPropertyFlavor.build(interval, items, pointAttribute, range, description);
    }

    public static IPropertyFlavor buildRange(IAttribute<IRange<IQuantity>> rangeAttribute, IRange<IQuantity> limit, IItemCollection items) {
        return IPropertyFlavor.buildRange(IPropertyFlavor.getIntervalDescription(rangeAttribute, limit), rangeAttribute, limit, items);
    }

    public static IPropertyFlavor buildRange(String description, IAttribute<IRange<IQuantity>> rangeAttribute, IRange<IQuantity> limit, IItemCollection items) {
        IItemFilter interval = ItemFilters.matchRange((RangeMatchPolicy)RangeMatchPolicy.CONTAINED_IN_CLOSED, rangeAttribute, limit);
        return IPropertyFlavor.build(interval, items, rangeAttribute, limit, description);
    }

    public static String getIntervalDescription(IAttribute<?> rangeAttribute, IRange<?> limit) {
        return NLS.bind((String)Messages.FLAVOR_IS_IN_INTERVAL, (Object)rangeAttribute.getName(), (Object)limit.displayUsing("auto"));
    }

    public static IPropertyFlavor build(IItemFilter filter, IItemCollection items, IAttribute<?> attribute, Object value, String valueDesc) {
        return IPropertyFlavor.build(valueDesc, filter, items, Arrays.asList(IPropertyFlavor.buildProperty(attribute, value))::stream);
    }

    public static IPropertyFlavor combine(Supplier<Stream<IPropertyFlavor>> flavors, IItemCollection items) {
        IItemFilter filter = ItemFilters.and((IItemFilter[])((IItemFilter[])flavors.get().map(IFilterFlavor::getFilter).toArray(IItemFilter[]::new)));
        String name = null;
        for (String fName : flavors.get().map(ISelectionFlavor::getName).collect(Collectors.toList())) {
            String string = name = name == null ? fName : NLS.bind((String)Messages.FLAVOR_FILTER_AND_FILTER, (Object)name, (Object)fName);
        }
        return IPropertyFlavor.build(name, filter, items, () -> ((Stream)flavors.get()).flatMap(IPropertyFlavor::getProperties));
    }

    public static IPropertyFlavor build(final String name, final IItemFilter filter, final IItemCollection sourceItems, final Supplier<Stream<IProperty>> properties) {
        return new IPropertyFlavor(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public IItemCollection evaluate() {
                return sourceItems.apply(filter);
            }

            @Override
            public IItemFilter getFilter() {
                return filter;
            }

            @Override
            public Stream<IProperty> getProperties() {
                return (Stream)properties.get();
            }
        };
    }

    public static IProperty buildProperty(final IAttribute<?> attribute, final Object value) {
        return new IProperty(){

            @Override
            public IAttribute<?> getAttribute() {
                return attribute;
            }

            @Override
            public Object getValue() {
                return value;
            }
        };
    }

    public static interface IProperty {
        public IAttribute<?> getAttribute();

        public Object getValue();
    }
}

