/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.selection;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.selection.IFlavoredSelection;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;

public class SelectionStore {
    private final LinkedList<SelectionStoreEntry> selections = new LinkedList();
    private int nextIndex = 1;
    private SelectionStoreEntry current;
    private boolean currentActive = false;
    private SelectionStoreListener listener;
    private static final IFlavoredSelection NO_SELECTION = new IFlavoredSelection(){

        public boolean isEmpty() {
            return true;
        }

        @Override
        public String getName() {
            return Messages.SELECTION_STORE_NO_SELECTION;
        }

        @Override
        public Stream<IItemStreamFlavor> getFlavors(IItemFilter filter, IItemCollection items, List<IAttribute<?>> ignored) {
            return Stream.of(IItemStreamFlavor.build(this.getName(), this.isEmpty(), items));
        }
    };
    private static final SelectionStoreEntry NO_SELECTION_ENTRY = new SelectionStoreEntry(0, NO_SELECTION){

        @Override
        public String getName() {
            return NO_SELECTION.getName();
        }
    };

    private int getNextIndex() {
        return this.nextIndex++;
    }

    public Stream<SelectionStoreEntry> getSelections() {
        return Stream.concat(Stream.of(NO_SELECTION_ENTRY), this.selections.stream());
    }

    public SelectionStoreEntry getCurrentSelection() {
        if (this.current != null) {
            return this.current;
        }
        if (this.selections.size() > 0) {
            return this.selections.getFirst();
        }
        return null;
    }

    public boolean isCurrentActive() {
        return this.currentActive;
    }

    public void setCurrentActive(boolean currentActive) {
        this.currentActive = currentActive;
        this.fireSelectionActive(currentActive);
    }

    public void setCurrent(IFlavoredSelection selection) {
        SelectionStoreEntry entry = null;
        if (selection == NO_SELECTION) {
            entry = NO_SELECTION_ENTRY;
        } else if (selection != null && (entry = this.findEntry(selection)) == null) {
            entry = this.addSelectionInternal(selection, false);
        }
        this.current = entry;
    }

    private SelectionStoreEntry findEntry(IFlavoredSelection selection) {
        for (SelectionStoreEntry entry : this.selections) {
            if (entry.getSelection() != selection) continue;
            return entry;
        }
        return null;
    }

    public void addSelection(IFlavoredSelection selection) {
        this.addSelectionInternal(selection, true);
    }

    private SelectionStoreEntry addSelectionInternal(IFlavoredSelection selection, boolean keepCurrent) {
        SelectionStoreEntry entry = new SelectionStoreEntry(this.getNextIndex(), selection);
        this.selections.push(entry);
        long storeSize = Math.max(1L, FlightRecorderUI.getDefault().getSelectionStoreSize().longValue());
        boolean currentRemoved = false;
        while ((long)this.selections.size() > storeSize) {
            SelectionStoreEntry removed = this.selections.pollLast();
            if (removed != this.current) continue;
            currentRemoved = true;
        }
        if (currentRemoved) {
            if (keepCurrent) {
                this.selections.addLast(this.current);
            } else {
                this.current = null;
            }
        }
        this.fireSelectionAdded(entry);
        return entry;
    }

    public void addAndSetAsCurrentSelection(IFlavoredSelection selection) {
        this.setCurrent(selection);
        this.setCurrentActive(true);
    }

    public void setListener(SelectionStoreListener listener) {
        this.listener = listener;
    }

    private void fireSelectionAdded(SelectionStoreEntry selection) {
        if (this.listener != null) {
            this.listener.selectionAdded(selection);
        }
    }

    private void fireSelectionActive(boolean active) {
        if (this.listener != null) {
            this.listener.selectionActive(active);
        }
    }

    public static class SelectionStoreEntry {
        private final int index;
        private IFlavoredSelection selection;

        private SelectionStoreEntry(int index, IFlavoredSelection selection) {
            this.index = index;
            this.selection = selection;
        }

        public String getName() {
            return String.valueOf(this.index) + ": " + this.selection.getName();
        }

        public IFlavoredSelection getSelection() {
            return this.selection;
        }
    }

    public static interface SelectionStoreListener {
        public void selectionActive(boolean var1);

        public void selectionAdded(SelectionStoreEntry var1);
    }
}

