/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.greychart.DefaultMetadataProvider;
import org.openjdk.jmc.greychart.SeriesMetadataProvider;
import org.openjdk.jmc.greychart.data.RenderingMode;
import org.openjdk.jmc.greychart.data.SeriesProviderSet;
import org.openjdk.jmc.greychart.ui.views.ChartComposite;
import org.openjdk.jmc.greychart.ui.views.ChartSampleTooltipProvider;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IAttributeStorage;
import org.openjdk.jmc.rjmx.services.IAttributeStorageService;
import org.openjdk.jmc.rjmx.services.MRIDataSeries;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRIService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.EditDisplayNameAction;
import org.openjdk.jmc.rjmx.ui.internal.AccessibleControlAction;
import org.openjdk.jmc.rjmx.ui.internal.AddAttibutesAction;
import org.openjdk.jmc.rjmx.ui.internal.AttributeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.IAttributeSet;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.RemoveAttributeAction;
import org.openjdk.jmc.rjmx.ui.internal.StatisticsCalculator;
import org.openjdk.jmc.rjmx.ui.internal.StatisticsTable;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.common.tree.IArray;
import org.openjdk.jmc.ui.common.xydata.DataSeries;
import org.openjdk.jmc.ui.common.xydata.ITimestampedData;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.IRefreshable;
import org.openjdk.jmc.ui.misc.MCArrayContentProvider;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;
import org.openjdk.jmc.ui.rate.RateCoordinator;
import org.openjdk.jmc.ui.rate.RateLimitedObserver;
import org.openjdk.jmc.ui.rate.RefreshController;

public class CombinedChartSectionPart
extends MCSectionPart
implements IAttributeSet {
    private static final String ATTRIBUTE_ID = "attribute";
    private static final String ENABLED_ID = "enabled";
    private static final String TABLE_TAG = "table";
    private final IMRIMetadataService mds;
    private final IAttributeStorageService m_storageService;
    private final Set<MRI> m_enabledAttributes = new HashSet<MRI>();
    private final SeriesProviderSet<ITimestampedData> m_dataProvider = new SeriesProviderSet();
    private final Map<MRI, IAttributeStorage> m_attributeStorages = new HashMap<MRI, IAttributeStorage>();
    private StatisticsTable m_statisticsTable;
    private ChartComposite chart;
    private CheckboxTableViewer legend;
    private AccessibleControlAction accessibleControlAction;
    private final RefreshController m_refreshController;
    private final RateCoordinator rateCoordinator;
    private final Observer chartDataObserver;
    private final Observer statisticsDataObserver;
    private final Observer metadataObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CombinedChartSectionPart.this.legend.getTable().isDisposed() && !CombinedChartSectionPart.this.chart.isDisposed()) {
                        CombinedChartSectionPart.this.updateQuantityKind(CombinedChartSectionPart.this.chart.getChartModel().getYAxis().getKindOfQuantity());
                        CombinedChartSectionPart.this.refreshAll();
                    }
                }
            });
        }
    };
    private final IArray<StatisticsCalculator> statisticsProvider = new IArray<StatisticsCalculator>(){

        public boolean isEmpty() {
            return CombinedChartSectionPart.this.m_attributeStorages.isEmpty();
        }

        public StatisticsCalculator[] elements() {
            StatisticsCalculator[] statisticsArray = new StatisticsCalculator[CombinedChartSectionPart.this.m_attributeStorages.size()];
            int i = 0;
            for (Map.Entry entry : CombinedChartSectionPart.this.m_attributeStorages.entrySet()) {
                MRI mri = (MRI)entry.getKey();
                StatisticsCalculator stats = new StatisticsCalculator(mri);
                stats.setUnit(UnitLookup.getUnitOrDefault((String)CombinedChartSectionPart.this.mds.getMetadata(mri).getUnitString()));
                long min = CombinedChartSectionPart.this.chart.getChart().getXAxis().getMin().longValue();
                long max = CombinedChartSectionPart.this.chart.getChart().getXAxis().getMax().longValue();
                for (MRIDataSeries ds : ((IAttributeStorage)entry.getValue()).getDataSeries()) {
                    Iterator it = ds.createIterator(min, max);
                    while (it.hasNext()) {
                        ITimestampedData data = (ITimestampedData)it.next();
                        long timestamp = (Long)data.getX();
                        if (min > timestamp || timestamp > max) continue;
                        stats.addValue(((Number)data.getY()).doubleValue());
                    }
                }
                statisticsArray[i++] = stats;
            }
            return statisticsArray;
        }
    };

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, IMRIMetadataService metadataService, IMRIService mris, IAttributeStorageService ss, IMemento state) {
        super(parent, toolkit, style);
        this.mds = metadataService;
        this.m_storageService = ss;
        this.mds.addObserver(this.metadataObserver);
        this.m_refreshController = RefreshController.createGroup((Display)parent.getDisplay());
        this.rateCoordinator = new RateCoordinator();
        this.m_refreshController.add((IRefreshable)this.rateCoordinator);
        this.chartDataObserver = new RateLimitedObserver(this.rateCoordinator, 200){

            protected void doRefresh(Object arg) {
                if (!CombinedChartSectionPart.this.chart.isDisposed()) {
                    if (arg instanceof ITimestampedData) {
                        long timestamp = (Long)((ITimestampedData)arg).getX();
                        CombinedChartSectionPart.this.chart.extendsDataRangeToInclude(timestamp);
                    } else {
                        CombinedChartSectionPart.this.chart.refresh();
                    }
                }
            }
        };
        this.statisticsDataObserver = new RateLimitedObserver(this.rateCoordinator, 500){

            protected void doRefresh(Object arg) {
                TableViewer viewer = CombinedChartSectionPart.this.m_statisticsTable.getViewer();
                Control control = viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    boolean visible = control.isVisible();
                    if (visible) {
                        control.setRedraw(false);
                    }
                    viewer.refresh();
                    if (visible) {
                        control.setRedraw(true);
                        control.update();
                    }
                }
            }
        };
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        Composite stackContainer = toolkit.createComposite(body);
        stackContainer.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        final StackLayout stackLayout = new StackLayout();
        stackContainer.setLayout((Layout)stackLayout);
        final Composite chartContainer = toolkit.createComposite(stackContainer);
        chartContainer.setLayout((Layout)new GridLayout(2, false));
        IMemento tableState = state == null ? null : state.getChild(TABLE_TAG);
        this.m_statisticsTable = new StatisticsTable(stackContainer, new AttributeLabelProvider(this.mds, mris), this, false, tableState);
        this.m_statisticsTable.getViewer().setInput(this.statisticsProvider);
        this.chart = new ChartComposite(chartContainer, 0, this.createEnableUpdatesCallback());
        this.chart.setChartSampleTooltipProvider(new ChartSampleTooltipProvider(){

            public String getTooltip(DataSeries<?> series, double value) {
                if (series instanceof MRIDataSeries) {
                    MRI mri = ((MRIDataSeries)series).getAttribute();
                    IMRIMetadata metadata = CombinedChartSectionPart.this.mds.getMetadata(mri);
                    IUnit unit = UnitLookup.getUnitOrNull((String)metadata.getUnitString());
                    if (unit != null) {
                        IQuantity quantity = unit.quantity(value);
                        return String.valueOf(MRIMetadataToolkit.getDisplayName((IMRIMetadataService)CombinedChartSectionPart.this.mds, (MRI)mri)) + ": " + quantity.displayUsing("verbose") + " (" + metadata.getValueType() + ", " + MBeanPropertiesOrderer.mriAsTooltip(mri) + ")";
                    }
                    return String.valueOf(MRIMetadataToolkit.getDisplayName((IMRIMetadataService)CombinedChartSectionPart.this.mds, (MRI)mri)) + ": " + UnitLookup.NUMBER_UNITY.quantity(value).displayUsing("auto") + " (" + metadata.getValueType() + ", " + MBeanPropertiesOrderer.mriAsTooltip(mri) + ")";
                }
                return String.valueOf(value);
            }
        });
        this.chart.getChart().setMetadataProvider((SeriesMetadataProvider)new DefaultMetadataProvider(){

            public Color getLineColor(DataSeries<?> ds) {
                MRI mri = ((MRIDataSeries)ds).getAttribute();
                return MRIMetadataToolkit.getColor((IMRIMetadataProvider)CombinedChartSectionPart.this.mds.getMetadata(mri));
            }

            public RenderingMode getMode(DataSeries<?> ds) {
                return CombinedChartSectionPart.this.chart.getChartModel().getRenderingMode();
            }

            public double getMultiplier(DataSeries<?> ds) {
                MRI mri = ((MRIDataSeries)ds).getAttribute();
                IUnit unit = UnitLookup.getUnitOrNull((String)CombinedChartSectionPart.this.mds.getMetadata(mri).getUnitString());
                if (unit instanceof LinearUnit) {
                    LinearUnit linearUnit = (LinearUnit)unit;
                    LinearKindOfQuantity kind = linearUnit.getContentType();
                    LinearUnit outUnit = kind.getDefaultUnit();
                    return linearUnit.valueTransformTo(outUnit).getMultiplier();
                }
                return 1.0;
            }
        });
        this.chart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chart.showLast(60000000000L);
        this.chart.getChart().setDataProvider(this.m_dataProvider);
        this.chart.getChartModel().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                CombinedChartSectionPart.this.getSection().setText(CombinedChartSectionPart.this.chart.getChartModel().getChartTitle());
                CombinedChartSectionPart.this.chart.refresh();
            }
        });
        this.createLegend(toolkit, chartContainer, mris);
        this.getMCToolBarManager().add((IAction)new AddAttibutesAction(this.mds, mris, this){

            @Override
            protected ContentType<?> getContentType() {
                return CombinedChartSectionPart.this.isEmpty() ? null : CombinedChartSectionPart.this.chart.getChartModel().getYAxis().getKindOfQuantity();
            }

            @Override
            protected boolean allowMultiple() {
                return !CombinedChartSectionPart.this.isEmpty();
            }
        }, 0);
        this.accessibleControlAction = new AccessibleControlAction(){

            public void run() {
                stackLayout.topControl = this.isChecked() ? CombinedChartSectionPart.this.m_statisticsTable.getViewer().getControl() : chartContainer;
                CombinedChartSectionPart.this.m_statisticsTable.getViewer().getControl().setVisible(this.isChecked());
                chartContainer.setVisible(!this.isChecked());
                CombinedChartSectionPart.this.refreshAll();
            }
        };
        this.getMCToolBarManager().add((IAction)this.accessibleControlAction);
        if (state != null) {
            this.restoreState(state);
        }
    }

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, IConnectionHandle connection, IMemento state) {
        this(parent, toolkit, style, (IMRIMetadataService)connection.getServiceOrDummy(IMRIMetadataService.class), (IMRIService)connection.getServiceOrDummy(IMRIService.class), (IAttributeStorageService)connection.getServiceOrDummy(IAttributeStorageService.class), state);
    }

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, IConnectionHandle connection) {
        this(parent, toolkit, style, connection, null);
    }

    protected Consumer<Boolean> createEnableUpdatesCallback() {
        Action updatesAction = new Action(Messages.UpdatesAction_ACTION_NAME, 2){

            public void run() {
                CombinedChartSectionPart.this.chart.setUpdatesEnabled(this.isChecked());
                if (this.isChecked()) {
                    CombinedChartSectionPart.this.m_refreshController.start();
                } else {
                    CombinedChartSectionPart.this.m_refreshController.stop();
                }
            }
        };
        updatesAction.setChecked(false);
        updatesAction.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab_grey.gif"));
        updatesAction.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
        updatesAction.setToolTipText(Messages.UpdatesAction_TOOLTIP_TEXT);
        updatesAction.setId("toggle.freeze");
        this.getMCToolBarManager().add((IAction)updatesAction);
        return new Consumer<Boolean>((IAction)updatesAction){
            private final /* synthetic */ IAction val$updatesAction;
            {
                this.val$updatesAction = iAction;
            }

            @Override
            public void accept(Boolean enableUpdates) {
                CombinedChartSectionPart.this.chart.setUpdatesEnabled(enableUpdates.booleanValue());
                this.val$updatesAction.setChecked(enableUpdates.booleanValue());
                CombinedChartSectionPart.this.getMCToolBarManager().update();
                if (enableUpdates.booleanValue()) {
                    CombinedChartSectionPart.this.m_refreshController.start();
                } else {
                    CombinedChartSectionPart.this.m_refreshController.stop();
                }
            }
        };
    }

    public void dispose() {
        this.m_refreshController.stop();
        for (IAttributeStorage as : this.m_attributeStorages.values()) {
            as.deleteObserver(this.statisticsDataObserver);
            as.deleteObserver(this.chartDataObserver);
        }
        if (this.accessibleControlAction != null) {
            this.accessibleControlAction.dispose();
        }
        this.mds.deleteObserver(this.metadataObserver);
        super.dispose();
    }

    public void saveState(IMemento state) {
        this.m_statisticsTable.saveState(state.createChild(TABLE_TAG));
        this.chart.getChartModel().saveState(state);
        for (MRI mri : this.m_attributeStorages.keySet()) {
            IMemento child = state.createChild(ATTRIBUTE_ID);
            child.putTextData(mri.getQualifiedName());
            child.putBoolean(ENABLED_ID, this.isEnabled(mri));
        }
    }

    public void restoreState(IMemento state) {
        this.chart.getChartModel().restoreState(state);
        HashSet<MRI> current = new HashSet<MRI>(this.m_attributeStorages.keySet());
        IMemento[] iMementoArray = state.getChildren(ATTRIBUTE_ID);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            MRI mri = MRI.createFromQualifiedName((String)child.getTextData().trim());
            current.remove(mri);
            this.doAdd(mri);
            Boolean enabled = child.getBoolean(ENABLED_ID);
            this.setEnabled(mri, enabled == null || enabled != false);
            ++n2;
        }
        if (!this.m_enabledAttributes.isEmpty()) {
            this.setQuantityKindFromAttribute(this.m_enabledAttributes.iterator().next());
        }
        for (MRI mri : current) {
            this.doRemove(mri);
        }
        this.refreshAll();
    }

    public ChartComposite getChart() {
        return this.chart;
    }

    @Override
    public void add(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.doAdd(mri);
            ++n2;
        }
        if (mris.length > 0) {
            this.setQuantityKindFromAttribute(mris[0]);
        }
        this.refreshAll();
    }

    private void doAdd(MRI mri) {
        IAttributeStorage storage = this.m_storageService.getAttributeStorage(mri);
        if (storage != null) {
            storage.addObserver(this.chartDataObserver);
            storage.addObserver(this.statisticsDataObserver);
            this.m_attributeStorages.put(mri, storage);
            this.doSetEnabled(mri, storage, true);
        }
    }

    @Override
    public void remove(MRI ... mris) {
        MRI[] mRIArray = mris;
        int n = mris.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.doRemove(mri);
            ++n2;
        }
        this.refreshAll();
    }

    private void doRemove(MRI mri) {
        IAttributeStorage storage = this.m_attributeStorages.remove(mri);
        if (storage != null) {
            storage.deleteObserver(this.statisticsDataObserver);
            storage.deleteObserver(this.chartDataObserver);
            this.doSetEnabled(mri, storage, false);
        }
    }

    private void setEnabled(MRI mri, boolean enabled) {
        IAttributeStorage storage = this.m_attributeStorages.get(mri);
        if (storage != null && this.isEnabled(mri) != enabled) {
            this.doSetEnabled(mri, storage, enabled);
        }
    }

    private void doSetEnabled(MRI mri, IAttributeStorage storage, boolean enabled) {
        if (enabled) {
            this.m_enabledAttributes.add(mri);
            this.m_dataProvider.addDataSeries(storage.getDataSeries());
        } else {
            this.m_enabledAttributes.remove(mri);
            this.m_dataProvider.removeDataSeries(storage.getDataSeries());
        }
    }

    private boolean isEnabled(MRI attributeDescriptor) {
        return this.m_enabledAttributes.contains(attributeDescriptor);
    }

    public MRI[] elements() {
        return this.m_attributeStorages.keySet().toArray(new MRI[this.m_attributeStorages.keySet().size()]);
    }

    public boolean isEmpty() {
        return this.m_attributeStorages.isEmpty();
    }

    private void refreshAll() {
        this.updateDataRange();
        this.chart.refresh();
        if (this.m_statisticsTable.getViewer().getControl().isVisible()) {
            this.m_statisticsTable.getViewer().refresh();
        } else {
            this.legend.refresh();
        }
    }

    private void updateDataRange() {
        long dataStart = Long.MAX_VALUE;
        long dataEnd = Long.MIN_VALUE;
        for (MRI enabledAttribute : this.m_enabledAttributes) {
            IAttributeStorage storage = this.m_attributeStorages.get(enabledAttribute);
            dataStart = Math.min(dataStart, storage.getDataStart());
            dataEnd = Math.max(dataEnd, storage.getDataEnd());
        }
        this.chart.setDataRange(dataStart, dataEnd);
    }

    private void createLegend(FormToolkit formToolkit, Composite container, IMRIService mris) {
        Table table = formToolkit.createTable(container, 65570);
        this.legend = new CheckboxTableViewer(table);
        this.legend.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MRI mri = (MRI)event.getElement();
                boolean enable = event.getChecked();
                CombinedChartSectionPart.this.setEnabled(mri, enable);
                if (enable) {
                    CombinedChartSectionPart.this.setQuantityKindFromAttribute(mri);
                }
                CombinedChartSectionPart.this.refreshAll();
            }
        });
        this.legend.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return CombinedChartSectionPart.this.isEnabled((MRI)element);
            }
        });
        this.legend.setComparator(new ViewerComparator());
        this.legend.setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        this.legend.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.mds, mris));
        this.legend.setInput((Object)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.legend);
        GridData gd2 = new GridData(4, 4, false, true);
        gd2.heightHint = 60;
        gd2.widthHint = 210;
        table.setLayoutData((Object)gd2);
        SelectionProviderAction editColorAction = new SelectionProviderAction((ISelectionProvider)this.legend, Messages.ChartSectionPart_EDIT_COLOR_TEXT){

            public void run() {
                CombinedChartSectionPart.this.editColor((MRI)this.getStructuredSelection().getFirstElement());
            }

            public void selectionChanged(IStructuredSelection selection) {
                this.setEnabled(selection.size() == 1);
            }
        };
        editColorAction.setEnabled(false);
        MCContextMenuManager mm = MCContextMenuManager.create((Control)this.legend.getTable());
        RemoveAttributeAction removeAction = new RemoveAttributeAction((StructuredViewer)this.legend, this);
        mm.appendToGroup("group.edit", (IAction)removeAction);
        mm.appendToGroup("group.properties", (IAction)editColorAction);
        mm.appendToGroup("group.properties", (IAction)new EditDisplayNameAction(this.mds, (ISelectionProvider)this.legend));
        InFocusHandlerActivator.install((Control)this.legend.getControl(), (IAction)removeAction);
    }

    private void editColor(MRI descriptor) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        RGB rgb = SWTColorToolkit.asRGB((Color)MRIMetadataToolkit.getColor((IMRIMetadataProvider)this.mds.getMetadata(descriptor)));
        dialog.setRGB(rgb);
        RGB newRGB = dialog.open();
        if (newRGB != null) {
            String colorAsString = ColorToolkit.encode((Color)new Color(newRGB.red, newRGB.green, newRGB.blue));
            this.mds.setMetadata(descriptor, "color", colorAsString);
        }
    }

    private void setQuantityKindFromAttribute(MRI attribute) {
        KindOfQuantity kind = UnitLookup.getUnitOrDefault((String)this.mds.getMetadata(attribute).getUnitString()).getContentType();
        if (!this.chart.getChartModel().getYAxis().getKindOfQuantity().equals(kind)) {
            this.chart.getChartModel().getYAxis().setKindOfQuantity(kind);
            this.chart.getChartModel().getYAxis().notifyObservers();
        }
        this.updateQuantityKind(kind);
    }

    private void updateQuantityKind(KindOfQuantity<?> currentKind) {
        for (MRI mri : this.m_attributeStorages.keySet()) {
            IUnit unit = UnitLookup.getUnitOrDefault((String)this.mds.getMetadata(mri).getUnitString());
            if (currentKind.equals((Object)unit.getContentType())) continue;
            this.setEnabled(mri, false);
        }
    }
}

