/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.operations;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IOperation;
import org.openjdk.jmc.rjmx.ui.RJMXUIPlugin;
import org.openjdk.jmc.rjmx.ui.operations.Messages;
import org.openjdk.jmc.ui.UIPlugin;

public class OperationsLabelProvider
extends DelegatingStyledCellLabelProvider
implements ILabelProvider {
    OperationsLabelProvider(boolean showOperationReturnType) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProvider(showOperationReturnType));
    }

    public Image getToolTipImage(Object element) {
        return this.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IOperation) {
            IOperation operation = (IOperation)element;
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.OperationsLabelProvider_NAME).append(": ").append(operation.getName()).append('\n');
            int count = 0;
            for (IAttributeInfo param : operation.getSignature()) {
                sb.append(NLS.bind((String)Messages.OperationsLabelProvider_PARAMETER, (Object)count)).append(": ").append(param.getType()).append(' ').append(param.getName()).append('\n');
                ++count;
            }
            sb.append(Messages.OperationsLabelProvider_RETURN_TYPE).append(": ").append(TypeHandling.simplifyType((String)operation.getReturnType())).append('\n');
            String desc = operation.getDescription();
            if (desc != null && desc.length() > 0) {
                sb.append(Messages.OperationsLabelProvider_DESCRIPTION).append(": ").append(desc).append('\n');
            }
            sb.append(Messages.OperationsLabelProvider_IMPACT).append(": ").append(OperationsLabelProvider.impactAsString(operation.getImpact()));
            return sb.toString().trim();
        }
        return super.getToolTipText(element);
    }

    public String getText(Object element) {
        if (element instanceof IOperation) {
            return ((IOperation)element).getName();
        }
        return null;
    }

    public static Image getOperationIcon(IOperation operation) {
        if (operation == null) {
            return null;
        }
        switch (operation.getImpact()) {
            case IMPACT_LOW: {
                return RJMXUIPlugin.getDefault().getImage("impact_low.png");
            }
            case IMPACT_MEDIUM: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case IMPACT_HIGH: {
                return RJMXUIPlugin.getDefault().getImage("impact_high.png");
            }
            case IMPACT_UNKNOWN: {
                return UIPlugin.getDefault().getImage("help.gif");
            }
        }
        throw new RuntimeException("Unknown impact: " + operation.getImpact());
    }

    public static String impactAsString(IOperation.OperationImpact operationImpact) {
        switch (operationImpact) {
            case IMPACT_HIGH: {
                return Messages.OperationsLabelProvider_HIGH_IMPACT;
            }
            case IMPACT_MEDIUM: {
                return Messages.OperationsLabelProvider_MEDIUM_IMPACT;
            }
            case IMPACT_LOW: {
                return Messages.OperationsLabelProvider_LOW_IMPACT;
            }
        }
        return Messages.OperationsLabelProvider_UNKNOWN_IMPACT;
    }

    private static class StyledLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private final boolean showOperationReturnType;

        StyledLabelProvider(boolean showOperationReturnType) {
            this.showOperationReturnType = showOperationReturnType;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof IOperation) {
                IOperation info = (IOperation)element;
                StyledString ret = new StyledString(info.getName());
                if (this.showOperationReturnType) {
                    ret.append(" : " + TypeHandling.simplifyType((String)info.getReturnType()), StyledString.QUALIFIER_STYLER);
                }
                return ret;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof IOperation) {
                return OperationsLabelProvider.getOperationIcon((IOperation)element);
            }
            return null;
        }
    }
}

