/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ext;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class EclipseJmxProviderProxy
implements JMXConnectorProvider {
    private static final String EXTENSION_POINT = "org.openjdk.jmc.rjmx.jmxProtocols";
    private static final String TAG_CLIENT = "client";
    private static final String ATTRIBUTE_PROTOCOL = "protocol";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTRIBUTE_KEY = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String TAG_SYSPROPERTY = "sysproperty";
    private static final String ATTRIBUTE_INCLUDE = "include";
    private static final String ATTRIBUTE_SEPARATOR = "separator";

    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        JMXConnectorProvider realProvider = this.extendEnv(serviceURL, environment);
        if (realProvider == null) {
            throw new MalformedURLException("No Eclipse extension for JMX protocol " + serviceURL.getProtocol() + " was found.");
        }
        return realProvider.newJMXConnector(serviceURL, environment);
    }

    private IConfigurationElement[] getConfigElements() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
    }

    public JMXConnectorProvider extendEnv(JMXServiceURL serviceURL, Map<String, Object> environment) {
        String protocol = serviceURL.getProtocol();
        IConfigurationElement[] iConfigurationElementArray = this.getConfigElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (TAG_CLIENT.equals(element.getName()) && element.getAttribute(ATTRIBUTE_PROTOCOL).equals(protocol)) {
                IConfigurationElement prop;
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren(TAG_PROPERTY);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    prop = iConfigurationElementArray2[n4];
                    environment.put(prop.getAttribute(ATTRIBUTE_KEY), prop.getAttribute(ATTRIBUTE_VALUE));
                    ++n4;
                }
                iConfigurationElementArray2 = element.getChildren(TAG_SYSPROPERTY);
                n3 = iConfigurationElementArray2.length;
                n4 = 0;
                while (n4 < n3) {
                    prop = iConfigurationElementArray2[n4];
                    EclipseJmxProviderProxy.ensureSystemProperty(prop.getAttribute(ATTRIBUTE_KEY), prop.getAttribute(ATTRIBUTE_INCLUDE), prop.getAttribute(ATTRIBUTE_SEPARATOR));
                    ++n4;
                }
                try {
                    Object provider = element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (provider instanceof JMXConnectorProvider) {
                        ClassLoader loader = provider.getClass().getClassLoader();
                        environment.put("jmx.remote.default.class.loader", loader);
                        environment.put("jmx.remote.protocol.provider.class.loader", loader);
                        return (JMXConnectorProvider)provider;
                    }
                }
                catch (CoreException e) {
                    Logger.getLogger("org.openjdk.jmc.rjmx.ext").log(Level.WARNING, e.getMessage(), e);
                }
            }
            ++n2;
        }
        return null;
    }

    private static void ensureSystemProperty(String key, String include, String separator) {
        String org = System.getProperty(key);
        if (org == null) {
            System.setProperty(key, include);
            return;
        }
        if ((String.valueOf(separator) + org + separator).indexOf(String.valueOf(separator) + include + separator) < 0) {
            System.setProperty(key, String.valueOf(org) + separator + include);
        }
    }
}

