/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.rjmx.IConnectionDescriptor;
import org.openjdk.jmc.ui.common.security.ICredentials;
import org.openjdk.jmc.ui.common.security.SecurityException;

public final class JMXConnectionDescriptor
implements IConnectionDescriptor {
    private final JMXServiceURL url;
    private final ICredentials credentials;

    public JMXConnectionDescriptor(JMXServiceURL url, ICredentials credentials) {
        this.url = url;
        this.credentials = credentials;
    }

    @Override
    public JMXServiceURL createJMXServiceURL() throws IOException {
        return this.url;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        try {
            String user = "";
            String pwd = "";
            if (this.credentials != null) {
                if (this.credentials.getUsername() != null) {
                    user = this.credentials.getUsername();
                }
                if (this.credentials.getPassword() != null) {
                    pwd = this.credentials.getPassword();
                }
            }
            String[] creArray = new String[]{user, pwd};
            env.put("jmx.remote.credentials", creArray);
            env.put("java.naming.security.principal", user);
            env.put("java.naming.security.credentials", pwd);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return env;
    }

    public String toString() {
        return this.url.toString();
    }
}

