/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.util.Properties;
import java.util.logging.Level;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.preferences.JMXRMIPreferences;

public final class JMXRMISystemPropertiesProvider {
    public static void setup() {
        try {
            Properties jmxRmiProperties = JMXRMIPreferences.getInstance().getProperties();
            if (jmxRmiProperties != null) {
                for (String prop : jmxRmiProperties.stringPropertyNames()) {
                    Object val = jmxRmiProperties.get(prop);
                    if (val == null || val.toString().isEmpty()) continue;
                    System.setProperty(prop, val.toString());
                }
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.FINE, "Did not load jmxRmiProperties", e);
        }
    }

    public static void clearJMXRMISystemProperties() {
        try {
            Properties jmxRmiProperties = JMXRMIPreferences.getInstance().getProperties();
            if (jmxRmiProperties != null) {
                for (String prop : jmxRmiProperties.stringPropertyNames()) {
                    System.clearProperty(prop);
                }
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.FINE, "Failed to remove JMXRMI SystemProperties", e);
        }
    }

    public static boolean isKeyStoreConfigured() {
        try {
            Properties jmxRmiProperties = JMXRMIPreferences.getInstance().getProperties();
            if (jmxRmiProperties != null) {
                int totalPrefCnt = 0;
                for (String prop : jmxRmiProperties.stringPropertyNames()) {
                    Object val = jmxRmiProperties.get(prop);
                    if (val == null || val.toString().isEmpty()) continue;
                    ++totalPrefCnt;
                }
                if (totalPrefCnt == 4) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.FINE, "Did not load jmxRmiProperties", e);
        }
        return false;
    }
}

