/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.UnmarshalException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.core.runtime.ListenerList;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.rjmx.ConnectionException;
import org.openjdk.jmc.rjmx.ConnectionToolkit;
import org.openjdk.jmc.rjmx.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.IServerDescriptor;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.internal.JMXRMISystemPropertiesProvider;
import org.openjdk.jmc.rjmx.internal.MBeanOperationWrapper;
import org.openjdk.jmc.rjmx.internal.MCMBeanServerConnection;
import org.openjdk.jmc.rjmx.internal.WrappedConnectionException;
import org.openjdk.jmc.rjmx.services.IOperation;
import org.openjdk.jmc.rjmx.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.subscription.IMBeanServerChangeListener;
import org.openjdk.jmc.rjmx.subscription.IMRIService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.internal.AttributeValueToolkit;
import org.openjdk.jmc.rjmx.subscription.internal.InvoluntaryDisconnectException;
import org.openjdk.jmc.rjmx.subscription.internal.MBeanMRIMetadataDB;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;

public class RJMXConnection
implements Closeable,
IMBeanHelperService {
    public static final String KEY_SOCKET_FACTORY = "com.sun.jndi.rmi.factory.socket";
    public static final String KEY_JMXREMOTE_SSL = "com.sun.management.jmxremote.ssl";
    public static final int VALUE_DEFAULT_REMOTE_PORT_JMX = 7091;
    private static final long VALUE_RECALIBRATION_INTERVAL = 120000L;
    private static final long REMOTE_START_TIME_UNDEFINED = -1L;
    private static final AtomicInteger CONNECTION_COUNTER = new AtomicInteger();
    private final IConnectionDescriptor m_connectionDescriptor;
    private final IServerDescriptor m_serverDescriptor;
    private final int m_connectionId = CONNECTION_COUNTER.getAndIncrement();
    private volatile MCMBeanServerConnection m_server;
    private JMXConnector m_jmxc;
    private final MBeanMRIMetadataDB m_mbeanDataProvider;
    private long m_serverOffset;
    private long m_lastRecalibration;
    private long m_remoteStartTime = -1L;
    private boolean m_hasInitializedAllMBeans = false;
    private final HashMap<ObjectName, MBeanInfo> m_cachedInfos = new HashMap();
    private volatile Set<ObjectName> m_cachedMBeanNames = new HashSet<ObjectName>();
    private final Runnable m_onFailCallback;
    private final ListenerList<IMBeanServerChangeListener> m_mbeanListeners = new ListenerList();
    private final NotificationListener m_registrationListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof MBeanServerNotification) {
                ObjectName name = ((MBeanServerNotification)notification).getMBeanName();
                if (notification.getType().equals("JMX.mbean.registered")) {
                    try {
                        HashMap hashMap = RJMXConnection.this.m_cachedInfos;
                        synchronized (hashMap) {
                            RJMXConnection.this.getMBeanInfo(name);
                            if (RJMXConnection.this.m_cachedMBeanNames.size() > 0) {
                                RJMXConnection.this.m_cachedMBeanNames.add(name);
                            }
                        }
                        for (IMBeanServerChangeListener l : RJMXConnection.this.m_mbeanListeners) {
                            l.mbeanRegistered(name);
                        }
                    }
                    catch (Exception e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not retrieve MBean information for " + name + '!', e);
                    }
                } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                    HashMap e = RJMXConnection.this.m_cachedInfos;
                    synchronized (e) {
                        RJMXConnection.this.m_cachedInfos.remove(name);
                        RJMXConnection.this.m_cachedMBeanNames.remove(name);
                    }
                    for (IMBeanServerChangeListener l : RJMXConnection.this.m_mbeanListeners) {
                        l.mbeanUnregistered(name);
                    }
                }
            }
        }
    };
    private final NotificationListener m_disconnectListener = new NotificationListener(){

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification != null && ("jmx.remote.connection.closed".equals(notification.getType()) || "jmx.remote.connection.failed".equals(notification.getType()))) {
                RJMXConnection.this.close();
                if (RJMXConnection.this.m_onFailCallback != null) {
                    RJMXConnection.this.m_onFailCallback.run();
                }
            }
        }
    };
    private final Object connectionStateLock = new Object();

    public RJMXConnection(IConnectionDescriptor connectionDescriptor, IServerDescriptor serverDescriptor, Runnable onFailCallback) {
        if (connectionDescriptor == null) {
            throw new IllegalArgumentException("Connection descriptor must not be null!");
        }
        if (serverDescriptor == null) {
            throw new IllegalArgumentException("Server descriptor must not be null!");
        }
        this.m_onFailCallback = onFailCallback;
        this.m_connectionDescriptor = connectionDescriptor;
        this.m_serverDescriptor = serverDescriptor;
        this.m_mbeanDataProvider = new MBeanMRIMetadataDB(this);
        this.addMBeanServerChangeListener(this.m_mbeanDataProvider);
    }

    public IServerDescriptor getServerDescriptor() {
        return this.m_serverDescriptor;
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.m_connectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionStateLock;
        synchronized (object) {
            if (this.isConnected()) {
                MCMBeanServerConnection tmpServer = this.m_server;
                this.m_server = null;
                this.tryRemovingListener(tmpServer);
                tmpServer.dispose();
                this.clearCollections();
                if (this.m_jmxc != null) {
                    try {
                        this.m_jmxc.close();
                    }
                    catch (Exception e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.INFO, "Problem when closing connection.", e);
                    }
                    this.m_jmxc = null;
                }
            }
        }
    }

    private void clearCollections() {
        this.clearCache();
    }

    private void tryRemovingListener(MCMBeanServerConnection tmpServer) {
        try {
            if (tmpServer != null) {
                tmpServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.m_registrationListener);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to remove unregistration listener! Lost connection?", e);
        }
    }

    public boolean isConnected() {
        return this.m_server != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ObjectName> getMBeanNames() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            if (this.m_cachedMBeanNames.size() == 0) {
                MBeanServerConnection server = this.ensureConnected();
                this.m_cachedMBeanNames = server.queryNames(null, null);
            }
            return new HashSet<ObjectName>(this.m_cachedMBeanNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<ObjectName, MBeanInfo> getMBeanInfos() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            this.initializeMBeanInfos();
            return new HashMap<ObjectName, MBeanInfo>(this.m_cachedInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanInfo getMBeanInfo(ObjectName mbean) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            MBeanServerConnection server;
            MBeanInfo mbeanInfo = this.m_cachedInfos.get(mbean);
            if (mbeanInfo == null && (mbeanInfo = (server = this.ensureConnected()).getMBeanInfo(mbean)) != null) {
                this.m_cachedInfos.put(mbean, mbeanInfo);
            }
            return mbeanInfo;
        }
    }

    @Override
    public Object getAttributeValue(MRI attribute) throws AttributeNotFoundException, MBeanException, IOException, InstanceNotFoundException, ReflectionException {
        try {
            MBeanServerConnection server = this.ensureConnected();
            return AttributeValueToolkit.getAttribute(server, attribute);
        }
        catch (JMRuntimeException e) {
            throw new MBeanException(e, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect() throws ConnectionException {
        JVMDescriptor jvmInfo = this.getServerDescriptor().getJvmInfo();
        if (jvmInfo != null && jvmInfo.getJavaVersion() != null && !new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JDK_6)) {
            throw new ConnectionException("Too low JDK Version. JDK 1.6 or higher is supported.");
        }
        Object object = this.connectionStateLock;
        synchronized (object) {
            JMXServiceURL url;
            if (this.isConnected()) {
                return false;
            }
            try {
                url = this.m_connectionDescriptor.createJMXServiceURL();
            }
            catch (IOException e1) {
                throw new WrappedConnectionException(this.m_serverDescriptor.getDisplayName(), null, e1);
            }
            try {
                String hostName = ConnectionToolkit.getHostName(url);
                if (hostName != null && hostName.equals("localhost") && ConnectionToolkit.getPort(url) == 0) {
                    this.m_server = new MCMBeanServerConnection(ManagementFactory.getPlatformMBeanServer());
                } else {
                    this.establishConnection(url, this.m_connectionDescriptor.getEnvironment());
                }
                this.tryToAddMBeanNotificationListener();
                this.m_remoteStartTime = this.fetchServerStartTime();
                return true;
            }
            catch (Exception e) {
                this.m_server = null;
                throw new WrappedConnectionException(this.m_serverDescriptor.getDisplayName(), url, e);
            }
        }
    }

    @Override
    public long getApproximateServerTime(long localTime) {
        long startTime = System.currentTimeMillis();
        if (startTime - this.m_lastRecalibration > 120000L && this.m_remoteStartTime != -1L) {
            try {
                long uptime = ConnectionToolkit.getRuntimeBean(this.ensureConnected()).getUptime();
                long returnTime = System.currentTimeMillis();
                long localTimeEstimate = (startTime + returnTime) / 2L;
                this.m_serverOffset = this.m_remoteStartTime + uptime - localTimeEstimate;
                this.m_lastRecalibration = returnTime;
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not recalibrate server offset", e);
            }
        }
        return localTime + this.m_serverOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            this.m_cachedInfos.clear();
            this.m_cachedMBeanNames.clear();
            this.m_hasInitializedAllMBeans = false;
        }
    }

    public String toString() {
        return "RJMX Connection " + this.m_connectionId + ": " + this.m_serverDescriptor.getDisplayName();
    }

    @Override
    public void removeMBeanServerChangeListener(IMBeanServerChangeListener listener) {
        this.m_mbeanListeners.remove((Object)listener);
    }

    @Override
    public void addMBeanServerChangeListener(IMBeanServerChangeListener listener) {
        this.m_mbeanListeners.add((Object)listener);
    }

    @Override
    public Map<MRI, Map<String, Object>> getMBeanMetadata(ObjectName mbean) {
        return this.m_mbeanDataProvider.getMBeanData(mbean);
    }

    public Collection<IOperation> getOperations(ObjectName mbean) throws Exception {
        MBeanServerConnection connection = this.ensureConnected();
        return MBeanOperationWrapper.createOperations(connection, mbean, connection.getMBeanInfo(mbean).getOperations());
    }

    IMRIService getMRIService() {
        return this.m_mbeanDataProvider;
    }

    MBeanServerConnection getMBeanServer() {
        return this.m_server;
    }

    private HashMap<ObjectName, MBeanInfo> getMBeanInfos(String domain, QueryExp query) throws MalformedObjectNameException, IOException {
        MBeanServerConnection server = this.ensureConnected();
        ObjectName objectName = null;
        int skippedMBeanCounter = 0;
        if (domain != null) {
            objectName = new ObjectName(String.valueOf(domain) + ":*");
        }
        Set<ObjectName> names = server.queryNames(objectName, query);
        HashMap<ObjectName, MBeanInfo> infos = new HashMap<ObjectName, MBeanInfo>(names.size());
        for (ObjectName name : names) {
            try {
                infos.put(name, this.getMBeanInfo(name));
            }
            catch (NullPointerException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Skipping " + name.toString() + ". Could not retrieve the MBean info for the MBean. Set log level to fine for stacktrace!");
                RJMXPlugin.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
                ++skippedMBeanCounter;
            }
            catch (UnmarshalException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Skipping " + name.toString() + ". Could not retrieve the MBean info due to marshalling problems. Set log level to fine for stacktrace!");
                RJMXPlugin.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
                ++skippedMBeanCounter;
            }
            catch (InstanceNotFoundException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Skipping " + name.toString() + ". It could not be found and may have been unregistered very recently. Set log level to fine to fine for stacktrace!");
                RJMXPlugin.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
            }
            catch (IntrospectionException e) {
                IOException exception = new IOException("Error accessing the bean.");
                exception.initCause(e);
                throw exception;
            }
            catch (ReflectionException e) {
                IOException exception = new IOException("Error accessing the bean.");
                exception.initCause(e);
                throw exception;
            }
        }
        if (skippedMBeanCounter > 0) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Skipped " + skippedMBeanCounter + " MBeans because of marshalling related issues.");
        }
        return infos;
    }

    private void tryToAddMBeanNotificationListener() {
        try {
            this.ensureConnected().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this.m_registrationListener, null, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMBeanInfos() throws IOException {
        HashMap<ObjectName, MBeanInfo> hashMap = this.m_cachedInfos;
        synchronized (hashMap) {
            block6: {
                if (!this.m_hasInitializedAllMBeans) {
                    try {
                        this.getMBeanInfos(null, null);
                        this.m_hasInitializedAllMBeans = true;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private long fetchServerStartTime() throws IOException {
        try {
            return ConnectionToolkit.getRuntimeBean(this.ensureConnected()).getStartTime();
        }
        catch (IllegalArgumentException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not find the Runtime MBean. You are probably connecting to a custom MBean server. Functionality will be limited.", e);
            return -1L;
        }
    }

    private void establishConnection(JMXServiceURL serviceURL, Map<String, Object> env) throws IOException {
        try {
            this.connectJmxConnector(serviceURL, env);
        }
        catch (IOException exception) {
            try {
                if (env.get(KEY_SOCKET_FACTORY) instanceof SslRMIClientSocketFactory) {
                    env.remove(KEY_SOCKET_FACTORY);
                } else {
                    env.put(KEY_SOCKET_FACTORY, new SslRMIClientSocketFactory());
                }
                this.connectJmxConnector(serviceURL, env);
            }
            catch (IOException iOException) {
                throw exception;
            }
        }
        this.m_server = new MCMBeanServerConnection(this.m_jmxc.getMBeanServerConnection());
    }

    private void connectJmxConnector(JMXServiceURL serviceURL, Map<String, Object> env) throws IOException {
        this.m_jmxc = JMXConnectorFactory.newJMXConnector(serviceURL, env);
        this.m_jmxc.addConnectionNotificationListener(this.m_disconnectListener, null, null);
        JMXRMISystemPropertiesProvider.setup();
        this.m_jmxc.connect(env);
        JMXRMISystemPropertiesProvider.clearJMXRMISystemProperties();
    }

    private MBeanServerConnection ensureConnected() throws IOException {
        MCMBeanServerConnection server = this.m_server;
        if (server == null) {
            throw new InvoluntaryDisconnectException("Server is disconnected!");
        }
        return server;
    }
}

