/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.util.UUID;
import org.openjdk.jmc.rjmx.IServerDescriptor;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;
import org.openjdk.jmc.ui.common.labelingrules.NameConverter;

public class ServerDescriptor
implements IServerDescriptor {
    private final String guid;
    private final String name;
    private final JVMDescriptor jvmInfo;

    public ServerDescriptor() {
        this(null, null, null);
    }

    public ServerDescriptor(String guid, String name, JVMDescriptor jvmInfo) {
        String string = this.guid = guid == null ? UUID.randomUUID().toString() : guid;
        this.name = name == null ? (jvmInfo != null ? NameConverter.getInstance().format(jvmInfo) : this.guid) : name;
        this.jvmInfo = jvmInfo;
    }

    public ServerDescriptor(IServerDescriptor sd, String name) {
        this(sd.getGUID(), name, sd.getJvmInfo());
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public JVMDescriptor getJvmInfo() {
        return this.jvmInfo;
    }
}

