/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import org.openjdk.jmc.rjmx.internal.SyntheticAttributeEntry;

public class SyntheticAttributeMBeanEntry
implements DynamicMBean {
    private final Map<String, SyntheticAttributeEntry> attributeMap = new HashMap<String, SyntheticAttributeEntry>();
    private final MBeanServerConnection connection;

    public SyntheticAttributeMBeanEntry(MBeanServerConnection connection) {
        this.connection = connection;
    }

    public void addSyntheticAttribute(SyntheticAttributeEntry entry) {
        this.attributeMap.put(entry.getAttributeDescriptor().getDataPath(), entry);
    }

    public void removeSyntheticAttribute(SyntheticAttributeEntry entry) {
        this.attributeMap.remove(entry.getAttributeDescriptor().getDataPath());
    }

    Collection<SyntheticAttributeEntry> getSyntheticAttributes() {
        return this.attributeMap.values();
    }

    @Override
    public Object getAttribute(String attribute) throws MBeanException, ReflectionException {
        return this.attributeMap.get(attribute).getAttribute().getValue(this.connection);
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException, MBeanException, ReflectionException {
        this.attributeMap.get(attribute.getName()).getAttribute().setValue(this.connection, attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList al = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            try {
                Attribute a = new Attribute(attribute, this.attributeMap.get(attribute).getAttribute().getValue(this.connection));
                al.add(a);
            }
            catch (MBeanException mBeanException) {
            }
            catch (ReflectionException reflectionException) {}
            ++n2;
        }
        return al;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList();
        for (Object a : attributes) {
            try {
                Attribute attribute = (Attribute)a;
                this.setAttribute(attribute);
                result.add(attribute);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (MBeanException mBeanException) {
            }
            catch (ReflectionException reflectionException) {}
        }
        return result;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new IllegalArgumentException("Not implemented yet!");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), "Dynamic Synthetic MBean", this.createAttributeInfos(), null, null, null);
    }

    private MBeanAttributeInfo[] createAttributeInfos() {
        Collection<SyntheticAttributeEntry> entries = this.attributeMap.values();
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[entries.size()];
        int i = 0;
        for (SyntheticAttributeEntry entry : this.attributeMap.values()) {
            attributeInfos[i++] = this.createAttributeInfo(entry);
        }
        return attributeInfos;
    }

    private MBeanAttributeInfo createAttributeInfo(SyntheticAttributeEntry entry) {
        return new MBeanAttributeInfo(entry.getAttributeDescriptor().getDataPath(), entry.getType(), entry.getDescription(), entry.isReadable(), entry.isWriteable(), entry.isIs(), this.createDescriptor());
    }

    private Descriptor createDescriptor() {
        return new ImmutableDescriptor("synthetic=true");
    }

    public boolean hasDataPath(String dataPath) {
        for (SyntheticAttributeEntry entry : this.attributeMap.values()) {
            if (!entry.getAttributeDescriptor().getDataPath().equals(dataPath)) continue;
            return true;
        }
        return false;
    }
}

