/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.persistence.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Comparator;
import java.util.Locale;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.ui.common.xydata.DefaultTimestampedData;
import org.openjdk.jmc.ui.common.xydata.ITimestampedData;

class PersistenceFile {
    static final String FILE_EXT = ".persisted_jmx_data";
    public static final FilenameFilter FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.ENGLISH).endsWith(PersistenceFile.FILE_EXT);
        }
    };
    public static final Comparator<PersistenceFile> PERSISTENCE_FILE_START_COMPARATOR = new Comparator<PersistenceFile>(){

        @Override
        public int compare(PersistenceFile o1, PersistenceFile o2) {
            return o1.start < o2.start ? -1 : (o1.start > o2.start ? 1 : 0);
        }
    };
    static final int EVENT_SIZE = 16;
    final File file;
    ITimestampedData[] events;
    final long eventsStart;
    final int eventCount;
    final long start;
    final long end;
    final MRI mri;
    final long fileLen;

    PersistenceFile(File file) throws IOException {
        this.file = file;
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            this.mri = MRI.createFromQualifiedName(raf.readUTF());
            this.fileLen = raf.length();
            this.eventsStart = raf.getFilePointer();
            this.eventCount = (int)((this.fileLen - this.eventsStart) / 16L);
            if (this.eventCount > 0) {
                this.start = raf.readLong();
                raf.seek(this.eventsStart + (long)(this.eventCount - 1) * 16L);
                this.end = raf.readLong();
            } else {
                this.start = Long.MAX_VALUE;
                this.end = Long.MAX_VALUE;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    boolean isCorrupt() {
        return this.eventsStart + (long)this.eventCount * 16L != this.fileLen;
    }

    synchronized ITimestampedData[] getEvents(long min, long max) throws IOException {
        if (this.events == null) {
            this.events = new ITimestampedData[this.eventCount];
            Throwable throwable = null;
            Object var6_5 = null;
            try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
                this.readEvents(raf, 0, this.eventCount);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.events;
    }

    MRI getMRI() {
        return this.mri;
    }

    private void readEvents(RandomAccessFile raf, int index, int count) throws IOException {
        byte[] data = new byte[count * 16];
        raf.seek(this.eventsStart + (long)index * 16L);
        raf.readFully(data);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        int i = 0;
        while (i < count) {
            this.events[index + i] = new DefaultTimestampedData(Long.valueOf(dis.readLong()), (Number)dis.readDouble());
            ++i;
        }
    }
}

