/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProviderService;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.MRI;

public class ExtensionMetadataProviderService
implements IMRIMetadataProviderService {
    private boolean m_hasInitializedExtensions = false;
    private final List<IMRIMetadataProviderService> m_providers = new ArrayList<IMRIMetadataProviderService>();

    private synchronized void checkExtenstionsInitialized() {
        if (!this.m_hasInitializedExtensions) {
            this.initializeFromExtensions();
            this.m_hasInitializedExtensions = true;
        }
    }

    private void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("org.openjdk.jmc.rjmx.metadataprovider");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("metadataProvider")) {
                    try {
                        IMRIMetadataProviderService provider = (IMRIMetadataProviderService)config.createExecutableExtension("class");
                        this.m_providers.add(provider);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate metadata provider '" + config.getAttribute("class") + "'!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public Object getMetadata(IMRIMetadataService metadataService, MRI mri, String dataKey) {
        this.checkExtenstionsInitialized();
        for (IMRIMetadataProviderService providerService : this.m_providers) {
            Object value = providerService.getMetadata(metadataService, mri, dataKey);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

