/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.storage.internal;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.jmc.rjmx.internal.IDisposableService;
import org.openjdk.jmc.rjmx.services.IAttributeStorage;
import org.openjdk.jmc.rjmx.services.IAttributeStorageService;
import org.openjdk.jmc.rjmx.subscription.ISubscriptionService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.storage.internal.BufferingAttributeStorage;

public class DefaultAttributeStorageService
implements IAttributeStorageService,
IDisposableService {
    private final ISubscriptionService attributeSubscriptionService;
    private Map<MRI, BufferingAttributeStorage> activeStorages = new HashMap<MRI, BufferingAttributeStorage>();

    public DefaultAttributeStorageService(ISubscriptionService subscriptionService) {
        this.attributeSubscriptionService = subscriptionService;
    }

    @Override
    public synchronized IAttributeStorage getAttributeStorage(MRI mri) {
        if (this.activeStorages == null) {
            throw new IllegalStateException("Attribute storage service is disposed!");
        }
        BufferingAttributeStorage storage = this.activeStorages.get(mri);
        if (storage == null) {
            storage = new BufferingAttributeStorage(mri, this.attributeSubscriptionService);
            this.activeStorages.put(mri, storage);
        }
        return storage;
    }

    @Override
    public int getRetainedLength(MRI mri) {
        if (this.activeStorages == null) {
            throw new IllegalStateException("Attribute storage service is disposed!");
        }
        BufferingAttributeStorage storage = this.activeStorages.get(mri);
        if (storage != null) {
            return storage.getRetainedLength();
        }
        return 0;
    }

    @Override
    public synchronized void dispose() {
        for (BufferingAttributeStorage s : this.activeStorages.values()) {
            s.dispose();
        }
        this.activeStorages = null;
    }
}

