/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.condition.internal;

import java.util.logging.Level;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.triggers.IValueEvaluator;
import org.openjdk.jmc.rjmx.triggers.condition.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.fields.internal.BooleanField;
import org.openjdk.jmc.rjmx.triggers.fields.internal.Field;
import org.openjdk.jmc.rjmx.triggers.fields.internal.FieldHolder;
import org.openjdk.jmc.rjmx.triggers.fields.internal.QuantityField;
import org.openjdk.jmc.rjmx.triggers.fields.internal.StringField;
import org.openjdk.jmc.rjmx.triggers.internal.INotificationFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationTrigger;
import org.openjdk.jmc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import org.openjdk.jmc.rjmx.triggers.internal.ValueEvaluatorNumberMin;
import org.openjdk.jmc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import org.w3c.dom.Element;

public class TriggerCondition
extends NotificationTrigger {
    public static final String FIELD_SUSTAINED = "SUSTAINED";
    public static final String FIELD_LIMIT = "LIMIT";
    public static final String FIELD_ONTRIGGER = "ONTRIGGER";
    public static final String FIELD_ONFLANK = "ONFLANK";
    public static final String FIELD_EVAL_STRING = "EVAL_STRING";
    public static final String FIELD_EVAL_NUM_MAX = "EVAL_NUM_MAX";
    public static final String FIELD_EVAL_NUM_MIN = "EVAL_NUM_MIN";
    private FieldHolder m_fieldHolder;

    void initEvaluator() {
        try {
            IValueEvaluator ve = this.getValueEvaluator();
            if (ve instanceof ValueEvaluatorNumberMax) {
                this.createNumberMaxEvaluatorField(((ValueEvaluatorNumberMax)ve).getMax());
            } else {
                this.createNumberMaxEvaluatorField((IQuantity)UnitLookup.NUMBER.getDefaultUnit().quantity(0L));
            }
            if (ve instanceof ValueEvaluatorNumberMin) {
                this.createNumberMinEvaluatorField(((ValueEvaluatorNumberMin)ve).getMin());
            } else {
                this.createNumberMinEvaluatorField((IQuantity)UnitLookup.NUMBER.getDefaultUnit().quantity(0L));
            }
            if (ve instanceof ValueEvaluatorStringMatch) {
                this.createStringEvaluatorField(((ValueEvaluatorStringMatch)ve).getMatchString());
            } else {
                this.createStringEvaluatorField("*");
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void initFieldHolder() {
        this.m_fieldHolder = new FieldHolder();
        try {
            this.initEvaluator();
            this.createSustained();
            this.createLimit();
            this.createFlankBegin();
            this.createFlankEnd();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void initializeFromXml(Element node, INotificationFactory factory) {
        super.initializeFromXml(node, factory);
        this.initFieldHolder();
    }

    public FieldHolder getFieldHolder() {
        return this.m_fieldHolder;
    }

    private void createFlankEnd() throws Exception {
        boolean descendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankEnd = new BooleanField(FIELD_ONFLANK, Messages.TriggerCondition_DESCENDING_FLANK_CAPTION, Boolean.toString(descendingFlank), Messages.TriggerCondition_DESCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankEnd);
        triggeronFlankEnd.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(2, field.getBoolean());
            }
        });
    }

    private void createFlankBegin() throws Exception {
        boolean ascendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankStart = new BooleanField(FIELD_ONTRIGGER, Messages.TriggerCondition_ASCENDING_FLANK_CAPTION, Boolean.toString(ascendingFlank), Messages.TriggerCondition_ASCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankStart);
        triggeronFlankStart.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(1, field.getBoolean());
            }
        });
    }

    private void createLimit() throws Exception {
        LinearUnit second = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NONE);
        IQuantity zeroQuantity = second.quantity(0L);
        QuantityField limitField = new QuantityField(FIELD_LIMIT, Messages.TriggerCondition_LIMIT_PERIOD_CAPTION, "0", Messages.TriggerCondition_LIMIT_PERIOD_TOOLTIP);
        limitField.initKind(second.getContentType(), second.quantity((long)this.getLimitTime()).interactiveFormat(), zeroQuantity, null);
        this.m_fieldHolder.addField(limitField);
        limitField.addFieldValueListener(new Field.FieldValueChangeListener((IUnit)second){
            private final /* synthetic */ IUnit val$second;
            {
                this.val$second = iUnit;
            }

            @Override
            public void onChange(Field field) {
                try {
                    TriggerCondition.this.setLimitTime((int)field.getQuantity().longValueIn(this.val$second, Integer.MAX_VALUE));
                }
                catch (QuantityConversionException quantityConversionException) {}
            }
        });
    }

    private void createSustained() throws Exception {
        LinearUnit second = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.NONE);
        IQuantity zeroQuantity = second.quantity(0L);
        QuantityField sustained = new QuantityField(FIELD_SUSTAINED, Messages.TriggerCondition_SUSTAINED_CAPTION, "0", Messages.TriggerCondition_SUSTAINED_TOOLTIP);
        sustained.initKind(second.getContentType(), second.quantity((long)this.getSustainTime()).interactiveFormat(), zeroQuantity, null);
        this.m_fieldHolder.addField(sustained);
        sustained.addFieldValueListener(new Field.FieldValueChangeListener((IUnit)second){
            private final /* synthetic */ IUnit val$second;
            {
                this.val$second = iUnit;
            }

            @Override
            public void onChange(Field field) {
                try {
                    TriggerCondition.this.setSustainTime((int)field.getQuantity().longValueIn(this.val$second, Integer.MAX_VALUE));
                }
                catch (QuantityConversionException quantityConversionException) {}
            }
        });
    }

    private void createStringEvaluatorField(String matchString) throws Exception {
        StringField evaluatorField = new StringField(FIELD_EVAL_STRING, Messages.TriggerCondition_MATCH_STRING_CAPTION, matchString, Messages.TriggerCondition_MATCH_STRING_TOOLTIP);
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator(new ValueEvaluatorStringMatch(field.getString()));
            }
        });
    }

    private void createNumberMaxEvaluatorField(IQuantity maxValue) throws Exception {
        QuantityField evaluatorField = new QuantityField(FIELD_EVAL_NUM_MAX, Messages.TriggerCondition_MAX_TRIGGER_CAPTION, "0", Messages.TriggerCondition_MAX_TRIGGER_TOOLTIP);
        evaluatorField.initKind(maxValue.getUnit().getContentType(), maxValue.interactiveFormat(), null, null);
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                IQuantity quantity = field.getQuantity();
                if (quantity != null) {
                    TriggerCondition.this.setValueEvaluator(new ValueEvaluatorNumberMax(quantity));
                }
            }
        });
    }

    private void createNumberMinEvaluatorField(IQuantity minValue) throws Exception {
        QuantityField evaluatorField = new QuantityField(FIELD_EVAL_NUM_MIN, Messages.TriggerCondition_MIN_TRIGGER_CAPTION, "0", Messages.TriggerCondition_MIN_TRIGGER_TOOLTIP);
        evaluatorField.initKind(minValue.getUnit().getContentType(), minValue.interactiveFormat(), null, null);
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                IQuantity quantity = field.getQuantity();
                if (quantity != null) {
                    TriggerCondition.this.setValueEvaluator(new ValueEvaluatorNumberMin(quantity));
                }
            }
        });
    }

    public void setTriggerFlag(int flag, boolean value) {
        int triggerOn = this.getTriggerOn();
        triggerOn = value ? triggerOn | flag : triggerOn & ~flag;
        this.setTriggerOn(triggerOn);
    }
}

