/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.wizards;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.OptimisticComparator;

public abstract class BaseWizardPage
extends WizardPage {
    private static final String FILE_OPEN_FILTER_PATH = "file.open.filter.path";
    private Map<Widget, Exception> exceptions = new HashMap<Widget, Exception>();

    protected BaseWizardPage(String pageName) {
        super(pageName);
    }

    protected BaseWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(true);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.exceptions.isEmpty();
    }

    protected static Composite createComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    protected static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected static Text createText(Composite parent, String hint) {
        Text text = new Text(parent, 2048);
        text.setMessage(hint);
        text.setEnabled(true);
        return text;
    }

    protected static Text createMultiText(Composite parent, String hint) {
        Text text = new Text(parent, 2562);
        text.setMessage(hint);
        text.setEnabled(true);
        return text;
    }

    protected static Label createSeparator(Composite parent) {
        return new Label(parent, 258);
    }

    protected static Combo createCombo(Composite parent, String[] items) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(items);
        return combo;
    }

    protected static Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        return button;
    }

    protected static Button createCheckbox(Composite parent, String text) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(text);
        return checkbox;
    }

    protected static Spinner createSpinner(Composite parent) {
        return new Spinner(parent, 0);
    }

    protected static void setText(Text receiver, String text) {
        text = text == null ? "" : text;
        receiver.setText(text);
    }

    protected static void setText(Combo receiver, String text) {
        text = text == null ? "" : text;
        receiver.setText(text);
    }

    protected static Text createTextInput(Composite parent, int cols, String label, String hint) {
        Label l = BaseWizardPage.createLabel(parent, label);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 0));
        Text t = BaseWizardPage.createText(parent, hint);
        t.setLayoutData((Object)new GridData(4, 0x1000000, true, true, cols - 2, 0));
        return t;
    }

    protected static Text createMultiTextInput(Composite parent, int cols, String label, String hint) {
        Label l = BaseWizardPage.createLabel(parent, label);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, cols, 0));
        Text t = BaseWizardPage.createMultiText(parent, hint);
        GridData gd = new GridData(4, 0x1000000, true, true, cols, 0);
        gd.heightHint = 100;
        t.setLayoutData((Object)gd);
        return t;
    }

    protected static Text[] createMultiInputTextInput(Composite parent, int cols, String label, String[] hints) {
        Label l = BaseWizardPage.createLabel(parent, label);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 0));
        Composite container = BaseWizardPage.createComposite(parent);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, true, cols - 2, 0));
        container.setLayout((Layout)new FillLayout());
        Text[] t = new Text[hints.length];
        int i = 0;
        while (i < hints.length) {
            t[i] = BaseWizardPage.createText(container, hints[i]);
            ++i;
        }
        return t;
    }

    protected static Combo createComboInput(Composite parent, int cols, String label, String[] items) {
        Label l = BaseWizardPage.createLabel(parent, label);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 0));
        Combo c = BaseWizardPage.createCombo(parent, items);
        c.setLayoutData((Object)new GridData(4, 0x1000000, true, true, cols - 2, 0));
        return c;
    }

    protected static Button createCheckboxInput(Composite parent, int cols, String text) {
        Button b = BaseWizardPage.createCheckbox(parent, text);
        b.setLayoutData((Object)new GridData(4, 4, false, false, cols, 0));
        return b;
    }

    protected static Spinner createSpinnerInput(Composite parent, int cols, String label) {
        Label l = BaseWizardPage.createLabel(parent, label);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 0));
        Spinner s = BaseWizardPage.createSpinner(parent);
        s.setLayoutData((Object)new GridData(4, 0x1000000, true, true, cols - 2, 0));
        return s;
    }

    protected ModifyListener handleExceptionIfAny(ModifyListener listener) {
        return e -> this.handleExceptionIfAny(e.widget, () -> listener.modifyText(e));
    }

    protected Listener handleExceptionIfAny(Listener listener) {
        return e -> this.handleExceptionIfAny(e.widget, () -> listener.handleEvent(e));
    }

    protected void handleExceptionIfAny(Widget widget, Runnable runnable) {
        try {
            runnable.run();
            this.exceptions.remove(widget);
            if (this.exceptions.isEmpty()) {
                this.setErrorMessage(null);
            }
        }
        catch (IllegalArgumentException e) {
            this.exceptions.put(widget, e);
            this.setErrorMessage(e.getLocalizedMessage());
        }
        catch (Exception e) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            DialogToolkit.showException((Shell)window.getShell(), (String)Messages.BaseWizardPage_MESSAGE_UNEXPECTED_ERROR_HAS_OCCURRED, (Throwable)e);
        }
        this.setPageComplete(this.exceptions.isEmpty());
        this.getWizard().getContainer().updateButtons();
    }

    protected String[] openFileDialog(String title, String[] extensions, int style) {
        String filterPath = FlightRecorderUI.getDefault().getDialogSettings().get(FILE_OPEN_FILTER_PATH);
        if (filterPath != null && Files.notExists(Paths.get(filterPath, new String[0]), new LinkOption[0])) {
            filterPath = System.getProperty("user.home", "./");
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        FileDialog dialog = new FileDialog(window.getShell(), style);
        dialog.setFilterPath(filterPath);
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        if (dialog.open() == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(dialog.getFileNames()).map(name -> String.valueOf(dialog.getFilterPath()) + File.separator + name).toArray(String[]::new);
    }

    protected static abstract class TableInspector
    extends Composite {
        public static final int MULTI = 1;
        public static final int SHOW_HEADER = 2;
        public static final int ADD_BUTTON = 4;
        public static final int EDIT_BUTTON = 8;
        public static final int DUPLICATE_BUTTON = 16;
        public static final int REMOVE_BUTTON = 32;
        public static final int IMPORT_FILES_BUTTON = 64;
        public static final int EXPORT_FILE_BUTTON = 128;
        private static final String LABEL_ADD_BUTTON = "Add...";
        private static final String LABEL_EDIT_BUTTON = "Edit";
        private static final String LABEL_DUPLICATE_BUTTON = "Duplicate";
        private static final String LABEL_REMOVE_BUTTON = "Remove";
        private static final String LABEL_IMPORT_FILES_BUTTON = "Import Files...";
        private static final String LABEL_EXPORT_FILE_BUTTON = "Export File...";
        private final int options;
        private final List<IColumn> columns = new ArrayList<IColumn>();
        private final List<Button> buttons = new ArrayList<Button>();
        private final TableViewer tableViewer;
        private final Composite buttonContainer;
        private Button addButton;
        private Button editButton;
        private Button duplicateButton;
        private Button removeButton;
        private Button importFilesButton;
        private Button exportFileButton;

        protected TableInspector(Composite parent, int options) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.options = options;
            int style = 68096;
            if ((options & 1) != 0) {
                style |= 2;
            }
            this.tableViewer = new TableViewer((Composite)this, style);
            this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.addColumns();
            ColumnManager.build((TableViewer)this.tableViewer, this.columns, null);
            this.tableViewer.getTable().setHeaderVisible((options & 2) != 0);
            this.buttonContainer = new Composite((Composite)this, 0);
            this.buttonContainer.setLayoutData((Object)new GridData(4, 1, false, true));
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.buttonContainer.setLayout((Layout)layout);
            this.addButtons();
            if (this.buttons.isEmpty()) {
                this.buttonContainer.dispose();
                this.setLayout((Layout)new GridLayout(1, false));
            }
            this.bindListeners();
        }

        protected final void addColumn(String name, String id, ColumnLabelProvider labelProvider) {
            this.columns.add(new ColumnBuilder(name, id, labelProvider).comparator((Comparator)new OptimisticComparator((ILabelProvider)labelProvider)).build());
        }

        protected final void addColumn(String id, ColumnLabelProvider labelProvider) {
            this.columns.add(new ColumnBuilder("", id, labelProvider).comparator((Comparator)new OptimisticComparator((ILabelProvider)labelProvider)).build());
        }

        protected abstract void addColumns();

        protected final Button addButton(String text) {
            Button b = BaseWizardPage.createButton(this.buttonContainer, text);
            b.setLayoutData((Object)new GridData(4, 4, true, true));
            this.buttons.add(b);
            return b;
        }

        protected void addButtons() {
            if ((this.options & 4) != 0) {
                this.addButton = this.addButton(LABEL_ADD_BUTTON);
            }
            if ((this.options & 8) != 0) {
                this.editButton = this.addButton(LABEL_EDIT_BUTTON);
            }
            if ((this.options & 0x10) != 0) {
                this.duplicateButton = this.addButton(LABEL_DUPLICATE_BUTTON);
            }
            if ((this.options & 0x20) != 0) {
                this.removeButton = this.addButton(LABEL_REMOVE_BUTTON);
            }
            if ((this.options & 0x40) != 0) {
                this.importFilesButton = this.addButton(LABEL_IMPORT_FILES_BUTTON);
            }
            if ((this.options & 0x80) != 0) {
                this.exportFileButton = this.addButton(LABEL_EXPORT_FILE_BUTTON);
            }
        }

        public Button getAddButton() {
            return this.addButton;
        }

        public Button getEditButton() {
            return this.editButton;
        }

        public Button getDuplicateButton() {
            return this.duplicateButton;
        }

        public Button getRemoveButton() {
            return this.removeButton;
        }

        public Button getImportFilesButton() {
            return this.importFilesButton;
        }

        public Button getExportFileButton() {
            return this.exportFileButton;
        }

        public void setContentProvider(IContentProvider contentProvider) {
            this.tableViewer.setContentProvider(contentProvider);
        }

        public void setInput(Object input) {
            this.tableViewer.setInput(input);
        }

        public TableViewer getViewer() {
            return this.tableViewer;
        }

        protected void bindListeners() {
            if (this.addButton != null) {
                this.addButton.addListener(13, e -> this.onAddButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            if (this.editButton != null) {
                this.editButton.addListener(13, e -> this.onEditButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            if (this.duplicateButton != null) {
                this.duplicateButton.addListener(13, e -> this.onDuplicateButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            if (this.removeButton != null) {
                this.removeButton.addListener(13, e -> this.onRemoveButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            if (this.importFilesButton != null) {
                this.importFilesButton.addListener(13, e -> this.onImportFilesButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            if (this.exportFileButton != null) {
                this.exportFileButton.addListener(13, e -> this.onExportFileButtonSelected(this.tableViewer.getStructuredSelection()));
            }
            this.tableViewer.addSelectionChangedListener(e -> this.toggleButtonAvailabilityBy(e.getStructuredSelection()));
            this.toggleButtonAvailabilityBy(this.tableViewer.getStructuredSelection());
        }

        protected void toggleButtonAvailabilityBy(IStructuredSelection selection) {
            if (this.addButton != null) {
                this.addButton.setEnabled(true);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(selection.size() == 1);
            }
            if (this.duplicateButton != null) {
                this.duplicateButton.setEnabled(selection.size() == 1);
            }
            if (this.removeButton != null) {
                this.removeButton.setEnabled(!selection.isEmpty());
            }
            if (this.importFilesButton != null) {
                this.importFilesButton.setEnabled(true);
            }
            if (this.exportFileButton != null) {
                this.exportFileButton.setEnabled(selection.size() == 1);
            }
        }

        protected void onExportFileButtonSelected(IStructuredSelection selection) {
        }

        protected void onImportFilesButtonSelected(IStructuredSelection selection) {
        }

        protected void onRemoveButtonSelected(IStructuredSelection selection) {
        }

        protected void onDuplicateButtonSelected(IStructuredSelection selection) {
        }

        protected void onEditButtonSelected(IStructuredSelection selection) {
        }

        protected void onAddButtonSelected(IStructuredSelection selection) {
        }
    }
}

