/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.wizards;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.console.agent.AgentJmxHelper;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.wizards.BaseWizardPage;
import org.openjdk.jmc.ui.common.jvm.JVMDescriptor;

public class StartAgentWizardPage
extends BaseWizardPage {
    private static final String FILE_OPEN_JAR_EXTENSION = "*.jar";
    private static final String FILE_OPEN_XML_EXTENSION = "*.xml";
    private final AgentJmxHelper helper;
    private Text targetJvmText;
    private Text agentJarText;
    private Button agentJarBrowseButton;
    private Text agentXmlText;
    private Button agentXmlBrowseButton;

    protected StartAgentWizardPage(AgentJmxHelper helper) {
        super(Messages.StartAgentWizardPage_PAGE_NAME);
        this.helper = helper;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(Messages.StartAgentWizardPage_MESSAGE_START_AGENT_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.StartAgentWizardPage_MESSAGE_START_AGENT_WIZARD_PAGE_DESCRIPTION);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createTargetJvmContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        StartAgentWizardPage.createSeparator(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createAgentBrowserContainer(container).setLayoutData((Object)new GridData(4, 4, true, false));
        this.bindListeners();
        this.populateUi();
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(container.computeSize(-1, -1));
        this.setControl((Control)sc);
    }

    public JVMDescriptor getTargetJvm() {
        return this.helper.getConnectionHandle().getServerDescriptor().getJvmInfo();
    }

    public String getAgentJarPath() {
        return this.agentJarText.getText();
    }

    public String getAgentXmlPath() {
        return this.agentXmlText.getText();
    }

    private Composite createTargetJvmContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 5;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        this.targetJvmText = StartAgentWizardPage.createTextInput(container, cols, Messages.StartAgentWizardPage_LABEL_TARGET_JVM, "");
        this.targetJvmText.setEnabled(false);
        return container;
    }

    private Composite createAgentBrowserContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        int cols = 8;
        GridLayout layout = new GridLayout(cols, false);
        layout.horizontalSpacing = 8;
        container.setLayout((Layout)layout);
        TrayDialog.setDialogHelpAvailable((boolean)false);
        this.agentJarText = StartAgentWizardPage.createTextInput(container, cols - 2, Messages.StartAgentWizardPage_LABEL_AGENT_JAR, Messages.StartAgentWizardPage_MESSAGE_PATH_TO_AN_AGENT_JAR);
        this.agentJarText.setEditable(false);
        this.agentJarBrowseButton = StartAgentWizardPage.createButton(container, Messages.StartAgentWizardPage_LABEL_BROWSE);
        this.agentJarBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 0));
        this.agentXmlText = StartAgentWizardPage.createTextInput(container, cols - 2, Messages.StartAgentWizardPage_LABEL_AGENT_XML, Messages.StartAgentWizardPage_MESSAGE_PATH_TO_AN_AGENT_CONFIG);
        this.agentXmlText.setEditable(false);
        this.agentXmlBrowseButton = StartAgentWizardPage.createButton(container, Messages.StartAgentWizardPage_LABEL_BROWSE);
        this.agentXmlBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 0));
        return container;
    }

    private void bindListeners() {
        this.agentJarBrowseButton.addListener(13, e -> {
            String[] path = this.openFileDialog(Messages.StartAgentWizardPage_DIALOG_BROWSER_FOR_AGENT_JAR, new String[]{FILE_OPEN_JAR_EXTENSION}, 4100);
            if (path.length != 0) {
                StartAgentWizardPage.setText(this.agentJarText, path[0]);
            }
        });
        this.agentXmlBrowseButton.addListener(13, e -> {
            String[] path = this.openFileDialog(Messages.StartAgentWizardPage_DIALOG_BROWSER_FOR_AGENT_CONFIG, new String[]{FILE_OPEN_XML_EXTENSION}, 4100);
            if (path.length != 0) {
                StartAgentWizardPage.setText(this.agentXmlText, path[0]);
            }
        });
        this.agentJarText.addModifyListener(e -> this.setPageComplete(!this.agentJarText.getText().isEmpty()));
        this.getWizard().getContainer().updateButtons();
    }

    private void populateUi() {
        StartAgentWizardPage.setText(this.targetJvmText, this.helper.getConnectionHandle().getServerDescriptor().getDisplayName());
    }
}

