/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openjdk.jmc.greychart.ChartChangeEvent;
import org.openjdk.jmc.greychart.ChartChangeListener;
import org.openjdk.jmc.greychart.FontAndColors;
import org.openjdk.jmc.greychart.GreyChart;
import org.openjdk.jmc.ui.common.util.Environment;

public class GreyChartPanel
extends JComponent
implements ChartChangeListener {
    public static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.greychart");
    private static final String PROPERTY_KEY_DEBUG = "org.openjdk.jmc.greychart.debug";
    private static final String PROPERTY_KEY_SHOWRENDERINGTIME = "org.openjdk.jmc.greychart.showrenderingtime";
    static final long serialVersionUID = 1L;
    public static final boolean DEBUG;
    private static final boolean SHOW_RENDERING_TIME;
    private static final int[] EMPTY_INT_ARRAY;
    private static final double[] EMPTY_DOUBLE_ARRAY;
    private transient GreyChart m_chart;
    private transient Image m_imageBuffer;
    private final Rectangle m_lastImageRenderingArea = new Rectangle(0, 0, 0, 0);
    private final Rectangle m_lastTargetArea = new Rectangle(0, 0, 0, 0);
    private final Insets m_paintViewInsets = new Insets(0, 0, 0, 0);
    private Font m_debugFont = null;
    private int m_selectionStartX = -1;
    private int m_selectionEndX = -1;

    static {
        EMPTY_INT_ARRAY = new int[0];
        EMPTY_DOUBLE_ARRAY = new double[0];
        DEBUG = GreyChartPanel.isUseDebug();
        SHOW_RENDERING_TIME = GreyChartPanel.isShowRenderingTime();
    }

    public GreyChartPanel(GreyChart chart) {
        this.m_chart = chart;
        this.m_chart.addChangeListener(this);
        this.initializeColors();
    }

    private static boolean isShowRenderingTime() {
        if (System.getProperties().containsKey(PROPERTY_KEY_SHOWRENDERINGTIME)) {
            return Boolean.getBoolean(PROPERTY_KEY_SHOWRENDERINGTIME);
        }
        return Environment.isDebug();
    }

    private static boolean isUseDebug() {
        if (System.getProperties().containsKey(PROPERTY_KEY_DEBUG)) {
            return Boolean.getBoolean(PROPERTY_KEY_DEBUG);
        }
        return Environment.isDebug();
    }

    public GreyChart getChart() {
        return this.m_chart;
    }

    public void initializeColors() {
        this.setBackground(FontAndColors.getDefaultBackground());
        this.setForeground(FontAndColors.getDefaultForeground());
    }

    public void setChart(GreyChart chart) {
        this.m_chart = chart;
    }

    @Override
    public void paintComponent(Graphics g) {
        long start = System.currentTimeMillis();
        Insets insets = this.getInsets(this.m_paintViewInsets);
        this.m_lastTargetArea.x = insets.left;
        this.m_lastTargetArea.y = insets.top;
        this.m_lastTargetArea.width = this.getWidth() - (insets.left + insets.right);
        this.m_lastTargetArea.height = this.getHeight() - (insets.top + insets.bottom);
        if (this.m_chart != null) {
            if (DEBUG) {
                this.m_lastTargetArea.width = this.getWidth();
                this.m_lastTargetArea.height = this.getHeight();
                this.m_chart.render((Graphics2D)g, this.m_lastTargetArea);
            } else {
                g.drawImage(this.createPlotImage(this.m_lastTargetArea.width, this.m_lastTargetArea.height), this.m_lastTargetArea.x, this.m_lastTargetArea.y, null);
                int[] selection = this.getSelection();
                if (selection.length > 0) {
                    Rectangle renderedChartBounds = this.getRenderedChartBounds();
                    g.setXORMode(Color.black);
                    int selStart = selection[0];
                    int selWidth = selection[1] - selection[0];
                    if (selWidth < 0) {
                        selWidth = -selWidth;
                        selStart -= selWidth;
                    }
                    g.fillRect(selStart + renderedChartBounds.x, renderedChartBounds.y, selWidth, renderedChartBounds.height);
                }
            }
        } else {
            super.paint(g);
        }
        if (SHOW_RENDERING_TIME) {
            if (this.m_debugFont == null) {
                this.m_debugFont = g.getFont().deriveFont(12.0f);
            }
            g.setFont(this.m_debugFont);
            int fontHeight = g.getFontMetrics().getAscent() + g.getFontMetrics().getDescent();
            String str = "Time: " + (System.currentTimeMillis() - start) + " ms ";
            this.drawDropShadowString(g, fontHeight, str);
        }
    }

    private void drawDropShadowString(Graphics g, int y, String str) {
        g.setColor(this.getForeground());
        g.drawString(str, 40, y);
        g.setColor(Color.RED);
        g.drawString(str, 39, y - 1);
    }

    public Image createPlotImage(int width, int height) {
        if (this.m_imageBuffer == null || width != this.m_lastImageRenderingArea.width || height != this.m_lastImageRenderingArea.height) {
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            this.m_imageBuffer = gc != null ? gc.createCompatibleImage(width, height, 2) : new BufferedImage(width, height, 2);
            this.m_lastImageRenderingArea.width = width;
            this.m_lastImageRenderingArea.height = height;
        }
        this.m_chart.render((Graphics2D)this.m_imageBuffer.getGraphics(), this.m_lastImageRenderingArea);
        return this.m_imageBuffer;
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public void onChartChanged(ChartChangeEvent e) {
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        if (bg == null) {
            bg = FontAndColors.getDefaultBackground();
        }
        super.setBackground(bg);
        this.getChart().setBackground(bg);
    }

    @Override
    public void setForeground(Color fg) {
        if (fg == null) {
            fg = FontAndColors.getDefaultForeground();
        }
        this.getChart().setForeground(fg);
    }

    public void setSelection(int startX, int endX) {
        Rectangle renderedChartBounds = this.getRenderedChartBounds();
        if (renderedChartBounds == null || renderedChartBounds.height < 2) {
            return;
        }
        if (startX >= 0 && startX <= renderedChartBounds.width && endX >= 0 && endX <= renderedChartBounds.width) {
            if (startX < endX) {
                this.m_selectionStartX = startX;
                this.m_selectionEndX = endX;
            } else {
                this.m_selectionStartX = endX;
                this.m_selectionEndX = startX;
            }
        } else {
            throw new IllegalArgumentException("Coordinates must be inside selectable area.");
        }
    }

    public int[] getSelection() {
        if (this.m_selectionStartX >= 0) {
            return new int[]{this.m_selectionStartX, this.m_selectionEndX};
        }
        return EMPTY_INT_ARRAY;
    }

    public double[] getSelectionPercentages() {
        int[] pixelSelection = this.getSelection();
        if (pixelSelection.length > 0) {
            Rectangle renderedChartBounds = this.getRenderedChartBounds();
            return new double[]{(double)pixelSelection[0] / (double)renderedChartBounds.width, (double)pixelSelection[1] / (double)renderedChartBounds.width};
        }
        return EMPTY_DOUBLE_ARRAY;
    }

    public void clearSelection() {
        this.m_selectionStartX = -1;
        this.m_selectionEndX = -1;
    }

    public Rectangle getRenderedChartBounds() {
        return this.m_chart.getPlotRenderer().getRenderedBounds();
    }
}

