/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.openjdk.jmc.greychart.AbstractSeriesRenderer;
import org.openjdk.jmc.greychart.GreyChartPanel;
import org.openjdk.jmc.greychart.IndexRenderer;
import org.openjdk.jmc.greychart.SeriesGreyChart;
import org.openjdk.jmc.greychart.util.ChartRenderingToolkit;

public class DefaultHorizontalIndexRenderer
extends AbstractSeriesRenderer
implements IndexRenderer {
    public static final float DEFAULT_RELATIVE_HEIGHT = 0.07f;
    private Image m_indexImage;
    private int m_maxStringLength = 9;
    private float m_relativeWidth = 0.07f;

    public DefaultHorizontalIndexRenderer(SeriesGreyChart owner) {
        super(owner);
    }

    @Override
    public void render(Graphics2D ctx, Rectangle rect, Rectangle chartRect) {
        if (rect.width <= 0 || rect.height <= 0) {
            this.clearRenderedBounds();
            return;
        }
        AffineTransform trans = ctx.getTransform();
        ctx.translate(rect.x, rect.y);
        if (!rect.equals(this.getRenderedBounds())) {
            Font font = null;
            font = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFont().deriveFont(this.getMinimumFontSize()) : ctx.getFont();
            String[] names = new String[]{};
            int boxSize = Math.max(2, ctx.getFontMetrics(font).getAscent() + ctx.getFontMetrics(font).getDescent());
            int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
            int totalWidth = 0;
            FontMetrics fm = ctx.getFontMetrics();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                totalWidth += (int)(fm.getStringBounds(name, ctx).getWidth() + (double)(padding * 2) + (double)boxSize);
                ++n2;
            }
            BufferedImage img = new BufferedImage(totalWidth, rect.height, 5);
            Graphics2D gctx = (Graphics2D)img.getGraphics();
            gctx.setFont(font);
            gctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
            this.m_indexImage = img;
            this.setRenderedBounds(rect);
        }
        int x = (rect.width - this.m_indexImage.getWidth(null)) / 2;
        ctx.drawImage(this.m_indexImage, x, 0, this.m_indexImage.getWidth(null), this.m_indexImage.getHeight(null), null);
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, 0, 0, rect.width, rect.height, Color.GREEN);
        }
        ctx.setTransform(trans);
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        FontMetrics fm = null;
        fm = (float)ctx.getFont().getSize() < this.getMinimumFontSize() ? ctx.getFontMetrics(ctx.getFont().deriveFont(this.getMinimumFontSize())) : ctx.getFontMetrics();
        int boxSize = Math.max(2, fm.getAscent() + fm.getDescent());
        int padding = Math.max(1, Math.round((float)boxSize * 0.3f));
        return new Dimension(totalDrawingArea.width, boxSize + padding * 2);
    }

    @Override
    public void setMaxStringLength(int stringLength) {
        if (stringLength <= 2) {
            throw new IllegalArgumentException("The max string length must be larger than 2!");
        }
        this.m_maxStringLength = stringLength;
    }

    @Override
    public int getMaxStringLength() {
        return this.m_maxStringLength;
    }

    public float getRelativeWidth() {
        return this.m_relativeWidth;
    }

    public void setRelativeWidth(float relativeWidth) {
        this.m_relativeWidth = relativeWidth;
    }
}

