/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.HashMap;
import org.openjdk.jmc.greychart.AbstractSeriesPlotRenderer;
import org.openjdk.jmc.greychart.FontAndColors;
import org.openjdk.jmc.greychart.SeriesGreyChart;
import org.openjdk.jmc.greychart.SeriesMetadataProvider;
import org.openjdk.jmc.greychart.data.DataSeriesProvider;
import org.openjdk.jmc.ui.common.xydata.DataSeries;

public class DefaultPieRenderer
extends AbstractSeriesPlotRenderer {
    public static final Color DEFAULT_TEXT_COLOR = Color.DARK_GRAY;
    public static final Color DEFAULT_LINE_COLOR = Color.DARK_GRAY;
    public static final String DEFAULT_TEXT_FORMAT_STRING = "{0} ({1,number,##0.0%})";
    private final Dimension m_preferred = new Dimension(100, 100);
    private boolean m_labelsEnabled = true;
    private Color m_textColor = DEFAULT_TEXT_COLOR;
    private Color m_lineColor = DEFAULT_LINE_COLOR;
    private String m_messageFormat = "{0} ({1,number,##0.0%})";

    public DefaultPieRenderer(SeriesGreyChart owner) {
        super(owner);
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        this.m_preferred.height = (int)((double)totalDrawingArea.height * 0.6);
        this.m_preferred.width = totalDrawingArea.width;
        return this.m_preferred;
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle fullGraphArea) {
        this.setRenderedBounds(targetArea);
        DataSeriesProvider provider = this.getOwner().getDataProvider();
        DataSeries<T>[] dataSeries = provider.getDataSeries();
        double sum = 0.0;
        HashMap values = new HashMap();
        HashMap coordinates = new HashMap();
        int size = (int)Math.round((double)Math.min(targetArea.width, targetArea.height) * 0.9);
        int x = targetArea.x + (targetArea.width - size) / 2;
        int y = targetArea.y + (targetArea.height - size) / 2;
        DataSeries<T>[] dataSeriesArray = dataSeries;
        int n = dataSeries.length;
        int n2 = 0;
        while (n2 < n) {
            DataSeries s = dataSeriesArray[n2];
            Number val = (Number)s.createIterator(Long.MIN_VALUE, Long.MAX_VALUE).next();
            if (val != null) {
                values.put(s, val);
                sum += val.doubleValue();
            }
            ++n2;
        }
        double arcPos = 90.0;
        SeriesMetadataProvider smdp = this.getOwner().getMetadataProvider();
        DataSeries<T>[] dataSeriesArray2 = dataSeries;
        int n3 = dataSeries.length;
        int val = 0;
        while (val < n3) {
            DataSeries s = dataSeriesArray2[val];
            double arc = ((Number)values.get(s)).doubleValue() / sum * 360.0;
            ctx.setPaint(smdp.getTopColor(s));
            ctx.fillArc(x, y, size, size, (int)arcPos, (int)(-arc));
            ctx.setPaint(smdp.getLineColor(s));
            ctx.drawArc(x, y, size, size, (int)arcPos, (int)(-arc));
            if (this.isLabelsEnabled()) {
                double bisectris = Math.toRadians((2.0 * arcPos - arc) / 2.0);
                double distance = (double)size / 2.0 * 0.6;
                int coordX = (int)Math.round(targetArea.getCenterX() + Math.cos(bisectris) * distance);
                int coordY = (int)Math.round(targetArea.getCenterY() - Math.sin(bisectris) * distance);
                coordinates.put(s, new Point(coordX, coordY));
            }
            arcPos -= arc;
            ++val;
        }
        if (this.isLabelsEnabled()) {
            int leftY;
            FontMetrics fm = ctx.getFontMetrics();
            int rightY = leftY = targetArea.y;
            int lastX = 0;
            ctx.setColor(FontAndColors.getDefaultForeground());
            DataSeries<T>[] dataSeriesArray3 = dataSeries;
            int n4 = dataSeries.length;
            int n5 = 0;
            while (n5 < n4) {
                DataSeries s = dataSeriesArray3[n5];
                Object[] arguments = new Object[]{"Series", ((Number)values.get(s)).doubleValue() / sum};
                String text = MessageFormat.format(this.getMessageFormat(), arguments);
                Rectangle2D b = fm.getStringBounds(text, ctx);
                Point coordinate = (Point)coordinates.get(s);
                if ((double)coordinate.x >= targetArea.getCenterX()) {
                    rightY = (int)((double)rightY + b.getHeight() * 2.0);
                    lastX = (int)((double)(targetArea.x + targetArea.width) - b.getWidth());
                    ctx.setColor(this.getLineColor());
                    ctx.drawLine(coordinate.x, coordinate.y, lastX - 5, rightY);
                    ctx.drawLine(lastX - 5, rightY, targetArea.x + targetArea.width, rightY);
                    ctx.setColor(this.getTextColor());
                    ctx.drawString(text, lastX, rightY);
                } else {
                    leftY = (int)((double)leftY + b.getHeight() * 2.0);
                    lastX = (int)b.getWidth() + targetArea.x;
                    ctx.setColor(this.getLineColor());
                    ctx.drawLine(coordinate.x, coordinate.y, lastX + 5, leftY);
                    ctx.drawLine(lastX + 5, leftY, targetArea.x, leftY);
                    ctx.setColor(this.getTextColor());
                    ctx.drawString(text, targetArea.x, leftY);
                }
                ++n5;
            }
        }
    }

    public boolean isLabelsEnabled() {
        return this.m_labelsEnabled;
    }

    public void setLabelsEnabled(boolean renderLabels) {
        this.m_labelsEnabled = renderLabels;
    }

    public Color getLineColor() {
        return this.m_lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.m_lineColor = lineColor;
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public void setTextColor(Color textColor) {
        this.m_textColor = textColor;
    }

    public String getMessageFormat() {
        return this.m_messageFormat;
    }

    public void setMessageFormat(String messageFormat) {
        this.m_messageFormat = messageFormat;
    }
}

