/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.openjdk.jmc.ui.Messages;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.MCActionContributionItem;

public class OrientationAction
extends Action {
    private final SashForm m_sashForm;
    private final int m_style;
    private Runnable layoutUpdater;

    private OrientationAction(IContributionManager contributionManager, SashForm sashForm, Runnable layoutUpdater, int style, String name) {
        super(name, 8);
        this.m_sashForm = sashForm;
        this.layoutUpdater = layoutUpdater;
        this.m_style = style;
    }

    public void run() {
        if (this.m_sashForm != null && !this.m_sashForm.isDisposed()) {
            this.m_sashForm.setOrientation(this.m_style);
        }
        this.layoutUpdater.run();
    }

    public static void installActions(Form form, SashForm sashForm) {
        OrientationAction.installActions((IContributionManager)form.getToolBarManager(), sashForm, () -> {});
        form.updateToolBar();
    }

    public static void installActions(IManagedForm managedForm, SashForm sashForm) {
        OrientationAction.installActions((IContributionManager)managedForm.getForm().getToolBarManager(), sashForm, () -> {
            if (managedForm != null && managedForm.getForm() != null && !managedForm.getForm().isDisposed()) {
                managedForm.getForm().reflow(true);
            }
        });
        managedForm.getForm().updateToolBar();
    }

    public static void installActions(IContributionManager contributionManager, SashForm sashForm, Runnable layoutUpdater) {
        boolean vertical = sashForm.getOrientation() == 512;
        OrientationAction h = new OrientationAction(contributionManager, sashForm, layoutUpdater, 256, Messages.MCMasterDetails_HORIZONTAL_LAYOUT);
        h.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("th_horizontal.gif"));
        h.setChecked(!vertical);
        h.setToolTipText(Messages.MCMasterDetails_HORIZONTAL_LAYOUT);
        h.setId("horizontal");
        OrientationAction v = new OrientationAction(contributionManager, sashForm, layoutUpdater, 512, Messages.MCMasterDetails_VERTICAL_LAYOUT);
        v.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("th_vertical.gif"));
        v.setChecked(vertical);
        v.setToolTipText(Messages.MCMasterDetails_VERTICAL_LAYOUT);
        v.setId("vertical");
        contributionManager.add((IContributionItem)new MCActionContributionItem((IAction)h));
        contributionManager.add((IContributionItem)new MCActionContributionItem((IAction)v));
    }
}

