/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.openjdk.jmc.common.unit.IFormatter;
import org.openjdk.jmc.common.unit.IIncrementalFormatter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.charts.IXYDisplayableSet;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;

public class AWTChartToolkit {
    private static final int PLOT_RADIUS = 2;
    private static final int TICK_LINE = 3;
    private static final int TICK_SIZE = 6;
    private static final Stroke DASH_STROKE = new BasicStroke(0.5f, 0, 0, 1.0f, new float[]{4.0f, 3.0f}, 0.0f);
    private static final BasicStroke EXTRAPOLATION_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 2.0f}, 1.0f);
    private static final Paint EXTRAPOLATION_PAINT;
    private static final int Y_AXIS_TOP_SPACE = 1;
    private static final int ARROW_SIZE = 3;
    private static boolean USE_AA;

    static {
        USE_AA = UIPlugin.getDefault().getPreferenceStore().getBoolean("graphics.antialiasing");
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D big = bi.createGraphics();
        big.setColor(new Color(255, 255, 255));
        big.fillRect(0, 0, 5, 5);
        big.setColor(new Color(200, 200, 200));
        big.drawLine(0, 0, 5, 5);
        Rectangle rect = new Rectangle(0, 0, 5, 5);
        EXTRAPOLATION_PAINT = new TexturePaint(bi, rect);
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(e -> {
            boolean bl = USE_AA = ((Boolean)e.getNewValue()).booleanValue();
        });
    }

    public static <T> IColorProvider<T> staticColor(final Color color) {
        return new IColorProvider<T>(){

            @Override
            public Color getColor(T o) {
                return color;
            }
        };
    }

    private static Object getAntiAliasingHint() {
        return USE_AA ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
    }

    private static void drawExtrapolation(Graphics2D ctx, int x1, int y1, int x2, int y2, boolean fill) {
        int x = Math.min(x1, x2);
        int y = Math.min(y1, y2);
        int width = Math.abs(x2 - x1);
        int heigth = Math.abs(y2 - y1);
        if (fill) {
            Paint p = ctx.getPaint();
            ctx.setPaint(EXTRAPOLATION_PAINT);
            ctx.fillRect(x, y, width, heigth);
            ctx.setPaint(p);
        }
        Stroke oldStroke = ctx.getStroke();
        ctx.setStroke(EXTRAPOLATION_STROKE);
        ctx.drawLine(x, y + heigth, x + width, y + heigth);
        ctx.setStroke(oldStroke);
    }

    public static void drawPlot(Graphics2D ctx, IXYDisplayableSet<?, ?> points, int height, boolean fill) {
        Object oldAntiAliasing = ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AWTChartToolkit.getAntiAliasingHint());
        int diameter = 4;
        int i = 0;
        while (i < points.getSize()) {
            double yCoord = points.getPixelY(i);
            if (!Double.isNaN(yCoord)) {
                int x = (int)points.getPixelX(i) - 2;
                int y = height - 1 - (int)yCoord - 2;
                if (fill) {
                    ctx.fillOval(x, y, diameter + 1, diameter + 1);
                } else {
                    ctx.drawOval(x, y, diameter, diameter);
                }
            }
            ++i;
        }
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
    }

    public static void drawLineChart(Graphics2D ctx, IXYDisplayableSet<?, ?> points, int width, int height, boolean fill) {
        Object oldAntiAliasing = ctx.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AWTChartToolkit.getAntiAliasingHint());
        AffineTransform oldTransform = ctx.getTransform();
        ctx.scale(1.0, -1.0);
        ctx.translate(0, 1 - height);
        Polygon p = AWTChartToolkit.getLineChart(points);
        int lastPoint = p.npoints - 1;
        if (p.xpoints[0] > 0) {
            AWTChartToolkit.drawExtrapolation(ctx, Math.min(p.xpoints[0], width), p.ypoints[0], 0, 0, fill);
        }
        if (p.xpoints[lastPoint] < width) {
            AWTChartToolkit.drawExtrapolation(ctx, Math.max(p.xpoints[lastPoint], 0), p.ypoints[lastPoint], width, 0, fill);
        }
        if (fill) {
            p.ypoints[0] = 0;
            p.ypoints[lastPoint] = 0;
            ctx.fillPolygon(p);
            ctx.setPaint(Color.BLACK);
            ctx.drawPolygon(p);
        } else {
            ctx.drawPolyline(p.xpoints, p.ypoints, p.npoints);
        }
        ctx.setTransform(oldTransform);
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
    }

    private static Polygon getLineChart(IXYDisplayableSet<?, ?> points) {
        int maxCoordinates = points.getSize() + 2;
        int[] xs = new int[maxCoordinates];
        int[] ys = new int[maxCoordinates];
        int index = 1;
        int i = 0;
        while (i < points.getSize()) {
            double yCoord = points.getPixelY(i);
            if (!Double.isNaN(yCoord)) {
                xs[index] = (int)points.getPixelX(i);
                ys[index] = (int)yCoord;
                ++index;
            }
            ++i;
        }
        xs[0] = xs[1];
        ys[0] = ys[1];
        xs[index] = xs[index - 1];
        ys[index] = ys[index - 1];
        return new Polygon(xs, ys, index > 1 ? ++index : 0);
    }

    private static Polygon getRightAngleChart(IXYDisplayableSet<?, ?> points, int width) {
        int maxCoordinates = points.getSize() * 2 + 2;
        int[] xs = new int[maxCoordinates];
        int[] ys = new int[maxCoordinates];
        int index = 0;
        int currentY = 0;
        int i = 0;
        while (i < points.getSize()) {
            int nextY;
            double yCoord = points.getPixelY(i);
            int n = nextY = Double.isNaN(yCoord) ? 0 : (int)yCoord;
            if (nextY != currentY) {
                int x;
                xs[index] = x = (int)points.getPixelX(i);
                ys[index] = currentY;
                xs[++index] = x;
                ys[index] = nextY;
                ++index;
                currentY = nextY;
            }
            ++i;
        }
        if (index > 0) {
            xs[index] = width - 1;
            ys[index] = currentY;
            xs[++index] = width - 1;
            ys[index] = 0;
            ++index;
        }
        return new Polygon(xs, ys, index);
    }

    public static void drawRightAngleChart(Graphics2D ctx, IXYDisplayableSet<?, ?> points, int width, int height) {
        Polygon p = AWTChartToolkit.getRightAngleChart(points, width);
        AffineTransform oldTransform = ctx.getTransform();
        ctx.scale(1.0, -1.0);
        ctx.translate(0, -height);
        ctx.fillPolygon(p);
        ctx.drawPolyline(p.xpoints, p.ypoints, p.npoints);
        ctx.setTransform(oldTransform);
    }

    public static <T> void drawBarChart(Graphics2D ctx, IXYDisplayableSet<T[], ?> points, IColorProvider<? super T> cp, int width, int height) {
        AffineTransform oldTransform = ctx.getTransform();
        ctx.scale(1.0, -1.0);
        ctx.translate(0, -height);
        Paint paint = ctx.getPaint();
        T[] payload = points.getPayload();
        int i = 0;
        while (i < points.getSize()) {
            int barHeight = (int)points.getPixelY(i);
            int x1 = (int)points.getPixelX(i);
            int x2 = (int)points.getPixelX(i + 1);
            int barWidth = x2 - x1;
            if (barWidth > 10) {
                barWidth -= 4;
                x1 += 2;
            }
            ctx.setPaint(cp == null ? paint : cp.getColor(payload == null ? null : (Object)payload[i]));
            ctx.fillRect(x1, 0, barWidth, barHeight);
            ctx.setPaint(Color.GRAY);
            ctx.drawRect(x1, 0, barWidth, barHeight);
            ++i;
        }
        ctx.setTransform(oldTransform);
    }

    public static void drawAxis(Graphics2D ctx, SubdividedQuantityRange range, int axisPos, boolean labelAhead, int labelLimit, boolean vertical) {
        AWTChartToolkit.drawAxis(ctx, range, axisPos, labelAhead, labelLimit, vertical, 0);
    }

    public static void drawAxis(Graphics2D ctx, SubdividedQuantityRange range, int axisPos, boolean labelAhead, int labelLimit, boolean vertical, int xOffset) {
        IIncrementalFormatter changeFormatter;
        int labelSpacing;
        int labelYPos;
        int axisSize = range.getPixelExtent();
        FontMetrics fm = ctx.getFontMetrics();
        int textAscent = fm.getAscent();
        int textYadjust = textAscent / 2;
        int n = labelYPos = labelAhead ? axisPos - 6 : axisPos + 6 + textAscent;
        if (vertical) {
            ctx.drawLine(axisPos, 1, axisPos, axisSize - 1);
            AWTChartToolkit.drawUpArrow(ctx, axisPos, 1, Math.min(3, axisSize - 2));
            labelSpacing = fm.getHeight() - textAscent;
        } else {
            ctx.drawLine(0 + xOffset, axisPos, axisSize + xOffset, axisPos);
            labelSpacing = fm.charWidth(' ') * 2;
        }
        IRange firstBucket = QuantityRange.createWithEnd((IQuantity)range.getSubdivider(0), (IQuantity)range.getSubdivider(1));
        IQuantity lastShownTick = null;
        IFormatter formatter = range.getStart().getType().getFormatterResolving(firstBucket);
        if (formatter instanceof IIncrementalFormatter) {
            changeFormatter = (IIncrementalFormatter)formatter;
            if (!vertical && labelLimit < 0) {
                lastShownTick = range.getSubdivider(0);
                if (lastShownTick.compareTo((Object)range.getStart()) < 0) {
                    lastShownTick = range.getSubdivider(1);
                }
                String label = changeFormatter.formatContext(lastShownTick);
                int labelWidth = fm.stringWidth(label);
                ctx.drawString(label, labelLimit, labelYPos);
                labelLimit += labelWidth + labelSpacing;
            }
        } else {
            changeFormatter = null;
        }
        int numTicks = range.getNumSubdividers();
        int i = 0;
        while (i < numTicks) {
            int tickPos = (int)range.getSubdividerPixel(i);
            if (tickPos >= axisSize) break;
            if (tickPos >= 0) {
                String label;
                IQuantity currentTick = range.getSubdivider(i);
                if (vertical) {
                    ctx.drawLine(axisPos - 3, axisSize - 1 - tickPos, axisPos + 3, axisSize - 1 - tickPos);
                    if (tickPos + textYadjust >= axisSize) break;
                    if (tickPos - textYadjust >= labelLimit) {
                        label = formatter.format((Object)currentTick);
                        int labelXPos = labelAhead ? axisPos - 6 - fm.stringWidth(label) : axisPos + 6;
                        ctx.drawString(label, labelXPos, axisSize - 1 - tickPos + textYadjust);
                        labelLimit = tickPos + textYadjust + labelSpacing;
                    }
                } else {
                    label = changeFormatter != null ? changeFormatter.formatAdjacent(lastShownTick, range.getSubdivider(i)) : formatter.format((Object)currentTick);
                    ctx.drawLine(tickPos + xOffset, axisPos - 3, tickPos + xOffset, axisPos + 3);
                    int textXadjust = fm.stringWidth(label) / 2;
                    if (tickPos >= axisSize) break;
                    if (tickPos - textXadjust >= labelLimit) {
                        ctx.drawString(label, tickPos - textXadjust + xOffset, labelYPos);
                        labelLimit = tickPos + textXadjust + labelSpacing;
                        lastShownTick = currentTick;
                    }
                }
            }
            ++i;
        }
    }

    private static void drawUpArrow(Graphics2D ctx, int axisX, int axisYTop, int size) {
        int yArrow = axisYTop + size;
        ctx.drawLine(axisX - size, yArrow, axisX, axisYTop);
        ctx.drawLine(axisX + size, yArrow, axisX, axisYTop);
    }

    public static void drawGrid(Graphics2D ctx, SubdividedQuantityRange range, int gridSize, boolean verticalAxis) {
        int axisSize = range.getPixelExtent();
        Stroke oldStroke = ctx.getStroke();
        ctx.setStroke(DASH_STROKE);
        int numTicks = range.getNumSubdividers();
        int i = 0;
        while (i < numTicks) {
            int pos = (int)range.getSubdividerPixel(i);
            if (pos >= axisSize) break;
            if (pos >= 0) {
                if (verticalAxis) {
                    ctx.drawLine(0, axisSize - 1 - pos, gridSize - 1, axisSize - 1 - pos);
                } else {
                    ctx.drawLine(pos, 0, pos, gridSize - 1);
                }
            }
            ++i;
        }
        ctx.setStroke(oldStroke);
    }

    public static void drawRanges(Graphics2D g2, IXYDisplayableSet<?, ?> points, int height, boolean fill) {
        int width = points.getWidth();
        Shape oldClip = g2.getClip();
        g2.setClip(new Rectangle(width, height));
        int n = 0;
        while (n < points.getSize()) {
            int end;
            double x1 = points.getPixelX(n);
            double x2 = points.getPixelY(n);
            int start = x1 < 0.0 ? -1 : (int)x1;
            int n2 = end = x2 > (double)width ? width + 1 : (int)x2;
            if (end > 0 && start < width) {
                if (fill) {
                    g2.fillRect(start, 0, end - start, height);
                } else {
                    g2.drawRect(start, 0, end - start, height - 1);
                }
            }
            ++n;
        }
        g2.setClip(oldClip);
    }

    public static <T> void drawSpan(Graphics2D g2, IXYDisplayableSet<T[], ?> points, int height, boolean markBoundaries, IColorProvider<? super T> cp) {
        int width = points.getWidth();
        int[] buffer = new int[width];
        int[] secondBuffer = markBoundaries ? new int[width] : buffer;
        T[] payload = points.getPayload();
        int n = 0;
        while (n < points.getSize()) {
            T item = payload[n];
            if (item != null) {
                int x1 = (int)points.getPixelX(n);
                int x2 = (int)points.getPixelY(n);
                int start = Math.max(0, Math.min(x1, x2));
                int end = Math.min(width - 1, Math.max(x1, x2));
                int color = cp.getColor(item).getRGB();
                if (markBoundaries && end - start > 2) {
                    double damp = 0.85 - 3.0 / (double)(end - start);
                    int shade = (int)(50.0 * damp * damp);
                    int i = start;
                    while (i <= end) {
                        if (shade > 0) {
                            buffer[i] = AWTChartToolkit.shade(color, shade);
                            shade = (int)((double)shade * damp);
                        } else {
                            buffer[i] = color;
                        }
                        secondBuffer[i] = i == start ? Color.BLACK.getRGB() : buffer[i];
                        ++i;
                    }
                } else {
                    int i = start;
                    while (i <= end) {
                        secondBuffer[i] = buffer[i] = color;
                        ++i;
                    }
                }
            }
            ++n;
        }
        BufferedImage image = new BufferedImage(width, 1, 2);
        BufferedImage cpImage = markBoundaries ? new BufferedImage(width, 1, 2) : image;
        image.setRGB(0, 0, width, 1, buffer, 0, width);
        cpImage.setRGB(0, 0, width, 1, secondBuffer, 0, width);
        int n2 = 0;
        while (n2 < height) {
            if ((n2 & 2) == 0) {
                g2.drawImage(cpImage, 0, n2, null, null);
            } else {
                g2.drawImage(image, 0, n2, null, null);
            }
            ++n2;
        }
    }

    private static int shade(int color, int shade) {
        return 0xFF000000 & color | AWTChartToolkit.shift(color, shade, 16) | AWTChartToolkit.shift(color, shade, 8) | AWTChartToolkit.shift(color, shade, 0);
    }

    private static int shift(int color, int shade, int componentOffset) {
        int comp = color >>> componentOffset & 0xFF;
        return (comp > shade ? comp - shade : 0) << componentOffset;
    }

    public static interface IColorProvider<T> {
        public Color getColor(T var1);
    }
}

