/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.charts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.misc.ChartButtonGroup;
import org.openjdk.jmc.ui.misc.ChartControlBar;
import org.openjdk.jmc.ui.misc.PatternFly;
import org.openjdk.jmc.ui.misc.TimelineCanvas;

public class XYChart {
    private static final String ELLIPSIS = "...";
    private static final Color SELECTION_COLOR = new Color(255, 255, 255, 220);
    private static final Color RANGE_INDICATION_COLOR = new Color(255, 60, 20);
    private static final int BASE_ZOOM_LEVEL = 100;
    private static final int RANGE_INDICATOR_HEIGHT = 7;
    private final IQuantity start;
    private final IQuantity end;
    private IQuantity rangeDuration;
    private IXDataRenderer rendererRoot;
    private IRenderedRow rendererResult;
    private final int xOffset;
    private int yOffset = 35;
    private final int bucketWidth;
    private IQuantity currentStart;
    private IQuantity currentEnd;
    private final Set<Object> selectedRows = new HashSet<Object>();
    private int axisWidth;
    private int rowColorCounter;
    private IQuantity selectionStart;
    private IQuantity selectionEnd;
    private SubdividedQuantityRange xBucketRange;
    private SubdividedQuantityRange xTickRange;
    private static final double ZOOM_PAN_FACTOR = 0.05;
    private static final int ZOOM_PAN_MODIFIER = 2;
    private double zoomPanPower = 0.025;
    private double currentZoom;
    private int zoomSteps;
    private ChartButtonGroup buttonGroup;
    private ChartControlBar controlBar;
    private Stack<Integer> modifiedSteps;
    private TimelineCanvas timelineCanvas;
    private int longestCharWidth = 0;
    private boolean isZoomCalculated;
    private boolean isZoomPanDrag;
    private List<Consumer<IRange<IQuantity>>> rangeListeners = new ArrayList<Consumer<IRange<IQuantity>>>();

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot);
    }

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot, int xOffset) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot, xOffset);
    }

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot, int xOffset, Integer yOffset, TimelineCanvas timelineCanvas, ChartControlBar controlBar, ChartButtonGroup buttonGroup) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot, xOffset);
        this.yOffset = yOffset;
        this.timelineCanvas = timelineCanvas;
        this.controlBar = controlBar;
        this.buttonGroup = buttonGroup;
        this.rangeDuration = (IQuantity)range.getExtent();
        this.currentZoom = 100.0;
        this.isZoomCalculated = false;
    }

    public XYChart(IRange<IQuantity> range, IXDataRenderer rendererRoot, int xOffset, int bucketWidth) {
        this((IQuantity)range.getStart(), (IQuantity)range.getEnd(), rendererRoot, xOffset, bucketWidth);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot) {
        this(start, end, rendererRoot, 60);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot, int xOffset) {
        this(start, end, rendererRoot, xOffset, 25);
    }

    public XYChart(IQuantity start, IQuantity end, IXDataRenderer rendererRoot, int xOffset, int bucketWidth) {
        this.rendererRoot = rendererRoot;
        assert (start.compareTo((Object)end) < 0);
        this.currentStart = start;
        this.start = start;
        this.currentEnd = end;
        this.end = end;
        this.xOffset = xOffset;
        this.bucketWidth = bucketWidth;
    }

    public void setRendererRoot(IXDataRenderer rendererRoot) {
        this.clearSelection();
        this.rendererRoot = rendererRoot;
        this.longestCharWidth = 0;
    }

    public IXDataRenderer getRendererRoot() {
        return this.rendererRoot;
    }

    public Object[] getSelectedRows() {
        return this.selectedRows.toArray(new Object[this.selectedRows.size()]);
    }

    public IQuantity getSelectionStart() {
        return this.selectionStart;
    }

    public IQuantity getSelectionEnd() {
        return this.selectionEnd;
    }

    public IRange<IQuantity> getSelectionRange() {
        return this.selectionStart != null && this.selectionEnd != null ? QuantityRange.createWithEnd((IQuantity)this.selectionStart, (IQuantity)this.selectionEnd) : null;
    }

    public void renderChart(Graphics2D context, int width, int height) {
        if (width > this.xOffset && height > this.yOffset) {
            this.axisWidth = width - this.xOffset;
            this.xBucketRange = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, this.bucketWidth);
            this.xTickRange = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, 100);
            AffineTransform oldTransform = context.getTransform();
            context.translate(this.xOffset, 0);
            this.doRenderChart(context, height - this.yOffset);
            context.setTransform(oldTransform);
        }
    }

    public void renderTextCanvasText(Graphics2D context, int width, int height) {
        AffineTransform oldTransform = context.getTransform();
        this.axisWidth = width - this.xOffset;
        this.doRenderTextCanvasText(context, height);
        context.setTransform(oldTransform);
    }

    public void renderText(Graphics2D context, int width, int height) {
        if (width > this.xOffset && height > this.yOffset) {
            this.axisWidth = this.xOffset;
            AffineTransform oldTransform = context.getTransform();
            this.doRenderText(context);
            context.setTransform(oldTransform);
            this.axisWidth = width - this.xOffset;
        }
    }

    private void renderRangeIndication(Graphics2D context, int rangeIndicatorY) {
        SubdividedQuantityRange fullRangeAxis = new SubdividedQuantityRange(this.start, this.end, this.axisWidth, 25);
        int x1 = (int)fullRangeAxis.getPixel(this.currentStart);
        int x2 = (int)Math.ceil(fullRangeAxis.getPixel(this.currentEnd));
        if (this.timelineCanvas != null) {
            this.timelineCanvas.renderRangeIndicator(x1, x2);
            this.updateZoomPanIndicator();
        } else {
            context.setPaint(RANGE_INDICATION_COLOR);
            context.fillRect(x1, rangeIndicatorY, x2 - x1, 7);
            context.setPaint(Color.DARK_GRAY);
            context.drawRect(0, rangeIndicatorY, this.axisWidth - 1, 7);
        }
    }

    public void updateZoomPanIndicator() {
        if (this.buttonGroup != null) {
            this.buttonGroup.updateZoomPanIndicator();
        }
    }

    private IRenderedRow getRendererResult(Graphics2D context, int axisHeight) {
        if (this.xBucketRange == null) {
            this.xBucketRange = this.getXBucketRange();
        }
        return this.rendererRoot.render(context, this.xBucketRange, axisHeight);
    }

    private SubdividedQuantityRange getXBucketRange() {
        return new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, this.bucketWidth);
    }

    private void doRenderChart(Graphics2D context, int axisHeight) {
        this.rowColorCounter = 0;
        context.setPaint(Color.LIGHT_GRAY);
        AWTChartToolkit.drawGrid(context, this.xTickRange, axisHeight, false);
        context.setPaint(Color.BLACK);
        if (this.timelineCanvas != null) {
            this.timelineCanvas.setXTickRange(this.xTickRange);
        } else {
            AWTChartToolkit.drawAxis(context, this.xTickRange, axisHeight - 1, false, 1 - this.xOffset, false);
        }
        this.rendererResult = this.getRendererResult(context, axisHeight);
        AffineTransform oldTransform = context.getTransform();
        context.setTransform(oldTransform);
        if (!this.selectedRows.isEmpty()) {
            this.renderSelectionChart(context, this.rendererResult);
            context.setTransform(oldTransform);
        }
        context.setPaint(new Color(0, 0, 0, 64));
        context.drawLine(0, axisHeight - 1, this.axisWidth - 1, axisHeight - 1);
        this.renderRangeIndication(context, axisHeight + 25);
    }

    private void doRenderText(Graphics2D context) {
        AffineTransform oldTransform = context.getTransform();
        this.rowColorCounter = -1;
        this.renderText(context, this.rendererResult);
        context.setTransform(oldTransform);
    }

    private void doRenderTextCanvasText(Graphics2D context, int height) {
        if (this.rendererResult == null) {
            this.rendererResult = this.getRendererResult(context, height - this.yOffset);
        }
        AffineTransform oldTransform = context.getTransform();
        this.rowColorCounter = 0;
        this.renderText(context, this.rendererResult);
        context.setTransform(oldTransform);
        if (!this.selectedRows.isEmpty()) {
            this.renderSelectionText(context, this.rendererResult);
            context.setTransform(oldTransform);
        }
    }

    private void renderSelectionText(Graphics2D context, IRenderedRow row) {
        if (this.selectedRows.contains(row.getPayload())) {
            if (row.getHeight() != this.rendererResult.getHeight()) {
                Color highlight = new Color(0, 206, 209, 20);
                context.setColor(highlight);
                context.fillRect(0, 0, this.axisWidth, row.getHeight());
            } else {
                this.selectedRows.clear();
            }
        } else {
            List<IRenderedRow> subdivision = row.getNestedRows();
            if (subdivision.isEmpty()) {
                XYChart.dimRect(context, 0, this.axisWidth, row.getHeight());
            } else {
                for (IRenderedRow nestedRow : row.getNestedRows()) {
                    this.renderSelectionText(context, nestedRow);
                }
                return;
            }
        }
        context.translate(0, row.getHeight());
    }

    private void renderSelectionChart(Graphics2D context, IRenderedRow row) {
        if (this.selectedRows.contains(row.getPayload())) {
            this.renderSelection(context, this.xBucketRange, row.getHeight());
        } else {
            List<IRenderedRow> subdivision = row.getNestedRows();
            if (subdivision.isEmpty()) {
                XYChart.dimRect(context, 0, this.axisWidth, row.getHeight());
            } else {
                for (IRenderedRow nestedRow : row.getNestedRows()) {
                    this.renderSelectionChart(context, nestedRow);
                }
                return;
            }
        }
        context.translate(0, row.getHeight());
    }

    private void paintRowBackground(Graphics2D context, int height) {
        if (this.rowColorCounter >= 0) {
            if (this.rowColorCounter % 2 == 0) {
                context.setColor(PatternFly.Palette.PF_BLACK_100.getAWTColor());
            } else {
                context.setColor(PatternFly.Palette.PF_BLACK_200.getAWTColor());
            }
            context.fillRect(0, 0, this.axisWidth, height);
            ++this.rowColorCounter;
        }
    }

    private void renderText(Graphics2D context, IRenderedRow row) {
        String text = row.getName();
        int height = row.getHeight();
        if (height >= context.getFontMetrics().getHeight()) {
            if (text != null) {
                this.paintRowBackground(context, row.getHeight());
                context.setColor(Color.BLACK);
                context.drawLine(0, height - 1, this.axisWidth - 15, height - 1);
                int y = (height - context.getFontMetrics().getHeight()) / 2 + context.getFontMetrics().getAscent();
                int charsWidth = context.getFontMetrics().charsWidth(text.toCharArray(), 0, text.length());
                if (charsWidth > this.longestCharWidth) {
                    this.longestCharWidth = charsWidth;
                }
                if (this.xOffset > 0 && charsWidth > this.xOffset) {
                    float fitRatio = (float)this.xOffset / (float)(charsWidth + context.getFontMetrics().charsWidth(ELLIPSIS.toCharArray(), 0, ELLIPSIS.length()));
                    text = String.valueOf(text.substring(0, (int)((float)text.length() * fitRatio) - 1)) + ELLIPSIS;
                }
                context.drawString(text, 2, y);
            } else {
                List<IRenderedRow> subdivision = row.getNestedRows();
                if (!subdivision.isEmpty()) {
                    for (IRenderedRow nestedRow : row.getNestedRows()) {
                        this.renderText(context, nestedRow);
                    }
                    return;
                }
            }
        }
        context.translate(0, height);
    }

    public int getLongestCharWidth() {
        return this.longestCharWidth;
    }

    public boolean pan(int rightPercent) {
        if (this.rangeDuration != null) {
            return this.panRange(Integer.signum(rightPercent));
        }
        if (this.xBucketRange != null) {
            IQuantity oldStart = this.currentStart;
            IQuantity oldEnd = this.currentEnd;
            if (rightPercent > 0) {
                this.currentEnd = (IQuantity)QuantitiesToolkit.min((Comparable)this.xBucketRange.getQuantityAtPixel(this.axisWidth + this.axisWidth * rightPercent / 100), (Comparable)this.end);
                this.currentStart = (IQuantity)QuantitiesToolkit.max((Comparable)this.xBucketRange.getQuantityAtPixel(this.xBucketRange.getPixel(this.currentEnd) - (double)this.axisWidth), (Comparable)this.start);
            } else if (rightPercent < 0) {
                this.currentStart = (IQuantity)QuantitiesToolkit.max((Comparable)this.xBucketRange.getQuantityAtPixel(this.axisWidth * rightPercent / 100), (Comparable)this.start);
                this.currentEnd = (IQuantity)QuantitiesToolkit.min((Comparable)this.xBucketRange.getQuantityAtPixel(this.xBucketRange.getPixel(this.currentStart) + (double)this.axisWidth), (Comparable)this.end);
            }
            return this.currentStart.compareTo((Object)oldStart) != 0 || this.currentEnd.compareTo((Object)oldEnd) != 0;
        }
        return true;
    }

    public boolean panRange(int panDirection) {
        if (this.zoomSteps == 0 || panDirection == 0 || this.currentStart.compareTo((Object)this.start) == 0 && panDirection == -1 || this.currentEnd.compareTo((Object)this.end) == 0 && panDirection == 1) {
            return false;
        }
        IQuantity panDiff = this.rangeDuration.multiply((double)panDirection * this.zoomPanPower);
        IQuantity newStart = this.currentStart.in((IUnit)UnitLookup.EPOCH_NS).add(panDiff);
        IQuantity newEnd = this.currentEnd.in((IUnit)UnitLookup.EPOCH_NS).add(panDiff);
        if (newStart.compareTo((Object)this.start) < 0) {
            IQuantity diff = this.start.subtract(newStart);
            newStart = this.start;
            newEnd = newEnd.add(diff);
        } else if (newEnd.compareTo((Object)this.end) > 0) {
            IQuantity diff = newEnd.subtract(this.end);
            newStart = newStart.add(diff);
            newEnd = this.end;
        }
        this.currentStart = newStart;
        this.currentEnd = newEnd;
        this.controlBar.setStartTime(this.currentStart);
        this.controlBar.setEndTime(this.currentEnd);
        this.isZoomCalculated = true;
        return true;
    }

    public boolean zoom(int zoomInSteps) {
        if (this.rangeDuration != null) {
            return this.zoomRange(zoomInSteps);
        }
        return this.zoomXAxis(this.axisWidth / 2, zoomInSteps);
    }

    public boolean zoom(int x, int zoomInSteps) {
        return this.zoomXAxis(x - this.xOffset, zoomInSteps);
    }

    private boolean zoomXAxis(int x, int zoomInSteps) {
        if (this.xBucketRange == null) {
            return true;
        }
        if (x > 0 && x < this.axisWidth) {
            IQuantity oldStart = this.currentStart;
            IQuantity oldEnd = this.currentEnd;
            double zoomFactor = Math.atan(zoomInSteps) / Math.PI;
            int newStart = (int)(zoomFactor * (double)x);
            int newEnd = (int)((double)this.axisWidth * (1.0 - zoomFactor)) + newStart;
            SubdividedQuantityRange xAxis = new SubdividedQuantityRange(this.currentStart, this.currentEnd, this.axisWidth, 1);
            this.setVisibleRange(xAxis.getQuantityAtPixel(newStart), xAxis.getQuantityAtPixel(newEnd));
            return this.currentStart.compareTo((Object)oldStart) != 0 || this.currentEnd.compareTo((Object)oldEnd) != 0;
        }
        return false;
    }

    public boolean zoomToStep(int zoomToStep) {
        if (zoomToStep == 0) {
            this.resetTimeline();
            return true;
        }
        return this.zoomRange(zoomToStep - this.zoomSteps);
    }

    private boolean zoomRange(int steps) {
        if (steps == 0) {
            return false;
        }
        if (steps > 0) {
            this.zoomIn(steps);
        } else {
            this.zoomOut(steps);
        }
        return true;
    }

    private void zoomIn(int steps) {
        do {
            IQuantity newEnd;
            IQuantity zoomDiff = this.rangeDuration.multiply(this.zoomPanPower);
            IQuantity newStart = this.currentStart.in((IUnit)UnitLookup.EPOCH_NS).add(zoomDiff);
            if (newStart.compareTo((Object)(newEnd = this.currentEnd.in((IUnit)UnitLookup.EPOCH_NS).subtract(zoomDiff))) >= 0) {
                if (this.modifiedSteps == null) {
                    this.modifiedSteps = new Stack();
                }
                this.modifiedSteps.push(this.zoomSteps);
                this.zoomPanPower /= 2.0;
                zoomDiff = this.rangeDuration.multiply(this.zoomPanPower);
                newStart = this.currentStart.in((IUnit)UnitLookup.EPOCH_NS).add(zoomDiff);
                newEnd = this.currentEnd.in((IUnit)UnitLookup.EPOCH_NS).subtract(zoomDiff);
            }
            this.currentZoom += this.zoomPanPower * 2.0 * 100.0;
            this.isZoomCalculated = true;
            ++this.zoomSteps;
            this.setVisibleRange(newStart, newEnd);
        } while (--steps > 0);
    }

    private void zoomOut(int steps) {
        do {
            IQuantity diff;
            if (this.modifiedSteps != null && this.modifiedSteps.size() > 0 && this.modifiedSteps.peek() == this.zoomSteps) {
                this.modifiedSteps.pop();
                this.zoomPanPower *= 2.0;
            }
            IQuantity zoomDiff = this.rangeDuration.multiply(this.zoomPanPower);
            IQuantity newStart = this.currentStart.in((IUnit)UnitLookup.EPOCH_NS).subtract(zoomDiff);
            IQuantity newEnd = this.currentEnd.in((IUnit)UnitLookup.EPOCH_NS).add(zoomDiff);
            if (newStart.compareTo((Object)this.start) < 0) {
                diff = this.start.subtract(newStart);
                newStart = this.start;
                newEnd = newEnd.add(diff);
            } else if (newEnd.compareTo((Object)this.end) > 0) {
                diff = newEnd.subtract(this.end);
                newStart = newStart.subtract(diff);
                newEnd = this.end;
            }
            this.currentZoom -= this.zoomPanPower * 2.0 * 100.0;
            if (this.currentZoom < 100.0) {
                this.currentZoom = 100.0;
            }
            this.isZoomCalculated = true;
            --this.zoomSteps;
            this.setVisibleRange(newStart, newEnd);
        } while (++steps < 0);
    }

    public void resetZoomFactor() {
        this.zoomSteps = 0;
        this.zoomPanPower = 0.025;
        this.currentZoom = 100.0;
        this.modifiedSteps = new Stack();
    }

    public void resetTimeline() {
        this.resetZoomFactor();
        this.setVisibleRange(this.start, this.end);
    }

    private void selectionZoom(IQuantity newStart, IQuantity newEnd) {
        double percentage = this.calculateZoom(newStart, newEnd);
        this.zoomSteps = this.calculateZoomSteps(percentage);
        this.currentZoom = 100.0 + percentage * 100.0;
    }

    private double calculateZoom(IQuantity newStart, IQuantity newEnd) {
        IQuantity newRange = newEnd.in((IUnit)UnitLookup.EPOCH_NS).subtract(newStart.in((IUnit)UnitLookup.EPOCH_NS));
        return 1.0 - (double)newRange.longValue() / (double)this.rangeDuration.in((IUnit)UnitLookup.NANOSECOND).longValue();
    }

    private int calculateZoomSteps(double percentage) {
        int steps = (int)Math.floor(percentage / 0.05);
        double tempPercent = (double)steps * 0.05;
        if (tempPercent < percentage) {
            if (percentage > 0.95) {
                double factor = 0.05;
                do {
                    tempPercent += (factor /= 2.0);
                    if (this.modifiedSteps == null) {
                        this.modifiedSteps = new Stack();
                    }
                    if (this.modifiedSteps.size() == 0 || this.modifiedSteps.peek() < steps) {
                        this.modifiedSteps.push(steps);
                    }
                    ++steps;
                } while (tempPercent <= percentage);
                this.zoomPanPower = factor / 2.0;
            } else {
                ++steps;
            }
        }
        return steps;
    }

    public void setIsZoomPanDrag(boolean isZoomPanDrag) {
        this.isZoomPanDrag = isZoomPanDrag;
    }

    private boolean getIsZoomPanDrag() {
        return this.isZoomPanDrag;
    }

    public void setVisibleRange(IQuantity rangeStart, IQuantity rangeEnd) {
        if (this.rangeDuration != null && !this.isZoomCalculated && !this.getIsZoomPanDrag()) {
            this.selectionZoom(rangeStart, rangeEnd);
        }
        this.isZoomCalculated = false;
        if ((rangeStart = (IQuantity)QuantitiesToolkit.max((Comparable)rangeStart, (Comparable)this.start)).compareTo((Object)(rangeEnd = (IQuantity)QuantitiesToolkit.min((Comparable)rangeEnd, (Comparable)this.end))) < 0) {
            SubdividedQuantityRange testRange = new SubdividedQuantityRange(rangeStart, rangeEnd, 10000, 1);
            if (testRange.getQuantityAtPixel(0).compareTo((Object)testRange.getQuantityAtPixel(1)) < 0) {
                this.currentStart = rangeStart;
                this.currentEnd = rangeEnd;
            } else {
                this.currentStart = (IQuantity)QuantitiesToolkit.min((Comparable)rangeStart, (Comparable)this.currentStart);
                this.currentEnd = (IQuantity)QuantitiesToolkit.max((Comparable)rangeEnd, (Comparable)this.currentEnd);
            }
            if (this.controlBar != null) {
                this.controlBar.setStartTime(this.currentStart);
                this.controlBar.setEndTime(this.currentEnd);
            }
            this.rangeListeners.stream().forEach(l -> l.accept(this.getVisibleRange()));
        }
    }

    public void addVisibleRangeListener(Consumer<IRange<IQuantity>> rangeListener) {
        this.rangeListeners.add(rangeListener);
    }

    public IRange<IQuantity> getVisibleRange() {
        return this.currentStart != null && this.currentEnd != null ? QuantityRange.createWithEnd((IQuantity)this.currentStart, (IQuantity)this.currentEnd) : null;
    }

    public void clearVisibleRange() {
        this.currentStart = this.start;
        this.currentEnd = this.end;
    }

    public boolean select(int x1, int x2, int y1, int y2, boolean clear) {
        int xStart = Math.min(x1, x2);
        int xEnd = Math.max(x1, x2);
        if (this.xBucketRange != null && xEnd != xStart && xEnd - this.xOffset >= 0) {
            return this.select(this.xBucketRange.getQuantityAtPixel(Math.max(0, xStart - this.xOffset)), this.xBucketRange.getQuantityAtPixel(xEnd - this.xOffset), y1, y2, clear);
        }
        return this.select(null, null, y1, y2, clear);
    }

    public boolean select(IQuantity xStart, IQuantity xEnd, int y1, int y2, boolean clear) {
        if (xStart != null && xStart.compareTo((Object)this.start) < 0) {
            xStart = this.start;
        }
        if (xEnd != null && xEnd.compareTo((Object)this.end) > 0) {
            xEnd = this.end;
        }
        HashSet<Object> oldRows = null;
        if (QuantitiesToolkit.same((Comparable)this.selectionStart, (Comparable)xStart) && QuantitiesToolkit.same((Comparable)this.selectionEnd, (Comparable)xEnd)) {
            oldRows = new HashSet<Object>(this.selectedRows);
        }
        if (clear) {
            this.selectedRows.clear();
        }
        this.addSelectedRows(this.rendererResult, 0, Math.min(y1, y2), Math.max(y1, y2));
        this.selectionStart = xStart;
        this.selectionEnd = xEnd;
        return oldRows == null || !oldRows.equals(this.selectedRows);
    }

    public boolean clearSelection() {
        if (this.selectionStart == null && this.selectionEnd == null && this.selectedRows.isEmpty()) {
            return false;
        }
        this.selectedRows.clear();
        this.selectionEnd = null;
        this.selectionStart = null;
        return true;
    }

    private boolean addSelectedRows(IRenderedRow row, int yRowStart, int ySelectionStart, int ySelectionEnd) {
        List<IRenderedRow> subdivision = row.getNestedRows();
        if (subdivision.isEmpty()) {
            return this.addPayload(row);
        }
        boolean nestedHasPayload = false;
        for (IRenderedRow nestedRow : row.getNestedRows()) {
            int yRowEnd = yRowStart + nestedRow.getHeight();
            if (yRowStart > ySelectionEnd) break;
            if (yRowEnd > ySelectionStart) {
                nestedHasPayload |= this.addSelectedRows(nestedRow, yRowStart, ySelectionStart, ySelectionEnd);
            }
            yRowStart = yRowEnd;
        }
        return nestedHasPayload || this.addPayload(row);
    }

    private boolean addPayload(IRenderedRow row) {
        Object payload = row.getPayload();
        if (payload != null) {
            if (this.selectedRows.contains(payload)) {
                this.selectedRows.remove(payload);
            } else {
                this.selectedRows.add(payload);
            }
            return true;
        }
        return false;
    }

    private void renderSelection(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        int selFrom = 0;
        int selTo = this.axisWidth;
        if (this.selectionStart != null && this.selectionEnd != null) {
            selFrom = (int)xRange.getPixel(this.selectionStart);
            selTo = (int)xRange.getPixel(this.selectionEnd);
        }
        if (selFrom > 0) {
            XYChart.dimRect(context, 0, selFrom, height);
            context.setColor(Color.BLACK);
            context.drawLine(selFrom, 0, selFrom, height);
        }
        if (selTo < this.axisWidth) {
            XYChart.dimRect(context, selTo, this.axisWidth - selTo, height);
            context.setColor(Color.BLACK);
            context.drawLine(selTo, 0, selTo, height);
        }
    }

    private static void dimRect(Graphics2D context, int from, int width, int height) {
        context.setColor(SELECTION_COLOR);
        context.fillRect(from, 0, width, height);
    }

    public void infoAt(IChartInfoVisitor visitor, int x, int y) {
        if (this.rendererResult == null) {
            return;
        }
        int height = this.rendererResult.getHeight();
        if (y < height) {
            this.rendererResult.infoAt(visitor, x - this.xOffset, y, new Point(this.xOffset, 0));
        } else if ((x -= this.xOffset) >= 0) {
            int tickIndex = this.xTickRange.getClosestSubdividerAtPixel(x);
            double tickX = this.xTickRange.getSubdividerPixel(tickIndex);
            int bucketIndex = this.xBucketRange.getClosestSubdividerAtPixel(x);
            double bucketX = this.xBucketRange.getSubdividerPixel(bucketIndex);
            if (Math.abs((double)x - bucketX) < Math.abs((double)x - tickX)) {
                visitor.visit(this.tickFor(this.xBucketRange, bucketIndex));
            } else {
                visitor.visit(this.tickFor(this.xTickRange, tickIndex));
            }
        }
    }

    private IChartInfoVisitor.ITick tickFor(final SubdividedQuantityRange xRange, final int index) {
        return new IChartInfoVisitor.ITick(){

            @Override
            public IDisplayable getValue() {
                return xRange.getSubdivider(index);
            }

            @Override
            public Point2D getTarget() {
                return new Point(XYChart.this.xOffset + (int)xRange.getSubdividerPixel(index), XYChart.this.rendererResult.getHeight() - 1);
            }
        };
    }
}

