/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.dial;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.dial.IDialInformationProvider;

public final class DialInformationViewer
extends Composite {
    private final Map<String, Object> m_inputs = new LinkedHashMap<String, Object>();
    private final FormToolkit m_toolkit;

    public DialInformationViewer(Composite parent, FormToolkit toolkit, int style) {
        super(parent, style);
        this.m_toolkit = toolkit;
        this.addTraverseListener(new SimpleTraverseListener(true));
    }

    public void setProviders(IDialInformationProvider ... providers) {
        this.disposeWidgets();
        this.createWidgets(providers);
        this.refresh();
    }

    public boolean setInput(String identifier, Object input) {
        return this.m_inputs.put(identifier, input) != input;
    }

    public void refresh() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            if (widget instanceof DialInformationWidget) {
                DialInformationWidget info = (DialInformationWidget)widget;
                info.setInput(this.getInput(info.m_provider.getId()));
            }
            ++n2;
        }
    }

    private Object getInput(String id) {
        return this.m_inputs.get(id);
    }

    private void createWidgets(IDialInformationProvider ... providers) {
        int columnIndex = 0;
        IDialInformationProvider[] iDialInformationProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IDialInformationProvider info = iDialInformationProviderArray[n2];
            TableWrapData td = new TableWrapData(256, 16);
            Control dialInfoWidget = this.createWidget(this.calculateStyle(columnIndex, providers.length), info);
            dialInfoWidget.setLayoutData((Object)td);
            ++columnIndex;
            ++n2;
        }
        this.setLayout((Layout)DialInformationViewer.createWidgetLayout(providers.length));
        this.layout(true, true);
    }

    private Control createWidget(int style, IDialInformationProvider provider) {
        DialInformationWidget widget = new DialInformationWidget(this, style, provider);
        this.m_toolkit.adapt((Composite)widget);
        FocusTracker.enableFocusTracking((Composite)widget);
        return widget;
    }

    private static TableWrapLayout createWidgetLayout(int columnCount) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = true;
        return layout;
    }

    private int calculateStyle(int columnIndex, int columnCount) {
        if (columnCount > 1) {
            if (columnIndex == 0) {
                return 131072;
            }
            if (columnIndex == columnCount - 1) {
                return 16384;
            }
        }
        return 0x1000000;
    }

    private void disposeWidgets() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            widget.dispose();
            ++n2;
        }
    }

    private static class DialInformationWidget
    extends CLabel {
        private final IDialInformationProvider m_provider;

        public DialInformationWidget(Composite parent, int style, IDialInformationProvider provider) {
            super(parent, style);
            this.setLeftMargin(5);
            this.setRightMargin(5);
            this.m_provider = provider;
        }

        public void setInput(Object input) {
            String text = String.valueOf(this.m_provider.getName(input)) + ' ' + this.m_provider.getValue(input);
            this.setText(text);
            this.setToolTipText(this.m_provider.getDescription(input));
            this.update();
        }
    }
}

