/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.handlers;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.misc.ClipboardManager;

public class CopySelectionAction
extends SelectionProviderAction {
    static final Transfer[] TEXT_TRANSFER = new Transfer[]{TextTransfer.getInstance()};
    private final Function<IStructuredSelection, String> selectionFormat;

    public CopySelectionAction(StructuredViewer viewer, final Function<IStructuredSelection, Stream<String>> selectionFormat) {
        this(new Function<IStructuredSelection, String>(){

            @Override
            public String apply(IStructuredSelection selection) {
                return ((Stream)selectionFormat.apply(selection)).collect(Collectors.joining());
            }
        }, viewer);
    }

    public CopySelectionAction(Function<IStructuredSelection, String> selectionFormat, StructuredViewer viewer) {
        super((ISelectionProvider)viewer, null);
        ActionToolkit.convertToCommandAction((IAction)this, "org.eclipse.ui.edit.copy");
        this.setEnabled(false);
        this.selectionFormat = selectionFormat;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }

    public void run() {
        String content = this.selectionFormat.apply(this.getStructuredSelection());
        ClipboardManager.setClipboardContents(new Object[]{content}, TEXT_TRANSFER);
    }
}

