/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.handlers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.ui.common.util.Environment;

public class MCContextMenuManager
extends MenuManager {
    public static final String GROUP_TOP = "group.top";
    public static final String GROUP_VIEWER_SETUP = "group.viewerSetup";
    public static final String GROUP_NEW = "group.new";
    public static final String GROUP_OPEN = "group.open";
    public static final String GROUP_OPEN_WITH = "group.openWith";
    public static final String GROUP_EDIT = "group.edit";
    public static final String GROUP_ADDITIONS = "additions";
    public static final String GROUP_PROPETIES = "group.properties";

    public static MCContextMenuManager create(Control control) {
        return MCContextMenuManager.create(control, "MCContextMenuManager");
    }

    public static MCContextMenuManager create(Control control, String id) {
        final MCContextMenuManager mm = new MCContextMenuManager(id);
        control.setMenu(mm.createContextMenu(control));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                mm.dispose();
            }
        });
        return mm;
    }

    public MCContextMenuManager(String id) {
        this(id, id);
    }

    public MCContextMenuManager(String name, String id) {
        super(name, id);
        this.initialize(id);
    }

    public void addAll(IContributionItem ... items) {
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem i = iContributionItemArray[n2];
            this.add(i);
            ++n2;
        }
    }

    protected void initialize(String id) {
        if (Environment.isDebug()) {
            class ExtensionURIAction
            extends Action {
                public ExtensionURIAction(String string) {
                    super("[popup:" + string + "]");
                }
            }
            this.add((IAction)new ExtensionURIAction(id));
        }
        this.addSeparator(GROUP_TOP);
        this.addSeparator(GROUP_VIEWER_SETUP);
        this.addSeparator(GROUP_NEW);
        this.addSeparator(GROUP_OPEN);
        this.addSeparator(GROUP_EDIT);
        this.addSeparator(GROUP_ADDITIONS);
        this.addSeparator(GROUP_PROPETIES);
    }

    private void addSeparator(String separatorId) {
        if (Environment.isDebug()) {
            this.add((IContributionItem)new Separator("dummy"));
            this.add((IAction)new DebugSeparatorAction(separatorId));
            this.add((IContributionItem)new GroupMarker(separatorId));
        } else {
            this.add((IContributionItem)new Separator(separatorId));
        }
    }

    static class DebugSeparatorAction
    extends Action {
        DebugSeparatorAction(String text) {
            super("[" + text + "]");
        }
    }
}

