/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.common.util.Environment;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.AwtCanvas;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.PatternFly;

public class ChartTextCanvas
extends Canvas {
    private int laneHeight;
    private int savedLaneHeight;
    private int minLaneHeight = -1;
    private int numItems = 0;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private List<Rectangle2D> highlightRects;
    private final double xScale;
    private final double yScale;
    public final AwtCanvas awtCanvas;
    private boolean awtNeedsRedraw;
    private Runnable selectionListener;
    private IPropertyChangeListener aaListener;
    private XYChart awtChart;
    private ChartCanvas chartCanvas;
    private MCContextMenuManager chartMenu;
    private Object hoveredItemData;

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    private int getNumItems() {
        return this.numItems;
    }

    void setOverviewLaneHeight() {
        this.savedLaneHeight = this.laneHeight;
        this.setLaneHeight(-1);
    }

    void adjustLaneHeight(int amount) {
        if (this.laneHeight == -1) {
            this.restoreLaneHeight();
        }
        this.laneHeight = Math.max(this.minLaneHeight, this.laneHeight + amount);
    }

    void setLaneHeight(int height) {
        this.laneHeight = height;
    }

    void restoreLaneHeight() {
        this.laneHeight = this.savedLaneHeight;
    }

    void resetLaneHeight() {
        if (this.minLaneHeight != -1) {
            this.laneHeight = this.minLaneHeight = this.chartCanvas.initMinLaneHeight();
        }
    }

    public ChartTextCanvas(Composite parent) {
        super(parent, 262144);
        this.xScale = (double)Display.getDefault().getDPI().x / Environment.getNormalDPI();
        this.yScale = (double)Display.getDefault().getDPI().y / Environment.getNormalDPI();
        this.awtCanvas = new AwtCanvas();
        this.numItems = 0;
        this.addPaintListener(new Painter());
        Selector selector = new Selector();
        this.addMouseListener((MouseListener)selector);
        this.addMouseMoveListener(selector);
        FocusTracker.enableFocusTracking((Composite)this);
        this.addKeyListener(new KeyNavigator());
        this.aaListener = new AntiAliasingListener();
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.aaListener);
        this.addDisposeListener(e -> UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.aaListener));
        ((ScrolledComposite)this.getParent()).getVerticalBar().addListener(13, e -> this.vBarScroll());
    }

    private void vBarScroll() {
        if (this.chartCanvas != null) {
            Point location = ((ScrolledComposite)this.getParent()).getOrigin();
            this.chartCanvas.syncScroll(location);
        }
    }

    public IMenuManager getContextMenu() {
        if (this.chartMenu == null) {
            this.chartMenu = MCContextMenuManager.create((Control)this);
            this.chartMenu.addMenuListener(manager -> this.clearHighlightRects());
        }
        return this.chartMenu;
    }

    private void render(Graphics2D context, int width, int height) {
        if (this.awtChart != null) {
            this.awtChart.renderTextCanvasText(context, width, height);
        }
    }

    public Object getHoveredItemData() {
        return this.hoveredItemData;
    }

    public void setHoveredItemData(Object data) {
        this.hoveredItemData = data;
    }

    void resetHoveredItemData() {
        this.hoveredItemData = null;
    }

    public void syncHighlightedRectangles(List<Rectangle2D> newRects) {
        this.highlightRects = newRects;
        this.redraw();
    }

    private void updateHighlightRects() {
        this.infoAt(new IChartInfoVisitor.Adapter(){

            @Override
            public void hover(Object data) {
                if (data != null) {
                    ChartTextCanvas.this.setHoveredItemData(data);
                }
            }
        }, this.lastMouseX, this.lastMouseY);
        this.redraw();
        if (this.chartCanvas != null) {
            this.chartCanvas.syncHighlightedRectangles(this.highlightRects);
        }
    }

    private void clearHighlightRects() {
        if (this.highlightRects != null) {
            this.highlightRects = null;
            this.redraw();
        }
    }

    public void select(int x1, int x2, int y1, int y2, boolean clear) {
        Point p1 = this.chartCanvas.translateDisplayToImageCoordinates(x1, y1);
        Point p2 = this.chartCanvas.translateDisplayToImageCoordinates(x2, y2);
        if (this.awtChart != null && this.awtChart.select(p1.x, p2.x, p1.y, p2.y, clear)) {
            this.redrawChartText();
            this.redrawChart();
        }
    }

    private void toggleSelect(int x, int y) {
        Point p = this.chartCanvas.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            if (!this.awtChart.select(p.x, p.x, p.y, p.y, true)) {
                this.awtChart.clearSelection();
            }
            this.redrawChartText();
            this.redrawChart();
        }
    }

    public void setChart(XYChart awtChart) {
        this.awtChart = awtChart;
        this.notifyListener();
    }

    public void setChartCanvas(ChartCanvas chartCanvas) {
        this.chartCanvas = chartCanvas;
    }

    public void syncScroll(Point scrollPoint) {
        ((ScrolledComposite)this.getParent()).setOrigin(scrollPoint);
    }

    public void replaceRenderer(IXDataRenderer rendererRoot) {
        assert (this.awtChart != null);
        this.awtChart.setRendererRoot(rendererRoot);
        this.notifyListener();
        this.redrawChartText();
    }

    public void setSelectionListener(Runnable selectionListener) {
        this.selectionListener = selectionListener;
    }

    private void notifyListener() {
        if (this.selectionListener != null) {
            this.selectionListener.run();
        }
    }

    public void infoAt(IChartInfoVisitor visitor, int x, int y) {
        Point p = this.chartCanvas.translateDisplayToImageCoordinates(x, y);
        if (this.awtChart != null) {
            this.awtChart.infoAt(visitor, p.x, p.y);
        }
    }

    public void redrawChartText() {
        this.awtNeedsRedraw = true;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ChartTextCanvas.this.isDisposed()) {
                    ChartTextCanvas.this.redraw();
                }
            }
        });
    }

    private void redrawChart() {
        if (this.chartCanvas != null) {
            this.chartCanvas.redrawChart();
        }
    }

    private class AntiAliasingListener
    implements IPropertyChangeListener {
        private AntiAliasingListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ChartTextCanvas.this.redrawChartText();
        }
    }

    class KeyNavigator
    implements KeyListener {
        KeyNavigator() {
        }

        public void keyPressed(KeyEvent event) {
            char cfr_ignored_0 = event.character;
            switch (event.keyCode) {
                case 27: {
                    ChartTextCanvas.this.awtChart.clearSelection();
                    if (ChartTextCanvas.this.selectionListener != null) {
                        ChartTextCanvas.this.selectionListener.run();
                    }
                    ChartTextCanvas.this.redrawChart();
                    ChartTextCanvas.this.redrawChartText();
                }
            }
        }

        public void keyReleased(KeyEvent event) {
        }
    }

    class Painter
    implements PaintListener {
        Painter() {
        }

        public void paintControl(PaintEvent e) {
            int minScrollWidth = (int)((double)(ChartTextCanvas.this.awtChart.getLongestCharWidth() + 10) * ChartTextCanvas.this.xScale);
            int rectWidth = Math.max(minScrollWidth, ChartTextCanvas.this.getParent().getSize().x);
            Rectangle rect = new Rectangle(0, 0, rectWidth, ChartTextCanvas.this.getParent().getSize().y);
            if (ChartTextCanvas.this.getNumItems() > 0) {
                if (ChartTextCanvas.this.minLaneHeight == -1) {
                    ChartTextCanvas.this.minLaneHeight = ChartTextCanvas.this.chartCanvas.calculateMinLaneHeight(rect);
                    ChartTextCanvas.this.laneHeight = ChartTextCanvas.this.minLaneHeight;
                }
                if (ChartTextCanvas.this.getNumItems() != 1 && ChartTextCanvas.this.laneHeight * ChartTextCanvas.this.getNumItems() >= rect.height) {
                    rect.height = ChartTextCanvas.this.laneHeight * ChartTextCanvas.this.getNumItems();
                }
            }
            if (ChartTextCanvas.this.awtNeedsRedraw || !ChartTextCanvas.this.awtCanvas.hasImage(rect.width, rect.height)) {
                Graphics2D g2d = ChartTextCanvas.this.awtCanvas.getGraphics(rect.width, rect.height);
                ChartTextCanvas.this.minLaneHeight = (int)((double)g2d.getFontMetrics().getHeight() * ChartTextCanvas.this.xScale);
                Point adjusted = ChartTextCanvas.this.chartCanvas.translateDisplayToImageCoordinates(rect.width, rect.height);
                g2d.setColor(PatternFly.Palette.PF_BLACK_100.getAWTColor());
                g2d.fillRect(0, 0, adjusted.x, adjusted.y);
                ChartTextCanvas.this.render(g2d, adjusted.x, adjusted.y);
                ((ScrolledComposite)ChartTextCanvas.this.getParent()).setMinSize(rect.width, rect.height);
                if (ChartTextCanvas.this.highlightRects != null) {
                    ChartTextCanvas.this.updateHighlightRects();
                }
                ChartTextCanvas.this.awtNeedsRedraw = false;
            }
            ChartTextCanvas.this.awtCanvas.paint(e, 0, 0);
        }
    }

    private class Selector
    extends MouseAdapter
    implements MouseMoveListener,
    MouseTrackListener {
        int selectionStartX = -1;
        int selectionStartY = -1;
        Point highlightSelectionStart;
        Point highlightSelectionEnd;
        Point lastSelection;
        boolean selectionIsClick = false;
        Set<Point> highlightPoints;

        private Selector() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0 && (e.stateMask & 0x40000) == 0 && (e.stateMask & 0x20000) == 0) {
                this.highlightPoints = new HashSet<Point>();
                this.highlightPoints.add(new Point(e.x, e.y));
                this.selectionStartX = e.x;
                this.selectionStartY = e.y;
                this.highlightSelectionEnd = new Point(-1, -1);
                this.lastSelection = new Point(-1, -1);
                this.selectionIsClick = true;
                ChartTextCanvas.this.toggleSelect(this.selectionStartX, this.selectionStartY);
            } else if ((e.stateMask & 0x40000) != 0 && e.button == 1) {
                this.highlightPoints.add(new Point(e.x, e.y));
                ChartTextCanvas.this.select(e.x, e.x, e.y, e.y, false);
                if (ChartTextCanvas.this.selectionListener != null) {
                    ChartTextCanvas.this.selectionListener.run();
                }
            } else if ((e.stateMask & 0x20000) != 0 && e.button == 1) {
                if (this.highlightSelectionEnd.y == -1) {
                    this.lastSelection = this.highlightSelectionEnd = new Point(e.x, e.y);
                    if (this.highlightSelectionStart.y > this.highlightSelectionEnd.y) {
                        Point temp = this.highlightSelectionStart;
                        this.highlightSelectionStart = this.highlightSelectionEnd;
                        this.highlightSelectionEnd = temp;
                    }
                } else if (e.y > this.highlightSelectionStart.y && e.y < this.highlightSelectionEnd.y) {
                    if (e.y < this.lastSelection.y) {
                        this.highlightSelectionEnd = new Point(e.x, e.y);
                    } else if (e.y > this.lastSelection.y) {
                        this.highlightSelectionStart = new Point(e.x, e.y);
                    }
                } else if (e.y < this.highlightSelectionStart.y) {
                    this.lastSelection = this.highlightSelectionStart = new Point(e.x, e.y);
                } else if (e.y > this.highlightSelectionEnd.y) {
                    this.lastSelection = this.highlightSelectionEnd = new Point(e.x, e.y);
                }
                ChartTextCanvas.this.select(this.highlightSelectionStart.x, this.highlightSelectionStart.x, this.highlightSelectionStart.y, this.highlightSelectionEnd.y, true);
                if (ChartTextCanvas.this.selectionListener != null) {
                    ChartTextCanvas.this.selectionListener.run();
                }
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.selectionStartX >= 0) {
                ChartTextCanvas.this.highlightRects = null;
                this.updateSelectionState(e);
            } else {
                ChartTextCanvas.this.lastMouseX = e.x;
                ChartTextCanvas.this.lastMouseY = e.y;
                ChartTextCanvas.this.updateHighlightRects();
            }
        }

        private void updateSelectionState(MouseEvent e) {
            int x = e.x;
            int y = e.y;
            if (this.selectionIsClick && (Math.abs(x - this.selectionStartX) > 3 || Math.abs(y - this.selectionStartY) > 3)) {
                this.selectionIsClick = false;
            }
            if (!this.selectionIsClick) {
                ChartTextCanvas.this.select((int)((double)this.selectionStartX / ChartTextCanvas.this.xScale), (int)((double)this.selectionStartX / ChartTextCanvas.this.xScale), (int)((double)this.selectionStartY / ChartTextCanvas.this.yScale), (int)((double)y / ChartTextCanvas.this.yScale), true);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (this.selectionStartX >= 0 && e.button == 1) {
                this.updateSelectionState(e);
                this.highlightSelectionStart = new Point(this.selectionStartX, this.selectionStartY);
                this.selectionStartX = -1;
                this.selectionStartY = -1;
                if (ChartTextCanvas.this.selectionListener != null) {
                    ChartTextCanvas.this.selectionListener.run();
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            if (!ChartTextCanvas.this.getClientArea().contains(e.x, e.y)) {
                ChartTextCanvas.this.resetHoveredItemData();
            }
            ChartTextCanvas.this.clearHighlightRects();
        }

        public void mouseHover(MouseEvent e) {
        }
    }
}

