/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.ExceptionDialog;
import org.openjdk.jmc.ui.misc.Messages;

public final class DialogToolkit {
    private DialogToolkit() {
    }

    public static void showError(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static void showException(Shell shell, String title, Throwable t) {
        DialogToolkit.showException(shell, title, t.getMessage(), t);
    }

    public static void showException(Shell shell, String title, String message, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, message, t);
    }

    public static boolean openWizardWithHelp(IWizard wizard) {
        WizardDialog dlg = new WizardDialog(Display.getCurrent().getActiveShell(), wizard);
        dlg.setHelpAvailable(true);
        dlg.create();
        return dlg.open() == 0;
    }

    public static synchronized void showExceptionDialogAsync(final Display display, final String title, final String message, final Throwable t) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showException(display.getActiveShell(), title, message, t);
            }
        });
    }

    public static synchronized void showExceptionDialogAsync(Display display, String title, Throwable t) {
        DialogToolkit.showExceptionDialogAsync(display, title, t.getMessage(), t);
    }

    public static synchronized void showErrorDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showError(display.getActiveShell(), title, message);
            }
        });
    }

    public static void showWarning(Shell shell, String title, String message) {
        MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
    }

    public static synchronized void showWarningDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)title, (String)message);
            }
        });
    }

    public static boolean openQuestionOnUiThread(String title, String message) {
        return DialogToolkit.openOnUiThread(3, title, message);
    }

    public static boolean openConfirmOnUiThread(String title, String message) {
        return DialogToolkit.openOnUiThread(5, title, message);
    }

    public static boolean openOnUiThread(final int kind, final String title, final String message) {
        final boolean[] result = new boolean[1];
        DisplayToolkit.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.open((int)kind, (Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message, (int)0);
            }
        });
        return result[0];
    }

    public static boolean openQuestionWithLinkOnUiThread(final String title, final String message, final String linkText, final String url) {
        final boolean[] result = new boolean[1];
        DisplayToolkit.safeSyncExec(new Runnable(){

            @Override
            public void run() {
                QuestionLinkDialog dialog = new QuestionLinkDialog(title, message, linkText, url);
                result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    private static class QuestionLinkDialog
    extends MessageDialog {
        private final String linkText;
        private final String url;

        public QuestionLinkDialog(String dialogTitle, String dialogMessage, String linkText, String url) {
            super(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            this.linkText = linkText;
            this.url = url;
        }

        protected Control createCustomArea(Composite parent) {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayout((Layout)layout);
            Image image = this.getImage();
            Label imageLabel = new Label(composite, 0);
            image.setBackground(composite.getBackground());
            imageLabel.setImage(image);
            imageLabel.setVisible(false);
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
            Hyperlink hyperLink = toolkit.createHyperlink(composite, this.linkText, 4);
            hyperLink.setBackground(composite.getBackground());
            GridData gd = new GridData(0x1000000, 0x1000008, false, true);
            hyperLink.setLayoutData((Object)gd);
            hyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
                    }
                    catch (PartInitException partInitException) {
                        DialogToolkit.showWarning(Display.getCurrent().getActiveShell(), Messages.QuestionLinkDialog_FAILED_OPEN_BROWSER, String.valueOf(Messages.QuestionLinkDialog_FAILED_OPEN_BROWSER) + "\n\n" + linkText + " : " + url);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            });
            return hyperLink;
        }
    }
}

