/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.ui.Messages;
import org.openjdk.jmc.ui.UIPlugin;

public class MementoToolkit {
    public static IMemento fromString(String state) {
        if (state != null) {
            try {
                return XMLMemento.createReadRoot((Reader)new StringReader(state));
            }
            catch (WorkbenchException e) {
                UIPlugin.getDefault().getLogger().log(Level.WARNING, Messages.MCAbstractUIPlugin_CANNOT_LOAD_CORRUPT_STATE, e);
                return null;
            }
        }
        return null;
    }

    public static String asString(XMLMemento state) {
        StringWriter sw;
        block2: {
            sw = new StringWriter();
            try {
                state.save((Writer)sw);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.toString());
            }
        }
        return sw.toString();
    }

    public static IWritableState asWritableState(IMemento state) {
        return state == null ? null : new WritableMementoState(state);
    }

    public static IState asState(IMemento state) {
        return state == null ? null : new MementoState(state);
    }

    public static void copy(IConfigurationElement fromElement, IMemento toMemento) {
        String[] stringArray = fromElement.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            toMemento.putString(attr, fromElement.getAttribute(attr));
            ++n2;
        }
        if (fromElement.getValue() != null) {
            toMemento.putTextData(fromElement.getValue());
        }
        stringArray = fromElement.getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            MementoToolkit.copy((IConfigurationElement)child, toMemento.createChild(child.getName()));
            ++n2;
        }
    }

    public static void copy(IMemento srcElement, IMemento dstElement) {
        String[] stringArray = srcElement.getAttributeKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attrKey = stringArray[n2];
            dstElement.putString(attrKey, srcElement.getString(attrKey));
            ++n2;
        }
        if (srcElement.getTextData() != null && !srcElement.getTextData().trim().isEmpty()) {
            dstElement.putTextData(srcElement.getTextData().trim());
        }
        stringArray = srcElement.getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String srcChild = stringArray[n2];
            MementoToolkit.copy((IMemento)srcChild, dstElement.createChild(srcChild.getType()));
            ++n2;
        }
    }

    private static class MementoState
    implements IState {
        final IMemento state;

        private MementoState(IMemento state) {
            this.state = state;
        }

        public String getType() {
            return this.state.getType();
        }

        public String[] getAttributeKeys() {
            return this.state.getAttributeKeys();
        }

        public String getAttribute(String key) {
            return this.state.getString(key);
        }

        public IState getChild(String type) {
            IMemento child = this.state.getChild(type);
            return child == null ? null : new MementoState(child);
        }

        public IState[] getChildren() {
            return MementoState.childArray(this.state.getChildren());
        }

        public IState[] getChildren(String type) {
            return MementoState.childArray(this.state.getChildren(type));
        }

        private static IState[] childArray(IMemento[] mementos) {
            IState[] children = new IState[mementos.length];
            int i = 0;
            while (i < children.length) {
                children[i] = new MementoState(mementos[i]);
                ++i;
            }
            return children;
        }
    }

    private static class WritableMementoState
    implements IWritableState {
        final IMemento state;

        private WritableMementoState(IMemento state) {
            this.state = state;
        }

        public IWritableState createChild(String type) {
            return new WritableMementoState(this.state.createChild(type));
        }

        public void putString(String key, String value) {
            this.state.putString(key, value);
        }
    }
}

