/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;
import org.openjdk.jmc.ui.misc.LinearQuantityProposalProvider;

public class QuantityKindProposal {
    private static final IContentProposalProvider EMPTY_PROPOSAL = new SimpleContentProposalProvider(new String[0]);
    private static final Point POPUP_SIZE = new Point(200, 120);
    private final ContentProposalAdapter adapter;
    private final ControlDecoration decorator;

    public static QuantityKindProposal install(Text text) {
        return new QuantityKindProposal(text);
    }

    public static QuantityKindProposal install(Text text, KindOfQuantity<?> kind) {
        return QuantityKindProposal.install(text).setKind(kind);
    }

    public static <T> QuantityKindProposal install(Text text, IConstraint<T> constraint) {
        return QuantityKindProposal.install(text).setConstraint(constraint);
    }

    public static <T> QuantityKindProposal install(Combo combo, IConstraint<T> constraint) {
        return new QuantityKindProposal(combo).setConstraint(constraint);
    }

    private QuantityKindProposal(Text text) {
        this((Control)text, (IControlContentAdapter)new TextContentAdapter());
    }

    private QuantityKindProposal(Combo combo) {
        this((Control)combo, (IControlContentAdapter)new ComboContentAdapter());
    }

    private QuantityKindProposal(Control control, IControlContentAdapter contentAdapter) {
        this.adapter = new ContentProposalAdapter(control, contentAdapter, EMPTY_PROPOSAL, null, null);
        this.adapter.setPopupSize(POPUP_SIZE);
        this.adapter.setProposalAcceptanceStyle(2);
        this.decorator = ControlDecorationToolkit.createContentProposalDecorator(control);
    }

    public ControlDecoration getDecorator() {
        return this.decorator;
    }

    public QuantityKindProposal setKind(KindOfQuantity<?> kind) {
        if (kind instanceof LinearKindOfQuantity) {
            LinearQuantityProposalProvider provider = new LinearQuantityProposalProvider((LinearKindOfQuantity)kind);
            this.adapter.setContentProposalProvider((IContentProposalProvider)provider);
            this.updateDecorator(provider.units);
        } else {
            this.adapter.setContentProposalProvider(EMPTY_PROPOSAL);
            this.updateDecorator(Collections.emptyList());
        }
        return this;
    }

    public QuantityKindProposal setUnit(IUnit unit) {
        if (unit instanceof LinearUnit) {
            LinearQuantityProposalProvider provider = new LinearQuantityProposalProvider((LinearUnit)unit);
            this.adapter.setContentProposalProvider((IContentProposalProvider)provider);
            this.updateDecorator(provider.units);
        } else {
            this.setKind(unit.getContentType());
        }
        return this;
    }

    public <T> QuantityKindProposal setConstraint(IConstraint<T> constraint) {
        Object value;
        try {
            value = constraint.parsePersisted("0");
        }
        catch (QuantityConversionException e) {
            try {
                value = constraint.parsePersisted(e.getPersistablePrototype());
            }
            catch (QuantityConversionException quantityConversionException) {
                value = null;
            }
        }
        if (value instanceof IQuantity) {
            this.setUnit(((IQuantity)value).getUnit());
        } else {
            this.adapter.setContentProposalProvider(EMPTY_PROPOSAL);
            this.updateDecorator(Collections.emptyList());
        }
        return this;
    }

    private void updateDecorator(Collection<? extends IUnit> units) {
        if (this.decorator != null) {
            for (IUnit iUnit : units) {
                if (iUnit.getLocalizedSymbol().length() <= 0) continue;
                this.decorator.show();
                return;
            }
            this.decorator.hide();
        }
    }

    public void setEnabled(boolean enabled) {
        this.adapter.setEnabled(enabled);
    }

    public boolean isPopupOpen() {
        return this.adapter.isProposalPopupOpen();
    }

    public void addContentProposalListener(IContentProposalListener2 listener) {
        this.adapter.addContentProposalListener(listener);
    }

    public void removeContentProposalListener(IContentProposalListener2 listener) {
        this.adapter.removeContentProposalListener(listener);
    }

    static class Proposal
    extends ContentProposal
    implements Comparable<Proposal> {
        private final int score;

        protected Proposal(int score, String content, String label, String description) {
            super(content, label, description);
            this.score = score;
        }

        @Override
        public int compareTo(Proposal other) {
            return this.score > other.score ? -1 : (this.score == other.score ? 0 : 1);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

