/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class SizeConstrainedWizardDialog
extends WizardDialog {
    private static final int DIALOG_MAX_HEIGHT = 700;
    private static final int DIALOG_MIN_HEIGHT = 600;
    private static final int DIALOG_MAX_WIDTH = 800;
    private static final int DIALOG_MIN_WIDTH = 800;
    private int minWidth;
    private int maxWidth;
    private int minHeight;
    private int maxHeight;

    public SizeConstrainedWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setWidthConstraint(800, 800);
        this.setHeightConstraint(600, 700);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateShellSize();
        DisplayToolkit.placeDialogInCenter(this.getParentShell(), this.getShell());
        return control;
    }

    public void setWidthConstraint(int min, int max) {
        this.minWidth = min;
        this.maxWidth = max;
    }

    public void setHeightConstraint(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    protected void updateShellSize() {
        this.getShell().setMinimumSize(this.minWidth, this.minHeight);
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int width = SizeConstrainedWizardDialog.calculateConstrained(this.minWidth, size.x, this.maxWidth);
        int height = SizeConstrainedWizardDialog.calculateConstrained(this.minHeight, size.y, this.maxHeight);
        if (width != size.x || height != size.y) {
            this.getShell().setSize(new Point(width, height));
        }
    }

    private static int calculateConstrained(int min, int preferred, int max) {
        return Math.min(Math.max(min, preferred), max);
    }
}

