/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.model;

import java.util.List;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;

public class ReferrerItem {
    private long ovhd;
    private long memory;
    private int size;
    private final String referrer;
    private final boolean isBranch;
    private final List<String> commonReferrers;

    ReferrerItem(List<String> commonReferrers, String referrer, long memory, long overhead, int objectCount, boolean isBranch) {
        this.isBranch = isBranch;
        this.referrer = referrer;
        this.commonReferrers = commonReferrers;
        this.ovhd = overhead;
        this.memory = memory;
        this.size = objectCount;
    }

    ReferrerItem(List<String> parentReferrers, String referrer) {
        this(parentReferrers, referrer, 0L, 0L, 0, true);
    }

    void addObjectCluster(ObjectCluster oc) {
        this.ovhd += (long)oc.getOverhead();
        this.memory += (long)oc.getMemory();
        this.size += oc.getObjectCount();
    }

    public boolean check(RefChainElement ref) {
        for (String parentRefName : this.commonReferrers) {
            if (ref == null || !parentRefName.equals(ref.toString())) {
                return false;
            }
            ref = ref.getReferer();
        }
        return ref != null && this.referrer.equals(ref.toString());
    }

    public boolean isBranch() {
        return this.isBranch;
    }

    public int getLevel() {
        return this.commonReferrers.size();
    }

    public long getOvhd() {
        return this.ovhd;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.referrer;
    }
}

