/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.model.MemoryStatisticsItem;
import org.openjdk.jmc.joverflow.ui.swt.ArcItem;
import org.openjdk.jmc.joverflow.ui.swt.PieChart;
import org.openjdk.jmc.joverflow.ui.util.ArcAttributeChangedEvent;
import org.openjdk.jmc.joverflow.ui.util.BaseArcAttributeProvider;
import org.openjdk.jmc.joverflow.ui.util.IArcAttributeProvider;
import org.openjdk.jmc.joverflow.ui.util.IArcAttributeProviderListener;
import org.openjdk.jmc.joverflow.ui.viewers.MemoryStatisticsTableViewer;

class PieChartViewer
extends StructuredViewer {
    private final PieChart mPieChart;
    private IArcAttributeProvider mArcAttributeProvider = new BaseArcAttributeProvider();
    private ArcItem mOtherArc;
    private int mMinimumArcAngle = 0;
    private ArcItem mHighlighted;
    private MemoryStatisticsTableViewer mTableViewer;
    private List<Object> mInputs = new ArrayList<Object>();

    public PieChartViewer(Composite parent) {
        this(parent, 0);
    }

    public PieChartViewer(Composite parent, int style) {
        this(new PieChart(parent, style));
    }

    public PieChartViewer(PieChart pieChart) {
        this.mPieChart = pieChart;
        this.mPieChart.addMouseMoveListener(e -> {
            if (this.mHighlighted == this.mPieChart.getHighlightedItem()) {
                return;
            }
            this.mHighlighted = this.mPieChart.getHighlightedItem();
            if (this.mTableViewer == null) {
                return;
            }
            if (this.mHighlighted != null) {
                this.mTableViewer.setHighlightedItem((MemoryStatisticsItem)this.mHighlighted.getData());
            } else {
                this.mTableViewer.setHighlightedItem(null);
            }
        });
    }

    public PieChart getPieChart() {
        return this.mPieChart;
    }

    protected Widget doFindInputItem(Object element) {
        if (this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (this.mInputs.contains(element)) {
            return this.mPieChart.getItem(this.mInputs.indexOf(element));
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.updateItems();
    }

    protected List getSelectionFromWidget() {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.mPieChart.getHighlightedItem() == null) {
            return res;
        }
        int i = this.mPieChart.getHighlightedItemIndex();
        if (i == -1) {
            return res;
        }
        res.add(this.mInputs.get(i));
        return res;
    }

    protected void internalRefresh(Object element) {
        this.updateItems();
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.mInputs = Arrays.asList(this.getSortedChildren(this.getRoot()));
        this.mPieChart.setHighlightedItem(null);
        this.updateItems();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        if (l == null) {
            this.mPieChart.setHighlightedItem(null);
            return;
        }
        if (l.size() == 0) {
            return;
        }
        this.mPieChart.setHighlightedItem((ArcItem)this.doFindItem(l.get(0)));
        this.mPieChart.redraw();
    }

    public Control getControl() {
        return this.mPieChart;
    }

    public void setArcAttributeProvider(IArcAttributeProvider provider) {
        this.mArcAttributeProvider = this.mArcAttributeProvider == null ? new BaseArcAttributeProvider() : provider;
    }

    public IArcAttributeProvider getArcAttributeProvider() {
        return this.mArcAttributeProvider;
    }

    private void updateItems() {
        int w;
        ArcItem item;
        ArcAttributeChangedEvent event = new ArcAttributeChangedEvent(this.mArcAttributeProvider, this.mInputs.toArray());
        for (IArcAttributeProviderListener l : this.mArcAttributeProvider.getListenerList()) {
            l.arcAttributeProviderChanged(event);
        }
        int weightSum = 0;
        for (Object input : this.mInputs) {
            weightSum += this.mArcAttributeProvider.getWeight(input);
        }
        double otherAngle = 0.0;
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList<Double> angles = new ArrayList<Double>();
        for (Object input : this.mInputs) {
            double angle = 360.0 * (double)this.mArcAttributeProvider.getWeight(input) / (double)weightSum;
            if (angle >= (double)this.mMinimumArcAngle) {
                inputs.add(input);
                angles.add(angle);
                continue;
            }
            otherAngle += angle;
        }
        while (this.mPieChart.getItemCount() < inputs.size()) {
            new ArcItem(this.mPieChart, 0);
        }
        while (inputs.size() < this.mPieChart.getItemCount()) {
            this.mPieChart.removeItem(this.mPieChart.getItemCount() - 1);
        }
        if (otherAngle != 0.0) {
            this.mOtherArc = new ArcItem(this.mPieChart, 0);
        }
        int angleSum = 0;
        int i = 0;
        while (i < inputs.size()) {
            Object input = inputs.get(i);
            item = this.mPieChart.getItem(i);
            w = (int)Math.round((Double)angles.get(i));
            angleSum += w;
            item.setAngle(w);
            item.setColor(this.mArcAttributeProvider.getColor(input));
            item.setData(input);
            ++i;
        }
        if (otherAngle != 0.0) {
            int w2 = 360 - angleSum;
            if (w2 > 0) {
                this.mOtherArc.setAngle(w2);
                this.mOtherArc.setColor(Display.getCurrent().getSystemColor(15));
                return;
            }
        } else {
            this.mOtherArc = null;
        }
        if (angleSum != 0 && angleSum != 360 && inputs.size() != 0) {
            i = inputs.size() - 1;
            while (i >= 0) {
                Object input = inputs.get(i);
                item = this.mPieChart.getItem(i);
                w = 360 - angleSum + (int)Math.round(360.0 * (double)this.mArcAttributeProvider.getWeight(input) / (double)weightSum);
                if (w >= 0) {
                    item.setAngle(w);
                    break;
                }
                --i;
            }
        }
    }

    public void setTableViewer(MemoryStatisticsTableViewer tableViewer) {
        this.mTableViewer = tableViewer;
    }

    public void setHighlightedItem(Object element) {
        if (element == null) {
            this.mPieChart.setHighlightedItem(null);
            return;
        }
        ArcItem[] arcItemArray = this.mPieChart.getItems();
        int n = arcItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArcItem item = arcItemArray[n2];
            if (item.getData() == element) {
                this.mPieChart.setHighlightedItem(item);
                return;
            }
            ++n2;
        }
        this.mPieChart.setHighlightedItem(null);
    }

    public void setMinimumArcAngle(int angle) {
        this.mMinimumArcAngle = angle;
    }

    protected void handleDispose(DisposeEvent event) {
        this.mArcAttributeProvider.dispose();
        super.handleDispose(event);
    }
}

