/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.model.ReferrerItem;
import org.openjdk.jmc.joverflow.ui.model.ReferrerItemBuilder;
import org.openjdk.jmc.joverflow.ui.viewers.BaseViewer;
import org.openjdk.jmc.joverflow.ui.viewers.ReferrerTreeViewer;

public class ReferrerViewer
extends BaseViewer {
    private final ReferrerTreeViewer mTreeViewer;
    private ReferrerItemBuilder mItemBuilder;
    private ReferrerItem mSelectedItem;

    public ReferrerViewer(Composite parent, int style) {
        this.mTreeViewer = new ReferrerTreeViewer(parent, style | 0x10000 | 0x800);
        this.mTreeViewer.getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    if (ReferrerViewer.this.mTreeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    IStructuredSelection selection = (IStructuredSelection)ReferrerViewer.this.mTreeViewer.getSelection();
                    ReferrerViewer.this.mSelectedItem = (ReferrerItem)selection.getFirstElement();
                    ReferrerViewer.this.notifyFilterChangedListeners();
                }
                if (e.button == 3) {
                    ReferrerViewer.this.reset();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public Control getControl() {
        return this.mTreeViewer.getControl();
    }

    public ISelection getSelection() {
        return this.mTreeViewer.getSelection();
    }

    public void refresh() {
        this.mTreeViewer.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.mTreeViewer.setSelection(selection, reveal);
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        if (this.mItemBuilder == null) {
            this.mItemBuilder = new ReferrerItemBuilder(oc, ref);
        } else {
            this.mItemBuilder.addCluster(oc, ref);
        }
    }

    @Override
    public void allIncluded() {
        if (this.mItemBuilder == null) {
            ((ReferrerTreeViewer.ReferrerTreeContentProvider)this.mTreeViewer.getContentProvider()).setInput(null);
        } else {
            ((ReferrerTreeViewer.ReferrerTreeContentProvider)this.mTreeViewer.getContentProvider()).setInput(this.mItemBuilder.buildReferrerList());
            this.mItemBuilder = null;
        }
    }

    @Override
    public void setHeapSize(long size) {
        this.mTreeViewer.setHeapSize(size);
    }

    @Override
    public void reset() {
        this.mSelectedItem = null;
        this.notifyFilterChangedListeners();
    }

    @Override
    public boolean filter(RefChainElement rce) {
        if (this.mSelectedItem == null) {
            return true;
        }
        return this.mSelectedItem.check(rce);
    }
}

