/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

import java.util.function.BiConsumer;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import org.openjdk.jmc.ui.misc.ControlDecorationToolkit;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

final class TextNode<T>
extends WidgetNode {
    private IConstraint<T> constraint;

    public TextNode(XMLModel model, XMLTagInstance textElement, IConstraint<T> constraint) {
        super(model, textElement);
        this.constraint = constraint;
    }

    @Override
    public void create(Composite parent, int horisontalSpan, final BiConsumer<Object, String> errorTracker) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(this.getLabel()) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Text text = new Text(parent, 2048);
        GridData gdText = new GridData(4, 4, true, false);
        gdText.horizontalSpan = horisontalSpan - 1;
        text.setLayoutData((Object)gdText);
        text.setText(this.getInputElement().getContent());
        text.setToolTipText(this.getDescription());
        if (this.constraint != null) {
            final ControlDecoration error = ControlDecorationToolkit.createErrorDecorator((Control)text, (boolean)false);
            error.hide();
            QuantityKindProposal.install((Text)text, this.constraint);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    try {
                        Object value = TextNode.this.constraint.parseInteractive(text.getText());
                        error.hide();
                        errorTracker.accept(this, null);
                        TextNode.this.setValue(TextNode.this.constraint.persistableString(value));
                        return;
                    }
                    catch (QuantityConversionException qce) {
                        error.setDescriptionText(qce.getLocalizedMessage());
                        error.show();
                        errorTracker.accept(this, error.getDescriptionText());
                        return;
                    }
                }
            });
        } else {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    TextNode.this.setValue(text.getText());
                }
            });
        }
    }

    @Override
    public void create(FormToolkit toolkit, Composite parent, int horisontalSpan, BiConsumer<Object, String> errorTracker) {
        this.create(parent, horisontalSpan, errorTracker);
    }
}

