/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.actions.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.ui.common.util.Filename;

public class TriggerActionHPROF
extends TriggerAction {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.triggers.actions.internal");
    private static final ObjectName HOTSPOT;
    private static final String HPROF_OPERATION_NAME = "dumpHeap";

    static {
        ObjectName hs = null;
        try {
            hs = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not create the HotSpotDiagnostic MBean ObjectName!", e);
        }
        HOTSPOT = hs;
    }

    @Override
    public void handleNotificationEvent(TriggerEvent e) throws Exception {
        String fileName = Filename.splitFilename((String)this.getSetting("filename").getString()).asRandomFilename().toString();
        Boolean onlyLive = this.getSetting("only_live").getBoolean();
        if (onlyLive == null) {
            onlyLive = Boolean.TRUE;
        }
        this.dumpHeap(e.getSource(), fileName, onlyLive);
    }

    private void dumpHeap(IConnectionHandle connectionHandle, String fileName, Boolean onlyLive) throws Exception {
        MBeanServerConnection service = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            service.invoke(HOTSPOT, HPROF_OPERATION_NAME, new Object[]{fileName, onlyLive}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
            RJMXPlugin.getDefault().getLogger().log(Level.INFO, "HPROF heap dump triggered to file " + fileName);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not invoke the hprof action!", e);
            throw e;
        }
    }

    @Override
    public boolean supportsAction(IConnectionHandle handle) {
        MBeanServerConnection service = handle.getServiceOrNull(MBeanServerConnection.class);
        if (service == null) {
            return false;
        }
        return this.hasHProfDumpOperation(service);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasHProfDumpOperation(MBeanServerConnection service) {
        try {
            MBeanInfo info = service.getMBeanInfo(HOTSPOT);
            MBeanOperationInfo[] mBeanOperationInfoArray = info.getOperations();
            int n = mBeanOperationInfoArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                MBeanOperationInfo operation = mBeanOperationInfoArray[n2];
                if (operation.getName().equals(HPROF_OPERATION_NAME) && this.hasHProfDumpSignature(operation.getSignature())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasHProfDumpSignature(MBeanParameterInfo[] parameters) {
        return parameters.length == 2 && parameters[0].getType().equals(String.class.getName()) && parameters[1].getType().equals(Boolean.TYPE.getName());
    }
}

