/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class JfrPeriodicEventsFixRule
implements IRule {
    private static final String RESULT_ID = "JfrPeriodicEventsFix";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<String> JDK_VERSION = new TypedResult("jdkVersion", "JDK Version", "The version of the JDK that produced the recording.", UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(JDK_VERSION);
    private static final JavaVersion JDK_8_U_302 = new JavaVersion(new int[]{8, 0, 302});

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String vmName = (String)items.getAggregate(Aggregators.distinctAsString((String)"jdk.JVMInformation", (IAttribute)JdkAttributes.JVM_NAME));
        if (!JavaVMVersionToolkit.isOpenJDKJVMName((String)vmName)) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("JfrPeriodicEventsFixRule_TEXT_OK")).build();
        }
        String jvmVersion = (String)items.getAggregate(Aggregators.distinctAsString((String)"jdk.JVMInformation", (IAttribute)JdkAttributes.JVM_VERSION));
        if (jvmVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (IPreferenceValueProvider)valueProvider, (String)Messages.getString("JfrPeriodicEventsFixRule_NO_JVM_VERSION_EVENTS_TEXT"));
        }
        JavaVersion usedVersion = RulesToolkit.getJavaVersion((String)jvmVersion);
        if (usedVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (IPreferenceValueProvider)valueProvider, (String)Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"));
        }
        if (!usedVersion.isGreaterOrEqualThanDisregardEa(JDK_8_U_302)) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).addResult(JDK_VERSION, (Object)jvmVersion).setSummary(Messages.getString("JfrPeriodicEventsFixRule_TEXT_WARN_SHORT")).setExplanation(Messages.getString("JfrPeriodicEventsFixRule_TEXT_WARN_LONG")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("JfrPeriodicEventsFixRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return JfrPeriodicEventsFixRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("JfrPeriodicEventsFixRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

