/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class PasswordsInSystemPropertiesRule
implements IRule {
    private static final String PWD_RESULT_ID = "PasswordsInSystemProperties";
    public static final TypedPreference<String> EXCLUDED_STRINGS_REGEXP = new TypedPreference("passwordsinsystemproperties.string.exclude.regexp", Messages.getString("PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS"), Messages.getString("PasswordsInSystemPropertiesRule_CONFIG_EXCLUDED_STRINGS_LONG"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"(passworld|passwise)");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(EXCLUDED_STRINGS_REGEXP);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.InitialSystemProperty", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedCollectionResult<String> PASSWORDS = new TypedCollectionResult("suspiciousSystemProperties", "Passwords", "Suspected passwords in system properties.", UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(PASSWORDS);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        String pwds;
        String stringExcludeRegexp = ((String)valueProvider.getPreferenceValue(EXCLUDED_STRINGS_REGEXP)).trim();
        if (!stringExcludeRegexp.isEmpty()) {
            IItemFilter matchesExclude = ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (String)stringExcludeRegexp);
            IItemFilter stringsExcludingExclude = ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.InitialSystemProperty"), ItemFilters.not((IItemFilter)matchesExclude)});
            items = items.apply(stringsExcludingExclude);
        }
        if ((pwds = RulesToolkit.findMatches((String)"jdk.InitialSystemProperty", (IItemCollection)items, (IAttribute)JdkAttributes.ENVIRONMENT_KEY, (String)"PASSW", (boolean)true)) != null && pwds.length() > 0) {
            String[] props = pwds.split(", ");
            ArrayList<String> passwords = new ArrayList<String>();
            for (String prop : props) {
                passwords.add(prop);
            }
            String explanation = Messages.getString("PasswordsInSystemPropertiesRule_TEXT_INFO_LONG");
            if (!stringExcludeRegexp.isEmpty()) {
                explanation = explanation + " " + Messages.getString("PasswordsInSystemPropertiesRule_TEXT_INFO_EXCLUDED_INFO");
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("PasswordsInSystemPropertiesRule_TEXT_INFO")).setExplanation(explanation).setSolution(Messages.getString("PasswordsInSystemPropertiesRule_TEXT_SOLUTION")).addResult(PASSWORDS, passwords).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("PasswordsInSystemPropertiesRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return PasswordsInSystemPropertiesRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return PWD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("PasswordsInSystemPropertiesRule_RULE_NAME");
    }

    public String getTopic() {
        return "system_properties";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

