/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.FileReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FileWriteRule
implements IRule {
    public static final TypedPreference<IQuantity> WRITE_WARNING_LIMIT = new TypedPreference("io.file.write.warning.limit", Messages.getString("FileWriteRule_CONFIG_WARNING_LIMIT"), Messages.getString("FileWriteRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(4000L));
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.FileWrite", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> LONGEST_WRITE_AMOUNT = new TypedResult("longestWriteAmount", "Longest Write (Amount)", "The amount read for the longest file write.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> LONGEST_WRITE_TIME = new TypedResult("longestWriteTime", "Longest Write (Time)", "The longest time it took to perform a file write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_WRITE_PATH = new TypedResult("longestWritePath", "Longest Write (Path)", "The path of the file write that took the lognest time.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IQuantity> LONGEST_TOTAL_WRITE = new TypedResult("totalWriteForLongest", "Total Write (Top File)", "The total duration of all file writes for the file with the longest write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> AVERAGE_FILE_WRITE = new TypedResult("averageFileWrite", "Average File Write", "The average duration of all file write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_FILE_WRITE = new TypedResult("totalFileWrite", "Total File Write", "The total duration of all file write.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_WRITE_AMOUNT, LONGEST_WRITE_PATH, LONGEST_WRITE_TIME, LONGEST_TOTAL_WRITE, AVERAGE_FILE_WRITE, TOTAL_FILE_WRITE);
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WRITE_WARNING_LIMIT);
    private static final String RESULT_ID = "FileWrite";

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WRITE_WARNING_LIMIT);
        IQuantity infoLimit = warningLimit.multiply(0.5);
        IItem longestEvent = (IItem)items.apply(JdkFilters.FILE_WRITE).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        IItemCollection fileWriteEvents = items.apply(JdkFilters.FILE_WRITE);
        if (longestEvent == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("FileWriteRuleFactory_TEXT_NO_EVENTS")).build();
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        Severity severity = Severity.get((double)score);
        if (severity == Severity.WARNING || severity == Severity.INFO) {
            IQuantity amountWritten = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_FILE_BYTES_WRITTEN);
            String fileName = FileReadRule.sanitizeFileName((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_PATH));
            IQuantity avgDuration = (IQuantity)fileWriteEvents.getAggregate(Aggregators.avg((String)"jdk.FileWrite", (IAttribute)JfrAttributes.DURATION));
            IQuantity totalDuration = (IQuantity)fileWriteEvents.getAggregate(Aggregators.sum((String)"jdk.FileWrite", (IAttribute)JfrAttributes.DURATION));
            IItemCollection eventsFromLongestIOPath = fileWriteEvents.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.IO_PATH, (Object)fileName));
            IQuantity totalLongestIOPath = (IQuantity)eventsFromLongestIOPath.getAggregate(Aggregators.sum((String)"jdk.FileWrite", (IAttribute)JfrAttributes.DURATION));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileWriteRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("FileWriteRuleFactory_TEXT_WARN_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_WRITE_AMOUNT, (Object)amountWritten).addResult(LONGEST_WRITE_TIME, (Object)maxDuration).addResult(LONGEST_TOTAL_WRITE, (Object)totalLongestIOPath).addResult(AVERAGE_FILE_WRITE, (Object)avgDuration).addResult(TOTAL_FILE_WRITE, (Object)totalDuration).addResult(LONGEST_WRITE_PATH, (Object)fileName).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileWriteRuleFactory_TEXT_OK")).addResult(LONGEST_WRITE_TIME, (Object)maxDuration).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return FileWriteRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FileWriteRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "file_io";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

