/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class AutoBoxingRule
extends AbstractRule {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final String SHORT = "java.lang.Short";
    private static final String LONG = "java.lang.Long";
    private static final String INTEGER = "java.lang.Integer";
    private static final String FLOAT = "java.lang.Float";
    private static final String DOUBLE = "java.lang.Double";
    private static final String CHARACTER = "java.lang.Character";
    private static final String BYTE = "java.lang.Byte";
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final Predicate<IMCMethod> IS_AUTOBOXED_PREDICATE = new Predicate<IMCMethod>(){

        @Override
        public boolean test(IMCMethod method) {
            String type = method.getType().getFullName();
            if (AutoBoxingRule.VALUE_OF_METHOD_NAME.equals(method.getMethodName())) {
                if (AutoBoxingRule.BYTE.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.CHARACTER.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.DOUBLE.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.FLOAT.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.INTEGER.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.LONG.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.SHORT.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.BOOLEAN.equals(type)) {
                    return true;
                }
            }
            return false;
        }
    };
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_INFO_LIMIT = new TypedPreference("autoboxing.ratio.info.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(20L));
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_WARNING_LIMIT = new TypedPreference("autoboxing.ratio.warning.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(80L));
    private static final Collection<TypedPreference<?>> CONFIGURATION_ATTRIBUTES = Arrays.asList(AUTOBOXING_RATIO_INFO_LIMIT, AUTOBOXING_RATIO_WARNING_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ObjectAllocationInNewTLAB", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectAllocationOutsideTLAB", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IMCType> LARGEST_ALLOCATED_TYPE = new TypedResult("largestAllocatedType", "Largest Allocated Type", "The type allocated the most.", UnitLookup.CLASS, IMCType.class);
    public static final TypedResult<IMCFrame> SECOND_FRAME_MOST_ALLOCATED = new TypedResult("secondFrameMostAllocated", "Most Common Call Site", "The most common frame calling into a boxing method.", UnitLookup.STACKTRACE_FRAME, IMCFrame.class);
    public static final TypedResult<IQuantity> BOXED_ALLOCATION_SIZE = new TypedResult("boxedAllocationSize", "Boxed Allocation Size", "The size of all allocations caused by boxing.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> LARGEST_ALLOCATED_BY_TYPE = new TypedResult("largestAllocatedByType", "Allocation by Type", "The amount allocated by boxing the most boxed type.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> BOXED_ALLOCATION_RATIO = new TypedResult("boxedAllocationRatio", "Boxed Allocation Ratio", "The percentage of all allocations caused by boxing.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LARGEST_ALLOCATED_TYPE, LARGEST_ALLOCATED_BY_TYPE, SECOND_FRAME_MOST_ALLOCATED, BOXED_ALLOCATION_SIZE, BOXED_ALLOCATION_RATIO);

    public AutoBoxingRule() {
        super("PrimitiveToObjectConversion", Messages.getString("AutoboxingRule_RULE_NAME"), "heap", CONFIGURATION_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        double autoboxingRatioInfoLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_INFO_LIMIT)).doubleValue();
        double autoboxingRatioWarningLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_WARNING_LIMIT)).doubleValue();
        IItemCollection allocationItems = items.apply(JdkFilters.ALLOC_ALL);
        FrameSeparator sep = new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false);
        StacktraceModel model = new StacktraceModel(false, sep, allocationItems);
        HashMap<IMCType, ITypedQuantity> allocationSizeByType = new HashMap<IMCType, ITypedQuantity>();
        ITypedQuantity sizeOfAllBoxedAllocations = UnitLookup.BYTE.quantity(0L);
        ITypedQuantity largestAllocatedByType = UnitLookup.BYTE.quantity(0L);
        IMCType largestAllocatedType = null;
        IMCFrame secondFrameFromMostAllocated = null;
        for (StacktraceFrame stacktraceFrame : model.getRootFork().getFirstFrames()) {
            IMCMethod method = stacktraceFrame.getFrame().getMethod();
            if (!IS_AUTOBOXED_PREDICATE.test(method)) continue;
            SimpleArray itemArray = stacktraceFrame.getItems();
            ITypedQuantity total = UnitLookup.BYTE.quantity(0L);
            for (IItem item : itemArray) {
                total = total.add((IQuantity)RulesToolkit.getValue((IItem)item, (IAccessorFactory)JdkAttributes.TOTAL_ALLOCATION_SIZE));
            }
            sizeOfAllBoxedAllocations = sizeOfAllBoxedAllocations.add((IQuantity)total);
            if (total.compareTo((Object)largestAllocatedByType) > 0) {
                largestAllocatedByType = total;
                largestAllocatedType = method.getType();
                StacktraceFrame secondFrame = null;
                StacktraceModel.Branch firstBranch = stacktraceFrame.getBranch();
                if (firstBranch.getTailFrames().length > 0) {
                    secondFrame = firstBranch.getTailFrames()[0];
                } else if (firstBranch.getEndFork().getBranchCount() > 0) {
                    secondFrame = firstBranch.getEndFork().getBranch(0).getFirstFrame();
                }
                if (secondFrame != null) {
                    secondFrameFromMostAllocated = secondFrame.getFrame();
                }
            }
            allocationSizeByType.put(method.getType(), total);
        }
        if (allocationSizeByType.size() == 0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("AutoboxingRule_RESULT_NO_AUTOBOXING")).build();
        }
        IQuantity totalAllocationSize = (IQuantity)allocationItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        double possibleAutoboxingRatio = sizeOfAllBoxedAllocations.ratioTo(totalAllocationSize);
        double score = RulesToolkit.mapExp100((double)(possibleAutoboxingRatio * 100.0), (double)autoboxingRatioInfoLimit, (double)autoboxingRatioWarningLimit);
        String mostAllocatedTypeInfo = "";
        String mostAllocatedTypeInfoLong = "";
        if (largestAllocatedType != null) {
            mostAllocatedTypeInfo = " " + Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE");
            mostAllocatedTypeInfoLong = "\n" + Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE_LONG");
        }
        String shortIntro = Messages.getString("AutoboxingRule_RESULT_AUTOBOXING_RATIO");
        String shortMessage = shortIntro + mostAllocatedTypeInfo;
        String longMessage = mostAllocatedTypeInfoLong + "\n" + Messages.getString("AutoboxingRule_RESULT_LONG");
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortMessage).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LARGEST_ALLOCATED_BY_TYPE, (Object)largestAllocatedByType).addResult(LARGEST_ALLOCATED_TYPE, (Object)largestAllocatedType).addResult(SECOND_FRAME_MOST_ALLOCATED, (Object)secondFrameFromMostAllocated).addResult(BOXED_ALLOCATION_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(possibleAutoboxingRatio)).addResult(BOXED_ALLOCATION_SIZE, (Object)totalAllocationSize).build();
    }
}

