/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class StringDeduplicationRule
extends AbstractRule {
    private static final String NEW_LINE = "\n";
    private static final IItemFilter STRING_FILTER = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (Object)"java.lang.String");
    private static final TypedPreference<String> STRING_ARRAY_ALLOCATION_FRAMES = new TypedPreference("string.array.allocation.frames", Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_FRAMES_DESC"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"java.lang.String.<init>, java.lang.StringBuffer.toString, java.lang.StringBuffer.toString, java.lang.StringUTF16.newString, java.lang.StringLatin1.newString, java.lang.StringUTF16.toBytes, java.lang.StringBuilder.toBytes");
    private static final TypedPreference<IQuantity> STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT = new TypedPreference("string.array.liveset.ratio.and.heap.usage.limit", Messages.getString("StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));
    private static final TypedPreference<IQuantity> STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT = new TypedPreference("string.array.allocation.ratio.and.heap.usage.limit", Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT"), Messages.getString("StringDeduplicationRule_STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));
    private static final Collection<TypedPreference<?>> CONFIGURATION_ATTRIBUTES = Arrays.asList(STRING_ARRAY_ALLOCATION_FRAMES, STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT, STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT);
    public static final TypedResult<IQuantity> HEAP_USAGE = new TypedResult("heapUsage", "Heap Usage Ratio", "The percentage of the heap used.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> STRING_HEAP_RATIO = new TypedResult("stringHeapRatio", "String Usage", "The percent of the heap used for String objects.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<String> INTERNAL_STRING_TYPE = new TypedResult("stringType", "Internal String Type", "The internal type used to represent Strings.", UnitLookup.PLAIN_TEXT, String.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, HEAP_USAGE, STRING_HEAP_RATIO, INTERNAL_STRING_TYPE);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.ObjectAllocationInNewTLAB", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectCount", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectCountAfterGC", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectAllocationOutsideTLAB", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.GCHeapSummary", RulesToolkit.EventAvailability.AVAILABLE).build();

    public StringDeduplicationRule() {
        super("StringDeduplication", Messages.getString("StringDeduplicationRule_RULE_NAME"), "heap", CONFIGURATION_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        JavaVersion javaVersion = RulesToolkit.getJavaVersion((IItemCollection)items);
        if (javaVersion == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).setSummary(Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION")).build();
        }
        String stringInternalArrayType = "byte[]";
        ITypedQuantity averageStringSize = UnitLookup.BYTE.quantity(50L);
        if (!javaVersion.isGreaterOrEqualThan(JavaVersionSupport.STRING_IS_BYTE_ARRAY)) {
            stringInternalArrayType = "char[]";
            Boolean compactStrings = (Boolean)items.getAggregate(JdkAggregators.COMPACT_STRINGS);
            if (Boolean.FALSE.equals(compactStrings)) {
                averageStringSize = UnitLookup.BYTE.quantity(100L);
            }
        }
        IItemFilter stringInternalArrayTypeFilter = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.OBJECT_CLASS_FULLNAME, (Object)stringInternalArrayType);
        Boolean useStringDeduplication = (Boolean)items.getAggregate(JdkAggregators.USE_STRING_DEDUPLICATION);
        if (Boolean.TRUE.equals(useStringDeduplication)) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("StringDeduplicationRule_RESULT_USE_STRING_DEDUPLICATION_ENABLED")).build();
        }
        RulesToolkit.EventAvailability objectCountAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectCount"});
        RulesToolkit.EventAvailability objectCountAfterGcAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectCountAfterGC"});
        IQuantity stringLivesetRatioAndHeapUsageLimit = (IQuantity)vp.getPreferenceValue(STRING_ARRAY_LIVESET_RATIO_AND_HEAP_USAGE_LIMIT);
        IQuantity stringAllocationRatioAndHeapUsageLimit = (IQuantity)vp.getPreferenceValue(STRING_ARRAY_ALLOCATION_RATIO_AND_HEAP_USAGE_LIMIT);
        String allocationFramesString = (String)vp.getPreferenceValue(STRING_ARRAY_ALLOCATION_FRAMES);
        IQuantity maxHeapSizeConf = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
        ITypedQuantity maxHeapSizeFlag = UnitLookup.BYTE.quantity(((IQuantity)items.getAggregate(JdkAggregators.LARGEST_MAX_HEAP_SIZE_FROM_FLAG)).longValue());
        IQuantity maxHeapSize = maxHeapSizeConf != null ? maxHeapSizeConf : maxHeapSizeFlag;
        String heapInfo = MessageFormat.format(Messages.getString("StringDeduplicationRule_RESULT_NO_MAX_HEAP_INFO"), "jdk.GCHeapConfiguration", "jdk.UnsignedLongFlag");
        ITypedQuantity heapUsedRatio = null;
        if (maxHeapSize != null) {
            IQuantity avgHeapUsed = (IQuantity)items.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
            heapUsedRatio = UnitLookup.PERCENT_UNITY.quantity(avgHeapUsed.ratioTo(maxHeapSize));
            heapInfo = Messages.getString("StringDeduplicationRule_RESULT_HEAP_USAGE");
        }
        Boolean useG1GC = (Boolean)items.getAggregate(JdkAggregators.USE_G1_GC);
        Boolean useShenandoahGC = (Boolean)items.getAggregate(JdkAggregators.USE_SHENANDOAH_GC);
        String extraCompatInfo = "";
        if (!Boolean.TRUE.equals(useG1GC) && !Boolean.TRUE.equals(useShenandoahGC)) {
            extraCompatInfo = extraCompatInfo + NEW_LINE + Messages.getString("StringDeduplicationRule_RESULT_GC_LONG");
        }
        if (objectCountAvail == RulesToolkit.EventAvailability.AVAILABLE || objectCountAfterGcAvail == RulesToolkit.EventAvailability.AVAILABLE) {
            String objectCountEventType = objectCountAvail == RulesToolkit.EventAvailability.AVAILABLE ? "jdk.ObjectCount" : "jdk.ObjectCountAfterGC";
            return this.getLiveSetRatioResult(items, stringInternalArrayType, stringInternalArrayTypeFilter, (IQuantity)averageStringSize, stringLivesetRatioAndHeapUsageLimit, objectCountEventType, heapInfo, (IQuantity)heapUsedRatio, extraCompatInfo, vp);
        }
        return this.getAllocationRatioResult(items, stringInternalArrayType, stringInternalArrayTypeFilter, stringAllocationRatioAndHeapUsageLimit, allocationFramesString, heapInfo, (IQuantity)heapUsedRatio, extraCompatInfo, vp);
    }

    private IResult getLiveSetRatioResult(IItemCollection items, String stringInternalArrayType, IItemFilter stringInternalArrayTypeFilter, IQuantity averageStringSize, IQuantity stringLivesetRatioAndHeapUsageLimit, String objectCountEventType, String heapInfo, IQuantity heapUsedRatio, String extraGcInfo, IPreferenceValueProvider vp) {
        IItemCollection objectCountItems = items.apply(ItemFilters.type((String)objectCountEventType));
        double stringMaxRatio = 0.0;
        Set gcIds = (Set)objectCountItems.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.GC_ID));
        for (IQuantity gcId : gcIds) {
            IItemCollection livesetForGc = objectCountItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_ID, (Object)gcId));
            IItemCollection stringObjectCountItems = livesetForGc.apply(STRING_FILTER);
            IQuantity stringCount = (IQuantity)stringObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.COUNT));
            if (stringCount == null || stringCount.longValue() <= 0L) continue;
            IItemCollection stringInternalArrayObjectCountItems = livesetForGc.apply(stringInternalArrayTypeFilter);
            IQuantity totalLivesetSize = (IQuantity)livesetForGc.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.HEAP_TOTAL));
            IQuantity arraySize = (IQuantity)stringInternalArrayObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.HEAP_TOTAL));
            IQuantity stringInternalArrayCount = (IQuantity)stringInternalArrayObjectCountItems.getAggregate(Aggregators.sum((IAttribute)JdkAttributes.COUNT));
            if (stringCount.compareTo((Object)stringInternalArrayCount) == 0) {
                IQuantity stringInternalArraySize = arraySize;
                double newRatio = stringInternalArraySize.ratioTo(totalLivesetSize) * 100.0;
                if (!(newRatio > stringMaxRatio)) continue;
                stringMaxRatio = newRatio;
                continue;
            }
            IQuantity averageStringInternalArraySize = averageStringSize.multiply(stringCount.longValue());
            double newMaxRatio = averageStringInternalArraySize.ratioTo(totalLivesetSize) * 100.0;
            if (!(newMaxRatio > stringMaxRatio)) continue;
            stringMaxRatio = newMaxRatio;
        }
        String description = Messages.getString("StringDeduplicationRule_RESULT_STRING_ARRAY_LIVESET_RATIO") + NEW_LINE + heapInfo;
        double scoreBase = stringMaxRatio + stringMaxRatio * (double)heapUsedRatio.longValue();
        double score = RulesToolkit.mapExp74((double)scoreBase, (double)stringLivesetRatioAndHeapUsageLimit.doubleValue());
        String recommendation = stringMaxRatio > stringLivesetRatioAndHeapUsageLimit.doubleValue() ? Messages.getString("StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION") : Messages.getString("StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION");
        String shortMessage = description + " " + recommendation;
        String longMessage = Messages.getString("StringDeduplicationRule_RESULT_LONG_DESCRIPTION") + extraGcInfo;
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortMessage).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(HEAP_USAGE, (Object)heapUsedRatio).addResult(STRING_HEAP_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(stringMaxRatio)).addResult(INTERNAL_STRING_TYPE, (Object)stringInternalArrayType).build();
    }

    private IResult getAllocationRatioResult(IItemCollection items, String stringInternalArrayType, IItemFilter stringInternalArrayTypeFilter, IQuantity stringAllocationRatioLimit, String allocationFramesString, String heapInfo, IQuantity heapUsedRatio, String extraGcInfo, IPreferenceValueProvider vp) {
        IItemFilter allocationFrameFilter;
        IItemCollection allocItems = items.apply(JdkFilters.ALLOC_ALL);
        IQuantity totalSize = (IQuantity)allocItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        IItemCollection arrayAllocItems = allocItems.apply(stringInternalArrayTypeFilter);
        IItemCollection stringInternalArrayAllocItems = arrayAllocItems.apply(allocationFrameFilter = this.getAllocationFramesFilter(allocationFramesString));
        IQuantity stringInternalArraySizeBasedOnStacktrace = (IQuantity)stringInternalArrayAllocItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        if (stringInternalArraySizeBasedOnStacktrace == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).setSummary(Messages.getString("StringDeduplicationRule_RESULT_NO_ALLOC_ITEMS")).build();
        }
        double stringAllocationRatioBasedOnStacktrace = stringInternalArraySizeBasedOnStacktrace.ratioTo(totalSize);
        double scoreBase = stringAllocationRatioBasedOnStacktrace + stringAllocationRatioBasedOnStacktrace * (double)heapUsedRatio.longValue();
        double score = RulesToolkit.mapExp74((double)scoreBase, (double)stringAllocationRatioLimit.doubleValue());
        String description = Messages.getString("StringDeduplicationRule_RESULT_STRING_ARRAY_ALLOCATION_RATIO") + NEW_LINE + heapInfo;
        String recommendation = stringAllocationRatioBasedOnStacktrace > stringAllocationRatioLimit.doubleValue() ? Messages.getString("StringDeduplicationRule_RESULT_RECOMMEND_STRING_DEDUPLICATION") : Messages.getString("StringDeduplicationRule_RESULT_DONT_RECOMMEND_STRING_DEDUPLICATION");
        String shortMessage = description + " " + recommendation;
        String longMessage = Messages.getString("StringDeduplicationRule_RESULT_LONG_DESCRIPTION") + extraGcInfo;
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortMessage).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(HEAP_USAGE, (Object)heapUsedRatio).addResult(STRING_HEAP_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(stringAllocationRatioBasedOnStacktrace)).addResult(INTERNAL_STRING_TYPE, (Object)stringInternalArrayType).build();
    }

    private IItemFilter getAllocationFramesFilter(String allocationFramesString) {
        if (allocationFramesString.replace(',', ' ').trim().isEmpty()) {
            return ItemFilters.none();
        }
        String[] allocationFrames = allocationFramesString.split(",");
        IItemFilter[] frameFilters = new IItemFilter[allocationFrames.length];
        for (int i = 0; i < frameFilters.length; ++i) {
            frameFilters[i] = ItemFilters.contains((ICanonicalAccessorFactory)JdkAttributes.STACK_TRACE_STRING, (String)allocationFrames[i].trim());
        }
        return ItemFilters.or((IItemFilter[])frameFilters);
    }
}

